package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import net.minecraft.class_2561;

public class ConfigGroupEntry extends BaseEntry<ConfigGroup> {
    protected ConfigGroupEntry(com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder builder) {
        super(builder);
    }

    @Override
    public ConfigType<ConfigGroup> getType() {
        return ConfigTypes.CONFIG_GROUP;
    }

    @Override
    public IConfigEntry<ConfigGroup> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder(this).buildInternal();
    }

    @Override
    public Codec<ConfigGroup> getCodec() {
        return this.value.getCodec();
    }

    public static com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder builder(class_2561 name, ConfigGroup defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder builder(String nameKey, ConfigGroup defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<ConfigGroup, ConfigGroupEntry, com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder> {
        public Builder(class_2561 name, ConfigGroup defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, ConfigGroup defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(ConfigGroupEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.ConfigGroupEntry.Builder self() {
            return this;
        }

        @Override
        protected ConfigGroupEntry buildInternal() {
            return new ConfigGroupEntry(this);
        }
    }
}
