package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.ApiStatus;

import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.class_2561;

@ApiStatus.Internal
public class EntryIntegerEntry extends EntryBaseEntry<Integer> {
    protected EntryIntegerEntry(com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder builder) {
        super(builder);
    }

    @Override
    public IConfigEntry<Integer> newValueInstance() {
        return IntegerEntry.builder(this.name, this.value.getValue()).build();
    }

    @Override
    public ConfigType<Map.Entry<String, Integer>> getType() {
        return ConfigTypes.ENTRY_INTEGER;
    }

    @Override
    public IConfigEntry<Map.Entry<String, Integer>> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder(this).buildInternal();
    }

    @Override
    public Codec<Map.Entry<String, Integer>> getCodec() {
        return RecordCodecBuilder.create(i -> i.group(
                Codec.STRING.fieldOf("key").forGetter(Map.Entry::getKey),
                Codec.INT.fieldOf("value").forGetter(Map.Entry::getValue)
        ).apply(i, AbstractMap.SimpleEntry::new));
    }

    public static com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder builder(class_2561 name, Map.Entry<String, Integer> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder builder(String nameKey, Map.Entry<String, Integer> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<Map.Entry<String, Integer>, EntryIntegerEntry, com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder> {
        public Builder(class_2561 name, Map.Entry<String, Integer> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, Map.Entry<String, Integer> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(EntryIntegerEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.EntryIntegerEntry.Builder self() {
            return this;
        }

        @Override
        protected EntryIntegerEntry buildInternal() {
            return new EntryIntegerEntry(this);
        }
    }
}
