/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FileConfigContainer;
import com.iafenvoy.jupiter.config.container.wrapper.RemoteConfigWrapper;
import com.iafenvoy.jupiter.network.ClientConfigNetwork;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class ConfigSelectScreen
extends Screen
implements JupiterScreen {
    private final Screen parent;
    @Nullable
    private final AbstractConfigContainer common;
    @Nullable
    private final AbstractConfigContainer client;
    @Nullable
    private final AbstractConfigContainer server;
    private final boolean displayCommon;

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public ConfigSelectScreen(Component title, Screen parent, @Nullable FileConfigContainer serverConfig, @Nullable FileConfigContainer clientConfig) {
        super(title);
        this.parent = parent;
        this.server = serverConfig;
        this.client = clientConfig;
        this.common = null;
        this.displayCommon = false;
    }

    protected ConfigSelectScreen(Component title, Screen parent, @Nullable AbstractConfigContainer common, @Nullable AbstractConfigContainer client, @Nullable AbstractConfigContainer server, boolean displayCommon) {
        super(title);
        this.parent = parent;
        this.common = common;
        this.client = client;
        this.server = server;
        this.displayCommon = displayCommon;
    }

    protected void m_7856_() {
        super.m_7856_();
        int x = this.f_96543_ / 2;
        int y = this.f_96544_ / 2;
        this.m_142416_((GuiEventListener)JupiterScreen.createButton(x - 100, y - (this.displayCommon ? 60 : 45), 200, 20, (Component)TextUtil.translatable("jupiter.screen.back", new Object[0]), button -> {
            assert (this.f_96541_ != null);
            this.f_96541_.m_91152_(this.parent);
        }));
        if (this.displayCommon) {
            Pair<Button, Consumer<Component>> commonPair = JupiterScreen.createButtonWithDynamicTooltip(this, x - 100, y - 30, 200, 20, (Component)TextUtil.translatable("jupiter.screen.common_config", new Object[0]), button -> {
                assert (this.f_96541_ != null && this.common != null);
                this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, this.common, false));
            }, (Component)TextUtil.translatable("jupiter.screen.unavailable", new Object[0]));
            boolean bl = ((Button)this.m_142416_((GuiEventListener)((Button)commonPair.getFirst()))).f_93623_ = this.common != null;
            if (this.common != null) {
                ConfigSelectScreen.handleRemoteConfig(this.common, "jupiter.screen.open_common", b -> {
                    ((Button)commonPair.getFirst()).f_93623_ = b;
                }, (Consumer)commonPair.getSecond());
            }
        }
        Pair<Button, Consumer<Component>> serverPair = JupiterScreen.createButtonWithDynamicTooltip(this, x - 100, y - (this.displayCommon ? 0 : 15), 200, 20, (Component)TextUtil.translatable("jupiter.screen.server_config", new Object[0]), button -> {
            assert (this.f_96541_ != null && this.server != null);
            this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, this.server, false));
        }, (Component)TextUtil.translatable("jupiter.screen.unavailable", new Object[0]));
        boolean bl = ((Button)this.m_142416_((GuiEventListener)((Button)serverPair.getFirst()))).f_93623_ = this.server != null;
        if (this.server != null) {
            ConfigSelectScreen.handleRemoteConfig(this.server, "jupiter.screen.open_server", b -> {
                ((Button)serverPair.getFirst()).f_93623_ = b;
            }, (Consumer)serverPair.getSecond());
        }
        Button clientButton = (Button)this.m_142416_((GuiEventListener)JupiterScreen.createButtonWithTooltip(this, x - 100, y + (this.displayCommon ? 30 : 15), 200, 20, (Component)TextUtil.translatable("jupiter.screen.client_config", new Object[0]), button -> {
            assert (this.f_96541_ != null);
            assert (this.client != null);
            this.f_96541_.m_91152_(JupiterScreen.getConfigScreen(this, this.client, true));
        }, (Component)TextUtil.translatable(this.client != null ? "jupiter.screen.open_client" : "jupiter.screen.unavailable", new Object[0])));
        clientButton.f_93623_ = this.client != null;
    }

    private static void handleRemoteConfig(AbstractConfigContainer container, String openKey, BooleanConsumer buttonActive, Consumer<Component> tooltip) {
        if (JupiterScreen.connectedToDedicatedServer()) {
            tooltip.accept((Component)TextUtil.translatable("jupiter.screen.check_server", new Object[0]));
            buttonActive.accept(false);
            ClientConfigNetwork.syncConfig(container.getConfigId(), nbt -> {
                if (nbt == null) {
                    tooltip.accept((Component)TextUtil.translatable("jupiter.screen.disable_server", new Object[0]));
                } else {
                    try {
                        container.deserializeNbt((CompoundTag)nbt);
                        tooltip.accept((Component)TextUtil.translatable(openKey, new Object[0]));
                        buttonActive.accept(true);
                    }
                    catch (Exception e) {
                        Jupiter.LOGGER.error("Failed to parse config data from server: {}", (Object)container.getConfigId(), (Object)e);
                        tooltip.accept((Component)TextUtil.translatable("jupiter.screen.error_server", new Object[0]));
                    }
                }
            });
        } else {
            tooltip.accept((Component)TextUtil.translatable(openKey, new Object[0]));
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        assert (this.f_96541_ != null);
        graphics.m_280653_(this.f_96541_.f_91062_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 2 - (this.displayCommon ? 80 : 65), -1);
    }

    public void m_7379_() {
        assert (this.f_96541_ != null);
        this.f_96541_.m_91152_(this.parent);
    }

    public boolean m_7043_() {
        return true;
    }

    public static Builder builder(String titleKey, Screen parent) {
        return new Builder(titleKey, parent);
    }

    public static Builder builder(Component title, Screen parent) {
        return new Builder(title, parent);
    }

    public static class Builder {
        private final Component title;
        private final Screen parent;
        private AbstractConfigContainer common;
        private AbstractConfigContainer client;
        private AbstractConfigContainer server;
        private boolean displayCommon = false;

        public Builder(String titleKey, Screen parent) {
            this((Component)TextUtil.translatable(titleKey, new Object[0]), parent);
        }

        public Builder(Component title, Screen parent) {
            this.title = title;
            this.parent = parent;
        }

        public Builder common(AbstractConfigContainer common) {
            this.common = JupiterScreen.connectedToDedicatedServer() ? new RemoteConfigWrapper(common) : common;
            return this.displayCommon();
        }

        public Builder displayCommon() {
            this.displayCommon = true;
            return this;
        }

        public Builder client(AbstractConfigContainer client) {
            this.client = client;
            return this;
        }

        public Builder server(AbstractConfigContainer server) {
            this.server = JupiterScreen.connectedToDedicatedServer() ? new RemoteConfigWrapper(server) : server;
            return this;
        }

        public ConfigSelectScreen build() {
            return new ConfigSelectScreen(this.title, this.parent, this.common, this.client, this.server, this.displayCommon);
        }
    }
}

