/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.BadgeRenderer;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class JupiterConfigListWidget
extends ObjectSelectionList<ConfigEntry> {
    private final JupiterConfigListScreen screen;
    private final List<ConfigEntry> entries = new ArrayList<ConfigEntry>();
    private String filter = "";

    public JupiterConfigListWidget(JupiterConfigListScreen screen, Minecraft client, int width, int height, int y) {
        super(client, width, height, y, 32);
        this.screen = screen;
    }

    public void update() {
        this.entries.clear();
        ConfigManager.getInstance().getConfigs().forEach(x -> this.entries.add(new ConfigEntry(this.screen, (AbstractConfigContainer)x)));
        this.updateEntries();
    }

    protected int scrollBarX() {
        return this.getRight() - 8;
    }

    public int getRowWidth() {
        return this.width - 4;
    }

    public void setSelected(@Nullable ConfigEntry selected) {
        super.setSelected((AbstractSelectionList.Entry)selected);
        this.screen.setOpenConfigState(this.getSelected() != null);
    }

    private void updateEntries() {
        this.clearEntries();
        this.entries.stream().filter(x -> x.match(this.filter)).forEach(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0));
        this.setScrollAmount(0.0);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        ConfigEntry entry = (ConfigEntry)this.getSelected();
        return entry != null && entry.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setFilter(String filter) {
        this.filter = filter.toLowerCase(Locale.ROOT);
        this.updateEntries();
    }

    public static class ConfigEntry
    extends ObjectSelectionList.Entry<ConfigEntry> {
        private final Minecraft client = Minecraft.getInstance();
        private final JupiterConfigListScreen screen;
        private final AbstractConfigContainer handler;

        public ConfigEntry(JupiterConfigListScreen screen, AbstractConfigContainer handler) {
            this.screen = screen;
            this.handler = handler;
        }

        public void render(@NotNull GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            graphics.drawString(this.client.font, this.handler.getTitle(), x + 65, y + 1, -1);
            graphics.drawString(this.client.font, this.handler.getConfigId().toString(), x + 65, y + 1 + 9, -8421505);
            graphics.drawString(this.client.font, this.handler.getPath(), x + 65, y + 1 + 18, -8421505);
            ConfigSource source = this.handler.getSource();
            ConfigSide side = this.handler.getSide();
            BadgeRenderer.draw(graphics, this.client.font, x + 1, y + 1, source.name(), source.color());
            BadgeRenderer.draw(graphics, this.client.font, x + 1, y + 16, (Component)TextUtil.literal(side.getDisplayText()), side.getColor());
        }

        public boolean mouseClicked(double x, double y, int button) {
            this.screen.select(this);
            return false;
        }

        public AbstractConfigContainer getConfigContainer() {
            return this.handler;
        }

        @NotNull
        public Component getNarration() {
            return TextUtil.empty();
        }

        public boolean match(String filter) {
            return this.handler.getTitle().getString().toLowerCase(Locale.ROOT).contains(filter) || this.handler.getConfigId().toString().contains(filter) || this.handler.getPath().contains(filter);
        }
    }
}

