/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.compat.ExtraConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.util.CopyOnWriteHashMap;
import java.util.Collection;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.jetbrains.annotations.NotNull;

public class ConfigManager
implements class_4013 {
    private static final ConfigManager INSTANCE = new ConfigManager();
    private final Map<class_2960, AbstractConfigContainer> configHandlers = new CopyOnWriteHashMap<class_2960, AbstractConfigContainer>();

    public static ConfigManager getInstance() {
        return INSTANCE;
    }

    public void registerConfigHandler(class_2960 id, AbstractConfigContainer container) {
        this.configHandlers.put(id, container);
        container.init();
        container.load();
    }

    public void registerConfigHandler(AbstractConfigContainer container) {
        this.registerConfigHandler(container.getConfigId(), container);
    }

    public void registerServerConfigHandler(AbstractConfigContainer container, ServerConfigManager.PermissionChecker checker) {
        this.registerConfigHandler(container);
        ServerConfigManager.registerServerConfig(container, checker);
    }

    public void registerServerConfig(AbstractConfigContainer container, ServerConfigManager.PermissionChecker checker) {
        ServerConfigManager.registerServerConfig(container, checker);
    }

    public void method_14491(@NotNull class_3300 manager) {
        ExtraConfigManager.scanConfigs();
        this.configHandlers.values().forEach(AbstractConfigContainer::load);
        Jupiter.LOGGER.info("Successfully reload {} common config(s).", (Object)this.configHandlers.size());
    }

    public Collection<AbstractConfigContainer> getConfigs() {
        return this.configHandlers.values();
    }
}

