/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.config.ConfigDataFixer;
import com.iafenvoy.jupiter.config.interfaces.ConfigEntry;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import org.slf4j.Logger;

public class ConfigGroup {
    public static final ConfigGroup EMPTY = new ConfigGroup("", (class_2561)TextUtil.empty());
    private final String id;
    private final class_2561 name;
    private final List<ConfigEntry<?>> configs;
    private Codec<ConfigGroup> cache;

    public ConfigGroup(String id, class_2561 name) {
        this(id, name, new LinkedList());
    }

    public ConfigGroup(String id, class_2561 name, List<ConfigEntry<?>> configs) {
        this.id = id;
        this.name = name;
        this.configs = configs;
    }

    public ConfigGroup addEntry(ConfigEntry<?> config) {
        this.configs.add(config);
        this.cache = null;
        return this;
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use addEntry instead")
    public ConfigGroup add(IConfigEntry<?> config) {
        this.configs.add((ConfigEntry)config);
        this.cache = null;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public class_2561 getName() {
        return this.name;
    }

    public List<ConfigEntry<?>> getConfigs() {
        return this.configs;
    }

    public ConfigGroup copy() {
        return new ConfigGroup(this.id, this.name, this.configs.stream().map(ConfigEntry::newInstance).toList());
    }

    public Codec<ConfigGroup> getCodec(ConfigDataFixer dataFixer) {
        return new EntriesCodec(this, dataFixer).codec();
    }

    public <R> DataResult<R> encode(ConfigDataFixer dataFixer, DynamicOps<R> ops) {
        if (this.cache == null) {
            this.cache = this.getCodec(dataFixer);
        }
        return this.cache.encodeStart(ops, (Object)this);
    }

    public <R> void decode(ConfigDataFixer dataFixer, DynamicOps<R> ops, R input) {
        if (this.cache == null) {
            this.cache = this.getCodec(dataFixer);
        }
        this.cache.parse(ops, input).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).orElseThrow();
    }

    private static class EntriesCodec
    extends MapCodec<ConfigGroup> {
        private final ConfigGroup parent;
        private final ConfigDataFixer dataFixer;

        private EntriesCodec(ConfigGroup parent, ConfigDataFixer dataFixer) {
            this.parent = parent;
            this.dataFixer = dataFixer;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return this.parent.configs.stream().map(ConfigEntry::getKey).filter(Objects::nonNull).map(arg_0 -> ops.createString(arg_0));
        }

        public <T> RecordBuilder<T> encode(ConfigGroup input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return input.configs.stream().reduce(prefix, (p, c) -> c.getKey() == null ? p : p.add(c.getKey(), c.encode(this.dataFixer, ops)), (a, b) -> null);
        }

        public <T> DataResult<ConfigGroup> decode(DynamicOps<T> ops, MapLike<T> input) {
            input.entries().forEach(x -> ops.getStringValue(x.getFirst()).resultOrPartial(arg_0 -> ((Logger)Jupiter.LOGGER).error(arg_0)).map(this.dataFixer::fixKey).ifPresent(s -> this.parent.configs.stream().filter(y -> Objects.equals(y.getKey(), s)).forEach(y -> y.decode(this.dataFixer, ops, x.getSecond()))));
            return DataResult.success((Object)this.parent);
        }
    }
}

