/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ClientNetworkHelper;
import com.iafenvoy.jupiter.network.payload.ConfigErrorPayload;
import com.iafenvoy.jupiter.network.payload.ConfigRequestPayload;
import com.iafenvoy.jupiter.network.payload.ConfigSyncPayload;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

public class ClientConfigNetwork {
    private static final Map<class_2960, Consumer<class_2487>> CALLBACKS = new HashMap<class_2960, Consumer<class_2487>>();

    public static void syncConfig(AbstractConfigContainer container) {
        ClientConfigNetwork.syncConfig(container.getConfigId(), container::deserializeNbt);
    }

    @Comment(value="will pass null to nbt if not allowed")
    public static void syncConfig(class_2960 id, Consumer<class_2487> callback) {
        CALLBACKS.put(id, callback);
        ClientNetworkHelper.INSTANCE.sendToServer(new ConfigRequestPayload(id));
    }

    public static void init() {
        ClientNetworkHelper.INSTANCE.registerReceiver(ConfigSyncPayload.TYPE, (client, payload) -> ClientConfigNetwork.onConfigSync(payload.id(), payload.allow(), payload.compound()));
        ClientNetworkHelper.INSTANCE.registerReceiver(ConfigErrorPayload.TYPE, (minecraft, buf) -> ClientConfigNetwork.onConfigError(minecraft));
    }

    private static Runnable onConfigSync(class_2960 id, boolean allow, class_2487 data) {
        Consumer<class_2487> callback = CALLBACKS.get(id);
        if (callback == null) {
            return null;
        }
        if (allow) {
            return () -> callback.accept(data);
        }
        return () -> callback.accept(null);
    }

    private static Runnable onConfigError(class_310 minecraft) {
        return () -> minecraft.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47586, (class_2561)TextUtil.translatable("jupiter.toast.upload_config_error_title", new Object[0]), (class_2561)TextUtil.translatable("jupiter.toast.upload_config_error_content", new Object[0])));
    }
}

