/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.interfaces;

import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;

public interface ConfigMetaProvider {
    public ResourceLocation getConfigId();

    public String getPath();

    default public ConfigSource getSource() {
        return ConfigSource.NONE;
    }

    default public Optional<Boolean> isClientSide() {
        return Optional.of(this.getSide() == ConfigSide.CLIENT);
    }

    /*
     * Enabled aggressive block sorting
     */
    default public ConfigSide getSide() {
        ConfigSide configSide;
        ConfigMetaProvider configMetaProvider = this;
        if (configMetaProvider instanceof AbstractConfigContainer) {
            AbstractConfigContainer container = (AbstractConfigContainer)configMetaProvider;
            if (ServerConfigManager.getServerConfigs().contains(container)) {
                configSide = ConfigSide.SERVER;
                return configSide;
            }
        }
        configSide = ConfigSide.CLIENT;
        return configSide;
    }

    public record SimpleProvider(ResourceLocation id, String path, boolean client) implements ConfigMetaProvider
    {
        @Override
        public ResourceLocation getConfigId() {
            return this.id;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Optional<Boolean> isClientSide() {
            return Optional.of(this.client);
        }
    }
}

