package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import net.minecraft.class_2561;

public class BooleanEntry extends BaseEntry<Boolean> {
    protected BooleanEntry(com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder builder) {
        super(builder);
    }

    @SuppressWarnings("removal")
    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public BooleanEntry(String nameKey, boolean defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public ConfigType<Boolean> getType() {
        return ConfigTypes.BOOLEAN;
    }

    @Override
    public IConfigEntry<Boolean> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder(this).buildInternal();
    }

    @Override
    public Codec<Boolean> getCodec() {
        return Codec.BOOL;
    }

    public static com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder builder(class_2561 name, boolean defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder builder(String nameKey, boolean defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<Boolean, BooleanEntry, com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder> {
        public Builder(class_2561 name, boolean defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, boolean defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(BooleanEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.BooleanEntry.Builder self() {
            return this;
        }

        @Override
        protected BooleanEntry buildInternal() {
            return new BooleanEntry(this);
        }
    }
}
