/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.ConfigListScreen;
import com.iafenvoy.jupiter.render.screen.scrollbar.HorizontalScrollBar;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ConfigContainerScreen
extends ConfigListScreen {
    private final Screen parent;
    protected final AbstractConfigContainer container;
    protected final List<TabButton> groupButtons = new ArrayList<TabButton>();
    protected final HorizontalScrollBar groupScrollBar = new HorizontalScrollBar();
    private int currentTab = 0;
    private ConfigGroup currentGroup;

    public ConfigContainerScreen(Screen parent, AbstractConfigContainer container, boolean client) {
        super(parent, TitleStack.create((Component)TextUtil.translatable(container.getTitleNameKey(), new Object[0])), container.getConfigId(), client);
        this.parent = parent;
        this.container = container;
        this.currentGroup = container.getConfigTabs().isEmpty() ? ConfigGroup.EMPTY : container.getConfigTabs().getFirst();
        this.topBorder = 60;
    }

    @Override
    protected void init() {
        this.entries = this.currentGroup.getConfigs();
        super.init();
        int x = 10;
        int y = 27;
        this.groupButtons.clear();
        List<ConfigGroup> configTabs = this.container.getConfigTabs();
        for (int i = 0; i < configTabs.size(); ++i) {
            ConfigGroup category = configTabs.get(i);
            TabButton tabButton = (TabButton)this.addRenderableWidget((GuiEventListener)new TabButton(category, x, y, this.font.width(I18n.get((String)category.getTranslateKey(), (Object[])new Object[0])) + 10, 20, button -> {
                this.currentTab = this.container.getConfigTabs().indexOf(button.group);
                this.currentGroup = button.group;
                this.rebuildWidgets();
            }));
            tabButton.active = i != this.currentTab;
            this.groupButtons.add(tabButton);
            x += tabButton.getWidth() + 2;
        }
        this.groupScrollBar.setMaxValue(Math.max(0, (x += 10) - this.width));
        this.updateTabPos();
    }

    protected void updateTabPos() {
        for (TabButton button : this.groupButtons) {
            button.updatePos(this.groupScrollBar.getValue());
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (mouseX >= 10.0 && mouseX <= (double)(this.width - 20) && mouseY >= 25.0 && mouseY <= 60.0) {
            this.groupScrollBar.setValue(this.groupScrollBar.getValue() + (scrollY > 0.0 ? -20 : 20));
            this.updateTabPos();
            return true;
        }
        return false;
    }

    @Override
    public void onClose() {
        this.container.onConfigsChanged();
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.groupScrollBar.render(graphics, mouseX, mouseY, partialTicks, 10, 50, this.width - 20, 8, this.width + this.groupScrollBar.getMaxValue());
        if (this.groupScrollBar.isDragging()) {
            this.updateTabPos();
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.groupScrollBar.wasMouseOver()) {
            this.groupScrollBar.setIsDragging(true);
            this.updateTabPos();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.groupScrollBar.setIsDragging(false);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public static class TabButton
    extends Button {
        private final ConfigGroup group;
        private final int baseX;

        public TabButton(ConfigGroup group, int baseX, int y, int width, int height, Consumer<TabButton> listener) {
            super(baseX, y, width, height, (Component)TextUtil.translatable(group.getTranslateKey(), new Object[0]), button -> listener.accept((TabButton)button), DEFAULT_NARRATION);
            this.group = group;
            this.baseX = baseX;
        }

        public void updatePos(int offsetX) {
            this.setX(this.baseX - offsetX);
        }
    }
}

