/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.container.FakeConfigContainer;
import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.WidgetBuilderManager;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ConfigListScreen
extends Screen
implements JupiterScreen {
    private final Screen parent;
    private final TitleStack titleStack;
    private final ResourceLocation id;
    private final boolean client;
    protected final List<WidgetBuilder<?>> configWidgets = new ArrayList();
    protected final VerticalScrollBar itemScrollBar = new VerticalScrollBar();
    protected List<IConfigEntry<?>> entries = List.of();
    protected int topBorder = 30;
    private int configPerPage;
    private int textMaxLength;

    public ConfigListScreen(Screen parent, TitleStack titleStack, ResourceLocation id, List<IConfigEntry<?>> entries, boolean client) {
        this(parent, titleStack, id, client);
        this.entries = entries;
    }

    public ConfigListScreen(Screen parent, TitleStack titleStack, ResourceLocation id, boolean client) {
        super((Component)TextUtil.empty());
        this.parent = parent;
        this.titleStack = titleStack;
        this.id = id;
        this.client = client;
    }

    protected void init() {
        super.init();
        this.titleStack.cacheTitle(this.width - this.font.width(this.getCurrentEditText()) - 70);
        this.addRenderableWidget((GuiEventListener)JupiterScreen.createButton(10, 5, 20, 20, (Component)TextUtil.literal("<"), button -> this.onClose()));
        this.calculateMaxItems();
        this.textMaxLength = this.entries.stream().filter(x -> x instanceof BaseEntry).map(IConfigEntry::getNameKey).map(x$0 -> I18n.get((String)x$0, (Object[])new Object[0])).map(t -> this.font.width(t)).max(Comparator.naturalOrder()).orElse(0) + 30;
        this.configWidgets.clear();
        this.configWidgets.addAll(this.entries.stream().map(c -> WidgetBuilderManager.get(new ConfigMetaProvider.SimpleProvider(this.id, "%ERROR%", this.client), c)).toList());
        this.configWidgets.forEach(b -> b.addElements(new WidgetBuilder.Context(this, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        }, this.titleStack), this.textMaxLength, 0, Math.max(10, this.width - this.textMaxLength - 30), 20));
        this.updateItemPos();
    }

    public void resize(@NotNull Minecraft minecraft, int width, int height) {
        super.resize(minecraft, width, height);
        this.calculateMaxItems();
        this.updateItemPos();
    }

    @NotNull
    public Component getTitle() {
        return this.titleStack.getTitle();
    }

    public void calculateMaxItems() {
        this.configPerPage = Math.max(0, (this.height - this.topBorder - 10) / 25);
        this.itemScrollBar.setMaxValue(Math.max(0, this.entries.size() - this.configPerPage));
    }

    public void updateItemPos() {
        int i;
        int top = this.itemScrollBar.getValue();
        for (i = 0; i < top && i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
        for (i = top; i < top + this.configPerPage && i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(true, this.topBorder + 5 + (i - top) * 25);
        }
        for (i = top + this.configPerPage; i < this.entries.size(); ++i) {
            this.configWidgets.get(i).update(false, 0);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (mouseY >= (double)this.topBorder) {
            this.itemScrollBar.setValue(this.itemScrollBar.getValue() + (scrollY > 0.0 ? -1 : 1) * 2);
            this.updateItemPos();
            return true;
        }
        return false;
    }

    public void onClose() {
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        String currentText = this.getCurrentEditText();
        int textWidth = this.font.width(currentText);
        graphics.drawString(this.font, this.getTitle(), 40, 10, -1, true);
        graphics.drawString(this.font, currentText, this.width - textWidth - 10, 10, -1);
        this.itemScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.width - 18, this.topBorder, 8, this.height - 70, (this.configPerPage + this.itemScrollBar.getMaxValue()) * 25);
        if (this.itemScrollBar.isDragging()) {
            this.updateItemPos();
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.itemScrollBar.wasMouseOver()) {
            this.itemScrollBar.setIsDragging(true);
            this.updateItemPos();
            return true;
        }
        boolean b = super.mouseClicked(mouseX, mouseY, button);
        if (!b) {
            this.setFocused(null);
        }
        return b;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.itemScrollBar.setIsDragging(false);
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    protected String getCurrentEditText() {
        if (this.client) {
            return I18n.get((String)"jupiter.screen.current_modifying_client", (Object[])new Object[0]);
        }
        if (this.entries instanceof FakeConfigContainer) {
            return I18n.get((String)"jupiter.screen.current_modifying_dedicate_server", (Object[])new Object[0]);
        }
        return I18n.get((String)"jupiter.screen.current_modifying_local_server", (Object[])new Object[0]);
    }
}

