/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.entry.EntryDoubleEntry;
import com.iafenvoy.jupiter.config.entry.MapBaseEntry;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.mojang.serialization.Codec;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Objects;

public class MapDoubleEntry
extends MapBaseEntry<Double> {
    public MapDoubleEntry(String nameKey, Map<String, Double> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Double> getValueCodec() {
        return Codec.DOUBLE;
    }

    @Override
    public IConfigEntry<Map.Entry<String, Double>> newSingleInstance(Double value, final String key, final Runnable reload) {
        return new EntryDoubleEntry(this.nameKey, new AbstractMap.SimpleEntry<String, Double>(key, value)){

            @Override
            public void reset() {
                ((Map)MapDoubleEntry.this.getValue()).remove(key);
                reload.run();
            }

            @Override
            public void setValue(Map.Entry<String, Double> value) {
                if (!Objects.equals(((Map.Entry)this.value).getKey(), value.getKey())) {
                    ((Map)MapDoubleEntry.this.getValue()).remove(((Map.Entry)this.value).getKey());
                    ((Map)MapDoubleEntry.this.getValue()).put(value.getKey(), value.getValue());
                } else if (!Objects.equals(((Map.Entry)this.value).getValue(), value.getValue())) {
                    ((Map)MapDoubleEntry.this.getValue()).put((String)((Map.Entry)this.value).getKey(), value.getValue());
                }
                super.setValue(value);
            }
        };
    }

    @Override
    public Double newValue() {
        return 0.0;
    }

    @Override
    public ConfigType<Map<String, Double>> getType() {
        return ConfigTypes.MAP_DOUBLE;
    }

    @Override
    public IConfigEntry<Map<String, Double>> newInstance() {
        return new MapDoubleEntry(this.nameKey, (Map)this.defaultValue).visible(this.visible).json(this.jsonKey);
    }
}

