/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ByteBufHelper;
import com.iafenvoy.jupiter.network.NetworkConstants;
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerConfigNetwork {
    public static void init() {
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_REQUEST_C2S, (server, player, buf) -> ServerConfigNetwork.onConfigRequest(server, player, buf.readResourceLocation()));
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_SYNC_C2S, (server, player, buf) -> ServerConfigNetwork.onConfigSync(server, player, buf.readResourceLocation(), buf.readNbt()));
    }

    private static Runnable onConfigRequest(MinecraftServer server, ServerPlayer player, ResourceLocation id) {
        CompoundTag compound;
        Jupiter.LOGGER.info("Player {} request to get config {}", (Object)player.getName().getString(), (Object)id);
        boolean b = ServerConfigManager.checkPermission(id, server, player, false);
        if (b) {
            AbstractConfigContainer data = ServerConfigManager.getConfig(id);
            assert (data != null);
            compound = data.serializeNbt();
        } else {
            compound = new CompoundTag();
        }
        FriendlyByteBuf buf = ByteBufHelper.create();
        buf.writeResourceLocation(id);
        buf.writeBoolean(b);
        buf.writeNbt((Tag)compound);
        return () -> ServerNetworkHelper.INSTANCE.sendToPlayer(player, NetworkConstants.CONFIG_SYNC_S2C, buf);
    }

    private static Runnable onConfigSync(MinecraftServer server, ServerPlayer player, ResourceLocation id, CompoundTag data) {
        Jupiter.LOGGER.info("Player {} request to change config {}", (Object)player.getName().getString(), (Object)id);
        return () -> {
            if (ServerConfigManager.checkPermission(id, server, player, true)) {
                AbstractConfigContainer container = ServerConfigManager.getConfig(id);
                if (container != null) {
                    Jupiter.LOGGER.info(data.toString());
                    container.deserializeNbt(data);
                    container.onConfigsChanged();
                    Jupiter.LOGGER.info("Player {} changed config {}", (Object)player.getName().getString(), (Object)id);
                }
            } else {
                ServerNetworkHelper.INSTANCE.sendToPlayer(player, NetworkConstants.CONFIG_ERROR_S2C, ByteBufHelper.create());
            }
        };
    }
}

