/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.compat.forgeconfigspec;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.iafenvoy.jupiter.ConfigManager;
import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.compat.forgeconfigspec.NightConfigHolder;
import com.iafenvoy.jupiter.compat.forgeconfigspec.NightConfigWrapper;
import com.iafenvoy.jupiter.config.ConfigSide;
import java.util.Collection;
import java.util.Locale;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ConfigSpecLoader {
    public static void scanConfig() {
        Collection configs = ConfigTracker.INSTANCE.fileMap().values();
        for (ModConfig config : configs) {
            try {
                CommentedConfig loadedData = config.getConfigData();
                IConfigSpec iConfigSpec = config.getSpec();
                if (!(iConfigSpec instanceof ModConfigSpec)) continue;
                ModConfigSpec spec = (ModConfigSpec)iConfigSpec;
                if (loadedData == null) continue;
                ConfigSide type = switch (config.getType()) {
                    default -> throw new MatchException(null, null);
                    case ModConfig.Type.COMMON, ModConfig.Type.STARTUP -> ConfigSide.COMMON;
                    case ModConfig.Type.CLIENT -> ConfigSide.CLIENT;
                    case ModConfig.Type.SERVER -> ConfigSide.SERVER;
                };
                UnmodifiableConfig defaults = (UnmodifiableConfig)spec.getSpec().get(type.name().toLowerCase(Locale.ROOT));
                CommentedConfig values = (CommentedConfig)loadedData.get(type.name().toLowerCase(Locale.ROOT));
                Runnable saver = () -> ((ModConfig)config).save();
                NightConfigWrapper container = new NightConfigWrapper(new NightConfigHolder(config.getModId(), type, config.getFileName(), defaults, values, saver));
                ConfigManager.getInstance().registerConfigHandler(container);
                if (config.getType() == ModConfig.Type.CLIENT) continue;
                ServerConfigManager.registerServerConfig(container, ServerConfigManager.PermissionChecker.IS_OPERATOR, false);
            }
            catch (Exception e) {
                Jupiter.LOGGER.error("Failed to load config spec {}:{}:", new Object[]{config.getModId(), config.getType().extension(), e});
            }
        }
    }
}

