/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.compat.forgeconfigspec;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.Platform;
import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.ConfigSide;
import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.entry.BooleanEntry;
import com.iafenvoy.jupiter.config.entry.ConfigGroupEntry;
import com.iafenvoy.jupiter.config.entry.DoubleEntry;
import com.iafenvoy.jupiter.config.entry.EnumEntry;
import com.iafenvoy.jupiter.config.entry.IntegerEntry;
import com.iafenvoy.jupiter.config.entry.ListBooleanEntry;
import com.iafenvoy.jupiter.config.entry.ListDoubleEntry;
import com.iafenvoy.jupiter.config.entry.ListEnumEntry;
import com.iafenvoy.jupiter.config.entry.ListIntegerEntry;
import com.iafenvoy.jupiter.config.entry.ListLongEntry;
import com.iafenvoy.jupiter.config.entry.ListStringEntry;
import com.iafenvoy.jupiter.config.entry.LongEntry;
import com.iafenvoy.jupiter.config.entry.SeparatorEntry;
import com.iafenvoy.jupiter.config.entry.StringEntry;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.TextFormatter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public final class NightConfigHolder {
    private final String modId;
    private final ConfigSide side;
    private final String fileName;
    private final UnmodifiableConfig defaults;
    private final CommentedConfig values;
    private final Runnable save;

    public NightConfigHolder(String modId, ConfigSide side, String fileName, UnmodifiableConfig defaults, CommentedConfig values, Runnable save) {
        this.modId = modId;
        this.side = side;
        this.fileName = fileName;
        this.defaults = defaults;
        this.values = values;
        this.save = save;
    }

    public ResourceLocation id() {
        return Jupiter.id(this.modId, this.side.name().toLowerCase(Locale.ROOT));
    }

    public String title() {
        return this.translatableConfig(".title", "neoforge.configuration.uitext.title." + this.side.name().toLowerCase(Locale.ROOT));
    }

    public ConfigSide getSide() {
        return this.side;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void save() {
        this.save.run();
    }

    private String getTranslationKey(String key, String fallback) {
        if (key != null && I18n.exists((String)key)) {
            return key;
        }
        key = this.modId + ".configuration." + fallback;
        if (I18n.exists((String)key)) {
            return key;
        }
        return TextFormatter.formatToTitleCase(fallback);
    }

    public String translatableConfig(String suffix, String fallback) {
        String key = this.modId + ".configuration.section." + this.fileName.replaceAll("[^a-zA-Z0-9]+", ".").replaceFirst("^\\.", "").replaceFirst("\\.$", "").toLowerCase(Locale.ENGLISH) + suffix;
        return I18n.get((String)(I18n.exists((String)key) ? key : fallback), (Object[])new Object[]{Platform.resolveModName(this.modId)});
    }

    public List<ConfigGroup> toGroups() {
        return List.of(this.buildGroup(this.id().toString(), this.title(), this.defaults, this.values));
    }

    public ConfigGroup buildGroup(String id, String groupTranslate, UnmodifiableConfig defaults, CommentedConfig values) {
        ConfigGroup group = new ConfigGroup(id, groupTranslate);
        for (UnmodifiableConfig.Entry entry : defaults.entrySet()) {
            Object entryValue = entry.getValue();
            Object value = values.get(entry.getKey());
            if (entryValue instanceof ModConfigSpec.ValueSpec) {
                ModConfigSpec.ValueSpec spec = (ModConfigSpec.ValueSpec)entryValue;
                Object defaultValue = spec.getDefault();
                String translateKey = this.getTranslationKey(spec.getTranslationKey(), entry.getKey());
                IConfigEntry<?> configEntry = this.process(values, translateKey, entry, defaultValue, value, arg_0 -> ((ModConfigSpec.ValueSpec)spec).test(arg_0));
                if (configEntry == null) {
                    Jupiter.LOGGER.warn("Cannot find suitable entry for key={}, type={} in config={}:{}", new Object[]{entry.getKey(), defaultValue.getClass().getName(), this.modId, this.side});
                    continue;
                }
                if (configEntry instanceof BaseEntry) {
                    BaseEntry baseEntry = (BaseEntry)configEntry;
                    baseEntry.tooltip(spec.getComment()).registerCallback(val -> this.values.set(entry.getKey(), val));
                }
                group.add(configEntry);
                continue;
            }
            if (!(entryValue instanceof UnmodifiableConfig)) continue;
            UnmodifiableConfig spec = (UnmodifiableConfig)entryValue;
            if (!(value instanceof CommentedConfig)) continue;
            CommentedConfig config = (CommentedConfig)value;
            String translateKey = this.getTranslationKey(entry.getKey(), entry.getKey());
            group.add(new ConfigGroupEntry(translateKey, this.buildGroup(entry.getKey(), translateKey, spec, config)));
        }
        return group;
    }

    private IConfigEntry<?> process(CommentedConfig values, String translateKey, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, Predicate<Object> validator) {
        AtomicReference<Object> holder = new AtomicReference<Object>(null);
        this.processEntry(holder, values, translateKey, entry, defaultValue, value, Boolean.class, BooleanEntry::new);
        this.processEntry(holder, values, translateKey, entry, defaultValue, value, Integer.class, IntegerEntry::new);
        this.processEntry(holder, values, translateKey, entry, defaultValue, value, Long.class, LongEntry::new);
        this.processEntry(holder, values, translateKey, entry, defaultValue, value, Double.class, DoubleEntry::new);
        this.processEntry(holder, values, translateKey, entry, defaultValue, value, String.class, StringEntry::new);
        this.processEnum(holder, values, translateKey, entry, defaultValue, value, defaultValue.getClass());
        if (Collection.class.isAssignableFrom(defaultValue.getClass())) {
            if (validator.test(List.of(Boolean.valueOf(false)))) {
                this.processCollectionEntry(holder, values, translateKey, entry, defaultValue, value, ListBooleanEntry::new);
            } else if (validator.test(List.of(Integer.valueOf(0)))) {
                this.processCollectionEntry(holder, values, translateKey, entry, defaultValue, value, ListIntegerEntry::new);
            } else if (validator.test(List.of(Long.valueOf(0L)))) {
                this.processCollectionEntry(holder, values, translateKey, entry, defaultValue, value, ListLongEntry::new);
            } else if (validator.test(List.of(Double.valueOf(0.0)))) {
                this.processCollectionEntry(holder, values, translateKey, entry, defaultValue, value, ListDoubleEntry::new);
            } else if (validator.test(List.of(""))) {
                this.processCollectionEntry(holder, values, translateKey, entry, defaultValue, value, ListStringEntry::new);
            } else {
                Optional any = ((List)defaultValue).stream().findAny();
                if (any.isPresent() && any.get().getClass().isEnum()) {
                    this.processEnumCollection(holder, values, translateKey, entry, defaultValue, value, (Enum)any.get());
                } else {
                    Jupiter.LOGGER.warn("Notice: Jupiter cannot resolve empty List<Enum> since technical issue in Java, it is recommended to add a value in default value list.");
                    holder.set(new SeparatorEntry().text("jupiter.screen.cannot_process_list_enum").tooltip(translateKey));
                }
            }
        }
        return holder.get();
    }

    private <T extends Enum<T>> void processEnum(AtomicReference<IConfigEntry<?>> reference, CommentedConfig values, String translateKey, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, Class<?> clazz) {
        if (value instanceof String) {
            String string = (String)value;
            if (clazz.isEnum()) {
                Class<?> testClazz = clazz;
                this.processEntry(reference, values, translateKey, entry, defaultValue, Enum.valueOf(testClazz, string), testClazz, EnumEntry::new);
            }
        }
    }

    private <T> void processEntry(AtomicReference<IConfigEntry<?>> reference, CommentedConfig values, String translateKey, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, Class<T> testClazz, BiFunction<String, T, BaseEntry<T>> entryProvider) {
        if (testClazz.isAssignableFrom(defaultValue.getClass()) && testClazz.isAssignableFrom(value.getClass())) {
            BaseEntry<Object> e = entryProvider.apply(translateKey, (String)defaultValue);
            e.callback(val -> values.set(entry.getKey(), val)).setValue(value);
            reference.set(e);
        }
    }

    private <T extends Enum<T>> void processEnumCollection(AtomicReference<IConfigEntry<?>> reference, CommentedConfig values, String translateKey, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, T any) {
        this.processCollectionEntry(reference, values, translateKey, entry, defaultValue, ((List)value).stream().map(x -> Enum.valueOf(any.getDeclaringClass(), x)).collect(Collectors.toList()), (k, v) -> new ListEnumEntry<Enum>((String)k, (List<Enum>)v, any));
    }

    private <T> void processCollectionEntry(AtomicReference<IConfigEntry<?>> reference, CommentedConfig values, String translateKey, UnmodifiableConfig.Entry entry, Object defaultValue, Object value, BiFunction<String, List<T>, BaseEntry<List<T>>> entryProvider) {
        BaseEntry<List<List>> e = entryProvider.apply(translateKey, List.copyOf((Collection)defaultValue));
        e.callback(val -> values.set(entry.getKey(), val)).setValue(new LinkedList((Collection)value));
        reference.set(e);
    }
}

