/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.ConfigContainerScreen;
import com.iafenvoy.jupiter.render.screen.ConfigListScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public interface JupiterScreen {
    public static final int ITEM_PER_SCROLL = 2;
    public static final int ITEM_HEIGHT = 20;
    public static final int ITEM_SEP = 5;

    public static Screen getConfigScreen(Screen parent, AbstractConfigContainer container, boolean client) {
        List<ConfigGroup> groups = container.getConfigTabs();
        if (groups.size() == 1) {
            return new ConfigListScreen(parent, TitleStack.create((Component)TextUtil.translatable(container.getTitleNameKey(), new Object[0])), container.getConfigId(), groups.getFirst().getConfigs(), client);
        }
        return new ConfigContainerScreen(parent, container, client);
    }

    public static boolean connectedToDedicatedServer() {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPacketListener handler = minecraft.getConnection();
        IntegratedServer server = minecraft.getSingleplayerServer();
        return handler != null && handler.getConnection().isConnected() && (server == null || server.isDedicatedServer());
    }

    public static Button createButton(int x, int y, int width, int height, Component text, Button.OnPress onPress) {
        return JupiterScreen.createButton(null, x, y, width, height, text, onPress, null);
    }

    public static Button createButton(Screen self, int x, int y, int width, int height, Component text, Button.OnPress onPress, @Nullable Component tooltip) {
        Button.Builder builder = Button.builder((Component)text, (Button.OnPress)onPress).bounds(x, y, width, height);
        if (tooltip != null) {
            builder.tooltip(Tooltip.create((Component)tooltip));
        }
        return builder.build();
    }
}

