/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.internal;

import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.config.container.FakeConfigContainer;
import com.iafenvoy.jupiter.render.internal.JupiterConfigListWidget;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.render.screen.ServerConfigScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class JupiterConfigListScreen
extends Screen
implements JupiterScreen {
    private final Screen parent;
    private JupiterConfigListWidget widget;
    private boolean initialized = false;

    public JupiterConfigListScreen(Screen parent) {
        super(TextUtil.translatable("jupiter.screen.config_list.title", new Object[0]));
        this.parent = parent;
    }

    protected void init() {
        super.init();
        if (!this.initialized) {
            this.initialized = true;
            this.widget = new JupiterConfigListWidget(this, this.minecraft, this.width - 80, this.height - 256, 64, 24);
        }
        this.widget.updateSize(this.width - 80, new HeaderAndFooterLayout((Screen)this, 64, 32));
        this.widget.setX(40);
        this.widget.update();
        this.addRenderableWidget((GuiEventListener)this.widget);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)TextUtil.translatable("jupiter.screen.back", new Object[0]), button -> this.onClose()).bounds(40, 40, 100, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)TextUtil.translatable("jupiter.screen.open", new Object[0]), button -> {
            JupiterConfigListWidget.ConfigEntry handler = (JupiterConfigListWidget.ConfigEntry)this.widget.getSelected();
            if (this.minecraft != null && handler != null) {
                this.minecraft.setScreen((Screen)new ServerConfigScreen(this, this.getServerConfig(handler.getConfigContainer())));
            }
        }).bounds(150, 40, 100, 20).build());
    }

    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        this.widget.render(graphics, mouseX, mouseY, delta);
        graphics.drawCenteredString(this.font, this.title, this.width / 2, 20, -1);
    }

    public void select(JupiterConfigListWidget.ConfigEntry entry) {
        this.widget.setSelected((AbstractSelectionList.Entry)entry);
    }

    public void onClose() {
        super.onClose();
        assert (this.minecraft != null);
        this.minecraft.setScreen(this.parent);
    }

    private AbstractConfigContainer getServerConfig(AbstractConfigContainer container) {
        if (!JupiterScreen.connectedToDedicatedServer()) {
            return container;
        }
        return new FakeConfigContainer(container);
    }
}

