package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.type.ConfigType;
import com.iafenvoy.jupiter.config.type.ConfigTypes;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_2561;

public class ListIntegerEntry extends ListBaseEntry<Integer> {
    protected ListIntegerEntry(com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder builder) {
        super(builder);
    }

    @Comment("Use builder instead")
    @Deprecated(forRemoval = true)
    public ListIntegerEntry(String nameKey, List<Integer> defaultValue) {
        super(nameKey, defaultValue);
    }

    @Override
    public Codec<Integer> getValueCodec() {
        return Codec.INT;
    }

    @Override
    public IConfigEntry<Integer> newSingleInstance(Integer value, int index, Runnable reload) {
        return IntegerEntry.builder(this.name, value).callback((v, r, d) -> {
            if (r) {
                this.getValue().remove(index);
                reload.run();
            } else this.getValue().set(index, v);
            this.setValue(this.getValue());
        }).buildInternal();
    }

    @Override
    public Integer newValue() {
        return 0;
    }

    @Override
    public ConfigType<List<Integer>> getType() {
        return ConfigTypes.LIST_INTEGER;
    }

    @Override
    public IConfigEntry<List<Integer>> newInstance() {
        return new com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder(this).buildInternal();
    }

    public static com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder builder(class_2561 name, List<Integer> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder(name, defaultValue);
    }

    public static com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder builder(String nameKey, List<Integer> defaultValue) {
        return new com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder(nameKey, defaultValue);
    }

    public static class Builder extends BaseEntry.Builder<List<Integer>, ListIntegerEntry, com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder> {
        public Builder(class_2561 name, List<Integer> defaultValue) {
            super(name, defaultValue);
        }

        public Builder(String nameKey, List<Integer> defaultValue) {
            super(nameKey, defaultValue);
        }

        public Builder(ListIntegerEntry parent) {
            super(parent);
        }

        @Override
        public com.iafenvoy.jupiter.config.entry.ListIntegerEntry.Builder self() {
            return this;
        }

        @Override
        protected ListIntegerEntry buildInternal() {
            return new ListIntegerEntry(this);
        }
    }
}
