package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.container.wrapper.RemoteConfigWrapper;
import com.iafenvoy.jupiter.config.entry.BaseEntry;
import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.scrollbar.VerticalScrollBar;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;

public class ConfigListScreen extends class_437 implements JupiterScreen {
    private final class_437 parent;
    private final TitleStack titleStack;
    private final class_2960 id;
    private final boolean client;
    protected final List<WidgetBuilder<?>> configWidgets = new ArrayList<>();
    protected final VerticalScrollBar entryScrollBar = new VerticalScrollBar();
    protected List<IConfigEntry<?>> entries = List.of();
    protected int topBorder = 30;
    private int configPerPage, textMaxLength;

    public ConfigListScreen(class_437 parent, TitleStack titleStack, class_2960 id, List<IConfigEntry<?>> entries, boolean client) {
        this(parent, titleStack, id, client);
        this.entries = entries;
    }

    public ConfigListScreen(class_437 parent, TitleStack titleStack, class_2960 id, boolean client) {
        super(TextUtil.empty());
        this.parent = parent;
        this.titleStack = titleStack;
        this.id = id;
        this.client = client;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        this.titleStack.cacheTitle(this.field_22789 - this.field_22793.method_1727(this.getCurrentEditText()) - 70);
        this.method_37063(JupiterScreen.createButton(10, 5, 20, ENTRY_HEIGHT, TextUtil.literal("<"), button -> this.method_25419()));
        this.calculateMaxEntries();
        this.textMaxLength = class_3532.method_15340(this.entries.stream().filter(x -> x instanceof BaseEntry).map(IConfigEntry::getName).filter(Objects::nonNull).map(t -> this.field_22793.method_27525(t)).max(Comparator.naturalOrder()).orElse(0) + 30, this.field_22789 / 2, this.field_22789 - 150);
        this.configWidgets.clear();
        this.configWidgets.addAll(this.entries.stream().map(c -> WidgetBuilderManager.get(new ConfigMetaProvider.SimpleProvider(this.id, "%ERROR%", this.client), c)).toList());
        this.configWidgets.forEach(b -> b.addElements(new WidgetBuilder.Context(this, this::method_37063, this.titleStack), this.textMaxLength, 0, Math.max(10, this.field_22789 - this.textMaxLength - 30), ENTRY_HEIGHT));
        this.updateEntryPos();
    }

    //? <=1.18.2 {
    /*protected void rebuildWidgets() {
        this.clearWidgets();
        this.init();
    }
    *///?}

    @Override
    public void method_25410(@NotNull class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.calculateMaxEntries();
        this.updateEntryPos();
    }

    @Override
    public @NotNull class_2561 method_25440() {
        return this.titleStack.getTitle();
    }

    public void calculateMaxEntries() {
        this.configPerPage = Math.max(0, (this.field_22790 - this.topBorder - 10) / (ENTRY_HEIGHT + ENTRY_SEPARATOR));
        this.entryScrollBar.setMaxValue(Math.max(0, this.entries.size() - this.configPerPage));
    }

    public void updateEntryPos() {
        int top = this.entryScrollBar.getValue();
        for (int i = 0; i < top && i < this.entries.size(); i++)
            this.configWidgets.get(i).update(false, 0);
        for (int i = top; i < top + this.configPerPage && i < this.entries.size(); i++)
            this.configWidgets.get(i).update(true, this.topBorder + ENTRY_SEPARATOR + (i - top) * (ENTRY_HEIGHT + ENTRY_SEPARATOR));
        for (int i = top + this.configPerPage; i < this.entries.size(); i++)
            this.configWidgets.get(i).update(false, 0);
    }

    @Nullable
    public IConfigEntry<?> getMouseOverEntry(int mouseX, int mouseY) {
        return this.configWidgets.stream().filter(widget -> widget.isMouseOver(mouseX, mouseY)).findFirst().map(WidgetBuilder::getConfig).orElse(null);
    }

    //? >=1.21.9 {
    /*@Override
    public boolean keyPressed(KeyEvent event) {
        int keyCode = event.key();
        *///?} else {
    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        //?}
        if (keyCode == GLFW.GLFW_KEY_ESCAPE) {
            this.method_25419();
            return true;
        }
        return super.method_25404(/*? >=1.21.9 {*//*event*//*?} else {*/keyCode, scanCode, modifiers/*?}*/);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY,/*? >=1.20.2 {*//*double scrollX,*//*?}*/ double scrollY) {
        if (super.method_25401(mouseX, mouseY,/*? >=1.20.2 {*//*scrollX,*//*?}*/ scrollY)) return true;
        if (mouseY >= this.topBorder) {
            this.entryScrollBar.setValue(this.entryScrollBar.getValue() + (scrollY > 0 ? -1 : 1) * ENTRIES_PER_SCROLL);
            this.updateEntryPos();
            return true;
        }
        return false;
    }

    @Override
    public void method_25419() {
        assert this.field_22787 != null;
        this.field_22787.method_1507(this.parent);
    }

    @Override
    public void method_25394(@NotNull /*? >=1.20 {*/class_332/*?} else {*//*PoseStack*//*?}*/ graphics, int mouseX, int mouseY, float partialTicks) {
        //? <=1.20.1 {
        this.method_25420(graphics);
        //?}
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        String currentText = this.getCurrentEditText();
        int textWidth = this.field_22793.method_1727(currentText);
        //? >=1.20 {
        graphics.method_51439(this.field_22793, this.method_25440(), 40, 10, -1, true);
        graphics.method_25303(this.field_22793, currentText, this.field_22789 - textWidth - 10, 10, -1);
        //?} else {
        /*JupiterRenderContext context = JupiterRenderContext.wrapPoseStack(graphics);
        context.drawString(this.font, this.getTitle(), 40, 10, -1);
        context.drawString(this.font, currentText, this.width - textWidth - 10, 10, -1);
        *///?}
        this.entryScrollBar.render(graphics, mouseX, mouseY, partialTicks, this.field_22789 - 18, this.topBorder, 8, this.field_22790 - this.topBorder - 10, (this.configPerPage + this.entryScrollBar.getMaxValue()) * (ENTRY_HEIGHT + ENTRY_SEPARATOR));
        if (this.entryScrollBar.isDragging()) this.updateEntryPos();
        IConfigEntry<?> entry = this.getMouseOverEntry(mouseX, mouseY);
        if (entry != null && entry.getTooltip() != null)
            //? >=1.21.6 {
            /*graphics.setTooltipForNextFrame(entry.getTooltip(), mouseX, mouseY);
             *///?} else >=1.19.3 {
            this.method_47415(entry.getTooltip());
        //?} else {
        /*this.renderTooltip(graphics, entry.getTooltip(), mouseX, mouseY);
         *///?}
    }

    //? >=1.21.9 {
    /*@Override
    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        int button = event.button();
        *///?} else {
    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        //?}
        if (button == 0 && this.entryScrollBar.wasMouseOver()) {
            this.entryScrollBar.setIsDragging(true);
            this.updateEntryPos();
            return true;
        }
        boolean b = super.method_25402(/*? >=1.21.9 {*//*event, isDoubleClick*//*?} else {*/mouseX, mouseY, button/*?}*/);
        if (!b) this.method_25395(null);
        return b;
    }

    //? >=1.21.9 {
    /*@Override
    public boolean mouseReleased(MouseButtonEvent event) {
        int button = event.button();
        *///?} else {
    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        //?}
        if (button == 0) this.entryScrollBar.setIsDragging(false);
        return super.method_25406(/*? >=1.21.9 {*//*event*//*?} else {*/mouseX, mouseY, button/*?}*/);
    }

    protected String getCurrentEditText() {
        if (this.client) return class_1074.method_4662("jupiter.screen.current_modifying_client");
        if (this.entries instanceof RemoteConfigWrapper)
            return class_1074.method_4662("jupiter.screen.current_modifying_dedicate_server");
        return class_1074.method_4662("jupiter.screen.current_modifying_local_server");
    }
}
