package com.iafenvoy.jupiter.render.screen;

import com.iafenvoy.jupiter.config.ConfigGroup;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1132;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_7919;

public interface JupiterScreen {
    int ENTRIES_PER_SCROLL = 2;
    int ENTRY_HEIGHT = 20;
    int ENTRY_SEPARATOR = 5;

    static class_437 getConfigScreen(class_437 parent, AbstractConfigContainer container, boolean client) {
        List<ConfigGroup> groups = container.getConfigTabs();
        if (groups.size() == 1) return new SingleConfigScreen(parent, container, client);
        else return new ConfigContainerScreen(parent, container, client);
    }

    static boolean connectedToDedicatedServer() {
        class_310 minecraft = class_310.method_1551();
        class_634 handler = minecraft.method_1562();
        class_1132 server = minecraft.method_1576();
        return handler != null && handler.method_48296().method_10758() && (server == null || server.method_3816());
    }

    static class_4185 createButton(int x, int y, int width, int height, class_2561 text, class_4185.class_4241 onPress) {
        return createButtonWithTooltip(null, x, y, width, height, text, onPress, null);
    }

    static class_4185 createButtonWithTooltip(class_437 self, int x, int y, int width, int height, class_2561 text, class_4185.class_4241 onPress, @Nullable class_2561 tooltip) {
        //? >=1.19.3 {
        class_4185.class_7840 builder = class_4185.method_46430(text, onPress).method_46434(x, y, width, height);
        if (tooltip != null) builder.method_46436(class_7919.method_47407(tooltip));
        return builder.method_46431();
        //?} else {
        /*if (tooltip == null) return new Button(x, y, width, height, text, onPress);
        else return new Button(x, y, width, height, text, onPress, new SimpleButtonTooltip(self, tooltip));
        *///?}
    }

    static Pair<class_4185, Consumer<class_2561>> createButtonWithDynamicTooltip(class_437 self, int x, int y, int width, int height, class_2561 text, class_4185.class_4241 onPress, class_2561 tooltip) {
        //? >=1.19.3 {
        class_4185 button = createButtonWithTooltip(self, x, y, width, height, text, onPress, tooltip);
        return Pair.of(button, c -> button.method_47400(class_7919.method_47407(c)));
        //?} else {
        /*SimpleButtonTooltip serverButtonTooltip = new SimpleButtonTooltip(self, tooltip);
       return Pair.of(new Button(x, y, width, height, text, onPress, serverButtonTooltip), serverButtonTooltip::setTooltip);
        *///?}
    }
}
