package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_4185;

public class ButtonWidgetBuilder<T> extends AbstractButtonWidgetBuilder<T> {
    private final class_4185.class_4241 action;

    public ButtonWidgetBuilder(ConfigMetaProvider provider, IConfigEntry<T> config, class_4185.class_4241 action, Supplier<class_2561> nameSupplier) {
        super(provider, config, nameSupplier);
        this.action = button -> {
            action.onPress(button);
            this.refresh();
        };
    }

    @Override
    protected class_4185 createButton(Context context, int x, int y, int width, int height) {
        return JupiterScreen.createButton(x, y, width, height, this.nameSupplier.get(), this.action);
    }
}
