package com.iafenvoy.jupiter;

import com.iafenvoy.jupiter.compat.ExtraConfigManager;
import com.iafenvoy.jupiter.compat.forgeconfigspec.ConfigSpecLoader;
import com.iafenvoy.jupiter.config.ConfigSource;
import com.iafenvoy.jupiter.internal.JupiterSettings;
import com.iafenvoy.jupiter.network.ClientConfigNetwork;
import com.iafenvoy.jupiter.network.ServerConfigNetwork;
import com.iafenvoy.jupiter.test.TestConfig;
import com.mojang.logging.LogUtils;
import net.minecraft.class_2960;
import org.slf4j.Logger;
//? >=1.20.5 {
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import com.iafenvoy.jupiter.network.payload.ConfigErrorPayload;
import com.iafenvoy.jupiter.network.payload.ConfigRequestPayload;
import com.iafenvoy.jupiter.network.payload.ConfigSyncPayload;
//?}

public final class Jupiter {
    public static final String MOD_ID = "jupiter";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init(boolean development) {
        //? >=1.20.5 {
        ServerNetworkHelper.INSTANCE.registerPayloadType(ConfigSyncPayload.TYPE, ConfigSyncPayload.CODEC);
        ServerNetworkHelper.INSTANCE.registerPayloadType(ConfigRequestPayload.TYPE, ConfigRequestPayload.CODEC);
        ServerNetworkHelper.INSTANCE.registerPayloadType(ConfigErrorPayload.TYPE, ConfigErrorPayload.CODEC);
        //?}

        ConfigManager.getInstance().registerServerConfigHandler(JupiterSettings.INSTANCE, ServerConfigManager.PermissionChecker.IS_OPERATOR);
        if (development) ConfigManager.getInstance().registerConfigHandler(new TestConfig());

        ExtraConfigManager.registerScanner(ConfigSource.NIGHT_CONFIG, ConfigSpecLoader::scanConfig);
    }

    public static void process() {
        ServerConfigNetwork.init();
    }

    public static void processClient() {
        ClientConfigNetwork.init();
        Platform.setClientSide(true);
    }

    //? forge {
    /*@SuppressWarnings("removal")
     *///?}
    public static class_2960 id(String id) {
        //? >=1.21 {
        return class_2960.method_60655(MOD_ID, id);
        //?} else {
        /*return new ResourceLocation(MOD_ID, id);
         *///?}
    }

    //? forge {
    /*@SuppressWarnings("removal")
     *///?}
    public static class_2960 id(String namespace, String id) {
        //? >=1.21 {
        return class_2960.method_60655(namespace, id);
        //?} else {
        /*return new ResourceLocation(namespace, id);
         *///?}
    }
}
