package com.iafenvoy.jupiter;

import com.iafenvoy.jupiter.compat.ExtraConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerConfigManager implements class_4013 {
    private static final Map<class_2960, ServerConfigHolder> CONFIGS = new HashMap<>();

    public static void registerServerConfig(AbstractConfigContainer data, PermissionChecker checker) {
        registerServerConfig(data, checker, false);
    }

    public static void registerServerConfig(AbstractConfigContainer data, PermissionChecker checker, boolean allowManualSync) {
        CONFIGS.put(data.getConfigId(), new ServerConfigHolder(data, checker, allowManualSync));
    }

    @Nullable
    public static AbstractConfigContainer getConfig(class_2960 id) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) return null;
        return holder.data;
    }

    public static boolean checkPermission(class_2960 id, MinecraftServer server, class_3222 player, boolean modify) {
        ServerConfigHolder holder = CONFIGS.get(id);
        if (holder == null) return false;
        return !modify && holder.allowManualSync || holder.checker.check(server, player);
    }

    public static List<AbstractConfigContainer> getServerConfigs() {
        return CONFIGS.values().stream().map(ServerConfigHolder::data).toList();
    }

    @Override
    public void method_14491(@NotNull class_3300 manager) {
        CONFIGS.values().forEach(x -> x.data.load());
        ExtraConfigManager.scanConfigs();
        Jupiter.LOGGER.info("Successfully reload {} server config(s).", CONFIGS.size());
    }

    @FunctionalInterface
    public interface PermissionChecker {
        PermissionChecker ALWAYS_TRUE = (server, player) -> true;
        PermissionChecker ALWAYS_FALSE = (server, player) -> false;
        PermissionChecker IS_DEDICATE_SERVER = (server, player) -> server.method_3816();
        PermissionChecker IS_LOCAL_GAME = (server, player) -> !IS_DEDICATE_SERVER.check(server, player);
        PermissionChecker IS_OPERATOR = (server, player) -> IS_LOCAL_GAME.check(server, player) || player.method_64475(server./*? >=1.21.9 {*//*operatorUserPermissionLevel*//*?} else {*/method_3798/*?}*/());

        boolean check(MinecraftServer server, class_3222 player);
    }

    private record ServerConfigHolder(AbstractConfigContainer data, PermissionChecker checker,
                                      boolean allowManualSync) {
    }
}
