package com.iafenvoy.jupiter.render.widget.builder;

import com.iafenvoy.jupiter.config.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.widget.WidgetBuilder;
import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.datafixers.util.Unit;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_7842;

public class SeparatorWidgetBuilder extends WidgetBuilder<Unit> {
    public SeparatorWidgetBuilder(ConfigMetaProvider provider, IConfigEntry<Unit> config) {
        super(provider, config);
    }

    @Override
    public void addElements(Context context, int x, int y, int width, int height) {
        class_327 font = this.minecraft.field_1772;
        width = width + x - 20;
        class_2561 text;
        if (this.config.getName() == null) {
            int w = font.method_1727("-"), k = 0;
            while ((k + 1) * w <= width) k++;
            text = TextUtil.literal("-".repeat(k));
        } else text = this.config.getName();
        this.textWidget = new class_7842(20, y, font.method_27525(text), height, text, font);
        context.addWidget(this.textWidget);
    }

    @Override
    public void addCustomElements(Context context, int x, int y, int width, int height) {
        //No Need
    }

    @Override
    public void updateCustom(boolean visible, int y) {
        //No Need
    }

    @Override
    public void refresh() {
        //No Need
    }
}
