/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.network;

import com.iafenvoy.jupiter.Jupiter;
import com.iafenvoy.jupiter.ServerConfigManager;
import com.iafenvoy.jupiter.config.container.AbstractConfigContainer;
import com.iafenvoy.jupiter.network.ByteBufHelper;
import com.iafenvoy.jupiter.network.NetworkConstants;
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ServerConfigNetwork {
    public static void init() {
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_REQUEST_C2S, (server, player, buf) -> ServerConfigNetwork.onConfigRequest(server, player, buf.m_130281_()));
        ServerNetworkHelper.INSTANCE.registerReceiver(NetworkConstants.CONFIG_SYNC_C2S, (server, player, buf) -> ServerConfigNetwork.onConfigSync(server, player, buf.m_130281_(), buf.m_130260_()));
    }

    private static Runnable onConfigRequest(MinecraftServer server, ServerPlayer player, ResourceLocation id) {
        CompoundTag compound;
        Jupiter.LOGGER.info("Player {} request to get config {}", (Object)player.m_7755_().getString(), (Object)id);
        boolean b = ServerConfigManager.checkPermission(id, server, player, false);
        if (b) {
            AbstractConfigContainer data = ServerConfigManager.getConfig(id);
            if (data == null) {
                compound = new CompoundTag();
                b = false;
            } else {
                compound = data.serializeNbt();
            }
        } else {
            compound = new CompoundTag();
        }
        FriendlyByteBuf buf = ByteBufHelper.create();
        buf.m_130085_(id);
        buf.writeBoolean(b);
        buf.m_130079_(compound);
        return () -> ServerNetworkHelper.INSTANCE.sendToPlayer(player, NetworkConstants.CONFIG_SYNC_S2C, buf);
    }

    private static Runnable onConfigSync(MinecraftServer server, ServerPlayer player, ResourceLocation id, CompoundTag data) {
        Jupiter.LOGGER.info("Player {} request to change config {}", (Object)player.m_7755_().getString(), (Object)id);
        return () -> {
            if (ServerConfigManager.checkPermission(id, server, player, true)) {
                AbstractConfigContainer container = ServerConfigManager.getConfig(id);
                if (container != null) {
                    Jupiter.LOGGER.info(data.toString());
                    container.deserializeNbt(data);
                    container.onConfigsChanged();
                    Jupiter.LOGGER.info("Player {} changed config {}", (Object)player.m_7755_().getString(), (Object)id);
                }
            } else {
                ServerNetworkHelper.INSTANCE.sendToPlayer(player, NetworkConstants.CONFIG_ERROR_S2C, ByteBufHelper.create());
            }
        };
    }
}

