/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render;

import com.iafenvoy.jupiter.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class JupiterRenderContext {
    private final PoseStack pose;
    private final MultiBufferSource.BufferSource bufferSource;

    private JupiterRenderContext(PoseStack pose, MultiBufferSource.BufferSource bufferSource) {
        this.pose = pose;
        this.bufferSource = bufferSource;
    }

    public static JupiterRenderContext wrapPoseStack(PoseStack poseStack) {
        Minecraft minecraft = Minecraft.m_91087_();
        return new JupiterRenderContext(poseStack, minecraft.m_91269_().m_110104_());
    }

    public void flush() {
        RenderSystem.m_69465_();
        this.bufferSource.m_109911_();
        RenderSystem.m_69482_();
    }

    public void fill(int minX, int minY, int maxX, int maxY, int color) {
        this.fill(minX, minY, maxX, maxY, 0, color);
    }

    public void fill(int minX, int minY, int maxX, int maxY, int z, int color) {
        this.fill(RenderType.m_110502_(), minX, minY, maxX, maxY, z, color);
    }

    public void fill(RenderType renderType, int minX, int minY, int maxX, int maxY, int z, int color) {
        Matrix4f matrix4f = this.pose.m_85850_().m_252922_();
        if (minX < maxX) {
            int i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            int j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        float f = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float f1 = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float f2 = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        VertexConsumer consumer = this.bufferSource.m_6299_(renderType);
        consumer.m_252986_(matrix4f, (float)minX, (float)minY, (float)z).m_85950_(f, f1, f2, f3).m_5752_();
        consumer.m_252986_(matrix4f, (float)minX, (float)maxY, (float)z).m_85950_(f, f1, f2, f3).m_5752_();
        consumer.m_252986_(matrix4f, (float)maxX, (float)maxY, (float)z).m_85950_(f, f1, f2, f3).m_5752_();
        consumer.m_252986_(matrix4f, (float)maxX, (float)minY, (float)z).m_85950_(f, f1, f2, f3).m_5752_();
        this.flush();
    }

    public void drawCenteredString(Font font, String text, int x, int y, int color) {
        this.drawCenteredString(font, (Component)TextUtil.literal(text), x, y, color);
    }

    public void drawCenteredString(Font font, Component text, int x, int y, int color) {
        this.drawString(font, text, x - font.m_92852_((FormattedText)text) / 2, y, color);
    }

    public void drawString(Font font, @NotNull String text, int x, int y, int color) {
        font.m_92750_(this.pose, text, (float)x, (float)y, color);
        this.flush();
    }

    public void drawString(Font font, Component text, int x, int y, int color) {
        font.m_92763_(this.pose, text, (float)x, (float)y, color);
        this.flush();
    }
}

