/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.render.widget;

import com.iafenvoy.jupiter.interfaces.ConfigMetaProvider;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.render.TitleStack;
import com.iafenvoy.jupiter.render.screen.JupiterScreen;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public abstract class WidgetBuilder<T>
implements JupiterScreen {
    protected final Minecraft minecraft = Minecraft.getInstance();
    protected final ConfigMetaProvider provider;
    protected final IConfigEntry<T> config;
    protected StringWidget textWidget;
    protected Button resetButton;
    protected boolean canSave = true;

    protected WidgetBuilder(ConfigMetaProvider provider, IConfigEntry<T> config) {
        this.provider = provider;
        this.config = config;
    }

    public void addDialogElements(Context context, String text, int x, int y, int width, int height) {
        Font font = this.minecraft.font;
        this.textWidget = new StringWidget(20, y, font.width(text), height, (Component)TextUtil.literal(text), font);
        context.addWidget((AbstractWidget)this.textWidget);
        this.resetButton = Button.builder((Component)TextUtil.translatable("jupiter.screen.button.remove", new Object[0]), button -> {
            this.config.reset();
            this.refresh();
        }).bounds(x + width - 50, y, 50, height).build();
        this.refreshResetButton(true);
        context.addWidget((AbstractWidget)this.resetButton);
        this.addCustomElements(context, x, y, width - 55, height);
    }

    public void addElements(Context context, int x, int y, int width, int height) {
        Font font = this.minecraft.font;
        MutableComponent component = TextUtil.literal(this.config.getPrettyName());
        this.textWidget = new StringWidget(20, y, font.width((FormattedText)component), height, (Component)component, font);
        context.addWidget((AbstractWidget)this.textWidget);
        this.resetButton = Button.builder((Component)TextUtil.translatable("jupiter.screen.button.reset", new Object[0]), button -> {
            this.config.reset();
            this.refresh();
        }).bounds(x + width - 50, y, 50, height).build();
        this.refreshResetButton(false);
        this.config.registerCallback(v -> this.refreshResetButton(false));
        context.addWidget((AbstractWidget)this.resetButton);
        this.addCustomElements(context, x, y, width - 55, height);
    }

    private void refreshResetButton(boolean dialog) {
        this.setCanReset(dialog || this.config.canReset());
    }

    protected void setCanReset(boolean b) {
        this.resetButton.active = b;
    }

    public abstract void addCustomElements(Context var1, int var2, int var3, int var4, int var5);

    public void update(boolean visible, int y) {
        if (this.textWidget != null) {
            this.textWidget.visible = visible;
            this.textWidget.setY(y);
        }
        if (this.resetButton != null) {
            this.resetButton.visible = visible;
            this.resetButton.setY(y);
        }
        this.updateCustom(visible, y);
    }

    public abstract void updateCustom(boolean var1, int var2);

    public abstract void refresh();

    public boolean canSave() {
        return this.canSave;
    }

    public record Context(Screen parent, Consumer<AbstractWidget> appender, TitleStack titleStack) {
        public void addWidget(AbstractWidget widget) {
            this.appender.accept(widget);
        }

        public TitleStack push(Component title) {
            return this.titleStack.push(title);
        }
    }
}

