/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter._loader.neoforge.network;

import com.iafenvoy.jupiter._loader.neoforge.network.packet.ByteBufS2C;
import com.iafenvoy.jupiter.network.ServerNetworkHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class ServerNetworkHelperImpl
implements ServerNetworkHelper {
    private static final Map<ResourceLocation, ServerNetworkHelper.Handler> RECEIVERS = new HashMap<ResourceLocation, ServerNetworkHelper.Handler>();

    @Override
    public void sendToPlayer(ServerPlayer player, ResourceLocation id, FriendlyByteBuf buf) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new ByteBufS2C(id, buf)});
    }

    @Override
    public void registerReceiver(ResourceLocation id, ServerNetworkHelper.Handler handler) {
        RECEIVERS.put(id, handler);
    }

    public static boolean onReceive(ResourceLocation id, FriendlyByteBuf buf, PlayPayloadContext context) {
        ServerNetworkHelper.Handler handler = RECEIVERS.get(id);
        if (handler == null) {
            return false;
        }
        if (context.player().isEmpty()) {
            return false;
        }
        Player player = (Player)context.player().get();
        MinecraftServer server = player.getServer();
        Runnable runnable = handler.handle(server, (ServerPlayer)player, buf);
        if (server != null && runnable != null) {
            server.execute(runnable);
        }
        return true;
    }
}

