/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.config.entry;

import com.iafenvoy.jupiter.config.interfaces.ConfigBuilder;
import com.iafenvoy.jupiter.config.interfaces.ValueChangeCallback;
import com.iafenvoy.jupiter.interfaces.IConfigEntry;
import com.iafenvoy.jupiter.util.Comment;
import com.iafenvoy.jupiter.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseEntry<T>
implements IConfigEntry<T> {
    protected final Component name;
    @Nullable
    protected String jsonKey;
    @Nullable
    protected Component tooltip = null;
    protected boolean visible;
    protected final T defaultValue;
    protected T value;
    protected boolean restartRequired;
    protected final List<ValueChangeCallback<T>> callbacks = new ArrayList<ValueChangeCallback<T>>();

    protected BaseEntry(Builder<T, ?, ?> builder) {
        this.name = builder.name;
        this.defaultValue = builder.defaultValue;
        this.jsonKey = builder.jsonKey;
        this.tooltip = builder.tooltip;
        this.visible = builder.visible;
        this.restartRequired = builder.restartRequired;
        this.callbacks.addAll(builder.callbacks);
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public BaseEntry(@NotNull String nameKey, T defaultValue) {
        this.name = TextUtil.translatable(nameKey, new Object[0]);
        this.jsonKey = nameKey;
        this.defaultValue = defaultValue;
        this.value = this.copyDefaultData();
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public BaseEntry<T> visible(boolean visible) {
        this.visible = visible;
        return this;
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public BaseEntry<T> json(String jsonKey) {
        this.jsonKey = jsonKey;
        return this;
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public BaseEntry<T> callback(Consumer<T> callback) {
        this.callbacks.add((v1, v2, b1, b2) -> callback.accept(v2));
        return this;
    }

    @Deprecated(forRemoval=true)
    @Comment(value="Use builder instead")
    public BaseEntry<T> restartRequired() {
        this.restartRequired = true;
        return this;
    }

    @Override
    public void registerCallback(ValueChangeCallback<T> callback) {
        this.callbacks.add(callback);
    }

    @Override
    public void setValue(T value) {
        T oldValue = this.value;
        this.value = value;
        this.callbacks.forEach(x -> x.onValueChange(oldValue, this.value, false, Objects.equals(this.value, this.defaultValue)));
    }

    @Override
    @Nullable
    public String getJsonKey() {
        return this.jsonKey;
    }

    @Override
    public Component getName() {
        return this.restartRequired ? this.name.copy().append((Component)TextUtil.translatable("jupiter.screen.restart_required", new Object[0])) : this.name;
    }

    @Override
    @Nullable
    public Component getTooltip() {
        return this.tooltip;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        T oldValue = this.value;
        this.value = this.copyDefaultData();
        this.callbacks.forEach(x -> x.onValueChange(oldValue, this.value, true, true));
    }

    protected T copyDefaultData() {
        return this.defaultValue;
    }

    public static abstract class Builder<T, E extends BaseEntry<T>, B extends Builder<T, E, B>>
    implements ConfigBuilder<T, E, B> {
        protected final Component name;
        protected final T defaultValue;
        protected T value;
        @Nullable
        protected String jsonKey;
        @Nullable
        protected Component tooltip;
        protected boolean visible = true;
        protected boolean restartRequired;
        protected final List<ValueChangeCallback<T>> callbacks = new ArrayList<ValueChangeCallback<T>>();

        public Builder(String nameKey, T defaultValue) {
            this((Component)TextUtil.translatable(nameKey, new Object[0]), defaultValue);
            this.json(nameKey);
        }

        public Builder(Component name, T defaultValue) {
            this.name = name;
            this.value = defaultValue;
            this.defaultValue = this.value;
        }

        public Builder(E parent) {
            this.name = ((BaseEntry)parent).name;
            this.value = ((BaseEntry)parent).defaultValue;
            this.defaultValue = this.value;
            this.jsonKey = ((BaseEntry)parent).jsonKey;
            this.tooltip = ((BaseEntry)parent).tooltip;
            this.visible = ((BaseEntry)parent).visible;
            this.restartRequired = ((BaseEntry)parent).restartRequired;
            this.callbacks.addAll(((BaseEntry)parent).callbacks);
        }

        public B visible(boolean visible) {
            this.visible = visible;
            return this.self();
        }

        public B json(String jsonKey) {
            this.jsonKey = jsonKey;
            return this.self();
        }

        public B restartRequired() {
            this.restartRequired = true;
            return this.self();
        }

        @Override
        public B tooltip(String tooltipKey) {
            return (B)this.tooltip((Component)TextUtil.translatable(tooltipKey, new Object[0]));
        }

        @Override
        public B tooltip(Component tooltipKey) {
            this.tooltip = tooltipKey;
            return this.self();
        }

        @Override
        public B callback(ValueChangeCallback<T> callback) {
            this.callbacks.add(callback);
            return this.self();
        }

        @Override
        public B value(T value) {
            this.value = value;
            return this.self();
        }

        public abstract B self();

        protected abstract E buildInternal();

        @Override
        public E build() {
            E e = this.buildInternal();
            ((BaseEntry)e).setValue(this.value);
            return e;
        }
    }
}

