/*
 * Decompiled with CFR 0.152.
 */
package net.enderbyteprograms.actionspeed;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.enderbyteprograms.actionspeed.ActionSpeedData;
import net.enderbyteprograms.actionspeed.EventManager;
import net.enderbyteprograms.actionspeed.PlayerData;
import net.enderbyteprograms.actionspeed.SpeedLooper;
import net.enderbyteprograms.actionspeed.bstats.Metrics;
import net.enderbyteprograms.actionspeed.commands.Speedometer;
import net.enderbyteprograms.actionspeed.commands.SpeedometerTabCompleter;
import net.enderbyteprograms.epdb.DataTypes;
import net.enderbyteprograms.epdb.EPDatabase;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionSpeedMain
extends JavaPlugin {
    public static ActionSpeedMain INSTANCE;
    public static EventManager LISTENER;
    public static FileConfiguration CONFIG;
    public BukkitRunnable MAINLOOP;

    public void onEnable() {
        INSTANCE = this;
        this.getCommand("speedometer").setExecutor((CommandExecutor)new Speedometer());
        this.getCommand("speedometer").setTabCompleter((TabCompleter)new SpeedometerTabCompleter());
        LISTENER = new EventManager();
        this.getServer().getPluginManager().registerEvents((Listener)LISTENER, (Plugin)this);
        this.saveDefaultConfig();
        CONFIG = this.getConfig();
        if (!CONFIG.contains("onbydefault", true)) {
            this.getConfig().set("onbydefault", (Object)true);
        }
        if (!CONFIG.contains("showzeros", true)) {
            this.getConfig().set("showzeros", (Object)true);
        }
        if (!CONFIG.contains("sample-rate", true)) {
            this.getConfig().set("sample-rate", (Object)10);
        }
        this.saveConfig();
        CONFIG = this.getConfig();
        double rawsamplerate = CONFIG.getDouble("sample-rate");
        if (rawsamplerate > 20.0) {
            this.getLogger().warning("The maximum sample rate is 20hz.");
            rawsamplerate = 20.0;
        }
        double tickcount = 20.0 / rawsamplerate;
        long newtickcount = (long)tickcount;
        if (tickcount % 1.0 != 0.0) {
            newtickcount = Math.round(tickcount);
            this.getLogger().warning("The requested sample rate is not precisely possible. It has been rounded to " + Double.toString(20.0 / (double)newtickcount) + "hz from " + Double.toString(rawsamplerate) + "hz.");
        }
        this.getLogger().info("Samples will be conducted every " + Long.toString(newtickcount) + " ticks.");
        ActionSpeedData.TickRate = newtickcount;
        ActionSpeedData.SampleRate = rawsamplerate;
        this.ReadPlayerData();
        SpeedLooper mainloop = new SpeedLooper();
        mainloop.runTaskTimer((Plugin)this, 1L, newtickcount);
        this.MAINLOOP = mainloop;
        int pluginid = 19237;
        Metrics metrics = new Metrics(this, pluginid);
        this.getLogger().info("ActionSpeed by Enderbyte Programs (c) 2023-2025, some rights reserved. Plugin is now initialized.");
    }

    public void onDisable() {
        this.getLogger().info("Shutting up the loop");
        this.MAINLOOP.cancel();
        this.getLogger().info("Saving configuration");
        this.WritePlayerData();
        this.saveConfig();
        this.getLogger().info("Bye Bye Everybody!");
    }

    private void WritePlayerData() {
        ActionSpeedData.MainDataTable.SetAutoSave(false);
        for (PlayerData pd : ActionSpeedData.Players.values()) {
            if (ActionSpeedData.MainDataTable.ExistsWhere("uuid", pd.UUID)) {
                ActionSpeedData.MainDataTable.DeleteWhere("uuid", pd.UUID);
            }
            ActionSpeedData.MainDataTable.Insert(new HashMap<String, Object>(Map.of("username", pd.username, "uuid", pd.UUID, "unit", pd.unit, "active", pd.active, "colour", pd.allowcolour, "migrated", true)));
        }
        ActionSpeedData.MainDataTable.SetAutoSave(true);
        try {
            ActionSpeedData.MainDataTable.Save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void ReadPlayerData() {
        ActionSpeedData.MainDataTable = new EPDatabase(this).GetTable("data");
        ActionSpeedData.MainDataTable.AddColumn("uuid", DataTypes.String, "");
        ActionSpeedData.MainDataTable.AddColumn("username", DataTypes.String, "");
        ActionSpeedData.MainDataTable.AddColumn("unit", DataTypes.Number, "");
        ActionSpeedData.MainDataTable.AddColumn("colour", DataTypes.Boolean, "");
        ActionSpeedData.MainDataTable.AddColumn("active", DataTypes.Boolean, true);
        ActionSpeedData.MainDataTable.AddColumn("migrated", DataTypes.Boolean, false);
        if (this.getConfig().contains("nplayers", true)) {
            ActionSpeedData.MainDataTable.SetAutoSave(false);
            this.getLogger().info("Migrating old data...");
            List playernames = this.getConfig().getStringList("nplayers");
            for (String name : playernames) {
                if (name.equals(".placeholder")) continue;
                int unit = this.getConfig().getInt(String.format("players.%s.unit", name));
                boolean isactive = this.getConfig().getBoolean(String.format("players.%s.active", name));
                boolean iscolour = this.getConfig().getBoolean(String.format("players.%s.colour", name));
                ActionSpeedData.MainDataTable.Insert(new HashMap<String, Object>(Map.of("username", name, "uuid", "", "unit", unit, "active", isactive, "colour", iscolour, "migrated", false)));
                this.getLogger().info("Migrated " + name);
            }
            CONFIG.set("nplayers", null);
            CONFIG.set("players", null);
            this.saveConfig();
            ActionSpeedData.MainDataTable.SetAutoSave(true);
            try {
                ActionSpeedData.MainDataTable.Save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.getLogger().info("Finished migration");
        }
        for (HashMap<String, Object> row : ActionSpeedData.MainDataTable.GetWhere("migrated", true)) {
            ActionSpeedData.Players.put((String)row.get("uuid"), new PlayerData(row));
        }
    }
}

