/*
 * Decompiled with CFR 0.152.
 */
package net.enderbyteprograms.actionspeed;

import java.util.ArrayList;
import java.util.List;
import net.enderbyteprograms.actionspeed.ActionSpeedMain;
import net.enderbyteprograms.actionspeed.PlayerData;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Utilities {
    public static void HelpMenu(CommandSender sender) {
        String nadhelp = String.valueOf(ChatColor.AQUA) + "Usage: as <command> [options]\n" + String.valueOf(ChatColor.RESET) + "/as allowcolour <" + String.valueOf(ChatColor.GREEN) + "yes" + String.valueOf(ChatColor.RESET) + "|" + String.valueOf(ChatColor.RED) + "no" + String.valueOf(ChatColor.RESET) + ">\n    Control if the speedometer will show colours\n/as disable|hide " + String.valueOf(ChatColor.BLUE) + "[player]" + String.valueOf(ChatColor.RESET) + "\n    Both of these do the same thing. They hide the speedometer\n/as enable|show " + String.valueOf(ChatColor.BLUE) + "[player]" + String.valueOf(ChatColor.RESET) + "\n    Both of these do the same thing. They show the speedometer\n/as setunits " + String.valueOf(ChatColor.BLUE) + "[unit]" + String.valueOf(ChatColor.RESET) + "\n    Set the units of your speedometer to [unit]. Refer to the tab completer.\n";
        String adhelp = "/as dumpdata\n    Output all stored data, including player configurations\n/as reload\n    Reload plugin configuration";
        sender.sendMessage(nadhelp);
        if (sender.hasPermission("actionspeed.admin")) {
            sender.sendMessage(adhelp);
        }
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public static List<String> comp_startswith(List<String> input, String phrase) {
        ArrayList<String> result = new ArrayList<String>();
        for (String p : input) {
            if (!p.startsWith(phrase) && !phrase.replace(" ", "").equals("")) continue;
            result.add(p);
        }
        return result;
    }

    public static Player GetPL(String[] strings) {
        ArrayList players = new ArrayList(ActionSpeedMain.INSTANCE.getServer().getOnlinePlayers());
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : players) {
            names.add(p.getDisplayName());
        }
        if (!names.contains(strings[strings.length - 1])) {
            return null;
        }
        return (Player)players.get(names.indexOf(strings[strings.length - 1]));
    }

    public static boolean commandendsinplayer(String[] strings) {
        ArrayList players = new ArrayList(ActionSpeedMain.INSTANCE.getServer().getOnlinePlayers());
        ArrayList<String> names = new ArrayList<String>();
        for (Player p : players) {
            names.add(p.getDisplayName());
        }
        return names.contains(strings[strings.length - 1]);
    }

    public static ChatColor speedColour(double invalue, PlayerData dat) {
        if (!dat.allowcolour) {
            return ChatColor.WHITE;
        }
        if (invalue < 5.0) {
            return ChatColor.AQUA;
        }
        if (invalue > 4.0 && invalue < 20.0) {
            return ChatColor.GREEN;
        }
        if (invalue > 19.0 && invalue < 50.0) {
            return ChatColor.YELLOW;
        }
        if (invalue > 49.0) {
            return ChatColor.RED;
        }
        return ChatColor.RESET;
    }

    public static double convertspeed(int converter, double m_s) {
        if (converter == 0) {
            return m_s;
        }
        if (converter == 1) {
            return m_s * 3.6;
        }
        if (converter == 2) {
            return m_s * 2.237;
        }
        if (converter == 3) {
            return m_s * 60.0;
        }
        if (converter == 4) {
            return m_s * 3.28084;
        }
        if (converter == 5) {
            return m_s * 0.037;
        }
        if (converter == 6) {
            return m_s * 1.94;
        }
        if (converter == 7) {
            return m_s * 0.0029154518950437317;
        }
        if (converter == 8) {
            return Math.pow(m_s, 2.0) * 0.5 * 342.0 * 0.001;
        }
        return m_s;
    }
}

