/*
 * Decompiled with CFR 0.152.
 */
package net.enderbyteprograms.actionspeed.commands;

import net.enderbyteprograms.actionspeed.ActionSpeedData;
import net.enderbyteprograms.actionspeed.ActionSpeedMain;
import net.enderbyteprograms.actionspeed.PlayerData;
import net.enderbyteprograms.actionspeed.Utilities;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Speedometer
implements CommandExecutor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (strings.length == 0) {
            commandSender.sendMessage("ActionSpeed Plugin by Enderbyte Programs v" + ActionSpeedData.version);
            Utilities.HelpMenu(commandSender);
            return true;
        }
        if (strings[0].equals("help")) {
            Utilities.HelpMenu(commandSender);
            return true;
        }
        if (strings[0].equals("enable") || strings[0].equals("show")) {
            Player p;
            if (!commandSender.hasPermission("actionspeed.speedometer")) {
                commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Insufficient Permission");
                return false;
            }
            if (!Utilities.commandendsinplayer(strings)) {
                if (!(commandSender instanceof Player)) {
                    commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Please specify a player name");
                    return false;
                }
                p = (Player)commandSender;
            } else {
                p = Utilities.GetPL(strings);
                if (commandSender instanceof Player && !((Player)commandSender).getDisplayName().equals(strings[strings.length - 1]) && !commandSender.hasPermission("actionspeed.admin")) {
                    commandSender.sendMessage(String.valueOf(ChatColor.RED) + "You lack the required permissions to edit someone else's speedometer");
                    return false;
                }
            }
            PlayerData ntp = ActionSpeedData.Players.get(p.getUniqueId().toString());
            ntp.active = true;
            ActionSpeedData.Players.put(p.getUniqueId().toString(), ntp);
            commandSender.sendMessage(String.valueOf(ChatColor.GREEN) + "Speedometer is now enabled for " + p.getDisplayName());
            return true;
        }
        if (strings[0].equals("disable") || strings[0].equals("hide")) {
            Player p;
            if (!commandSender.hasPermission("actionspeed.speedometer")) {
                commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Insufficient Permission");
                return false;
            }
            if (!Utilities.commandendsinplayer(strings)) {
                if (!(commandSender instanceof Player)) {
                    commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Please specify a player name");
                    return false;
                }
                p = (Player)commandSender;
            } else {
                p = Utilities.GetPL(strings);
                if (commandSender instanceof Player && !((Player)commandSender).getDisplayName().equals(strings[strings.length - 1]) && !commandSender.hasPermission("actionspeed.admin")) {
                    commandSender.sendMessage(String.valueOf(ChatColor.RED) + "You lack the required permissions to edit someone else's speedometer");
                    return false;
                }
            }
            PlayerData ntp = ActionSpeedData.Players.get(p.getUniqueId().toString());
            ntp.active = false;
            ActionSpeedData.Players.put(p.getUniqueId().toString(), ntp);
            commandSender.sendMessage(String.valueOf(ChatColor.GREEN) + "Speedometer is now disabled for " + p.getDisplayName());
            return true;
        }
        if (strings[0].equals("reload")) {
            if (commandSender.hasPermission("actionspeed.admin")) {
                ActionSpeedMain.INSTANCE.reloadConfig();
                ActionSpeedMain.CONFIG = ActionSpeedMain.INSTANCE.getConfig();
                commandSender.sendMessage(ActionSpeedMain.INSTANCE.getConfig().saveToString());
                commandSender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded");
                return true;
            }
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "Insufficient permissions");
            return true;
        }
        if (strings[0].equals("setunits")) {
            if (!commandSender.hasPermission("actionspeed.speedometer")) {
                commandSender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission to do this");
                return false;
            }
            try {
                String p = strings[1];
            }
            catch (Exception e) {
                commandSender.sendMessage("Please provide unit");
                return false;
            }
            String username = ((Player)commandSender).getUniqueId().toString();
            PlayerData pd = ActionSpeedData.Players.get(username);
            if (strings[1].equals("m/s")) {
                pd.unit = 0;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to m/s");
                return true;
            }
            if (strings[1].equals("km/h")) {
                pd.unit = 1;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to km/h");
                return true;
            }
            if (strings[1].equals("mi/h")) {
                pd.unit = 2;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to mi/h");
                return true;
            }
            if (strings[1].equals("m/min")) {
                pd.unit = 3;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to m/min");
                return true;
            }
            if (strings[1].equals("ft/s")) {
                pd.unit = 4;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to ft/s");
                return true;
            }
            if (strings[1].equals("mi/min")) {
                pd.unit = 5;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to mi/min");
                return true;
            }
            if (strings[1].equals("knots")) {
                pd.unit = 6;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to knots");
                return true;
            }
            if (strings[1].equals("mach")) {
                pd.unit = 7;
                pd.UpdateUnits();
                ActionSpeedData.Players.put(username, pd);
                commandSender.sendMessage("Changed to mach");
                return true;
            }
            if (!strings[1].equals("kineticenergy")) return true;
            pd.unit = 8;
            pd.UpdateUnits();
            ActionSpeedData.Players.put(username, pd);
            commandSender.sendMessage("Changed to kinetic energy (kilojoules)");
            return true;
        }
        if (!strings[0].equals("allowcolour")) return true;
        if (!commandSender.hasPermission("actionspeed.speedometer")) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "You lack permission to do this");
            return false;
        }
        try {
            String username = strings[1];
        }
        catch (Exception e) {
            commandSender.sendMessage("Please provide \"yes\" or \"no\"");
            return false;
        }
        PlayerData pd = ActionSpeedData.Players.get(((Player)commandSender).getUniqueId().toString());
        if (strings[1].toLowerCase().equals("yes") || strings[1].toLowerCase().equals("true")) {
            pd.allowcolour = true;
            ActionSpeedData.Players.put(pd.UUID, pd);
            commandSender.sendMessage(String.valueOf(ChatColor.GREEN) + "Enabled colour");
            return true;
        }
        if (!strings[1].toLowerCase().equals("no") && !strings[1].toLowerCase().equals("false")) {
            commandSender.sendMessage(String.valueOf(ChatColor.RED) + "That is not a valid argument.");
            return false;
        }
        pd.allowcolour = false;
        ActionSpeedData.Players.put(pd.UUID, pd);
        commandSender.sendMessage(String.valueOf(ChatColor.GREEN) + "Disabled colour");
        return true;
    }
}

