/*
 * Decompiled with CFR 0.152.
 */
package net.enderbyteprograms.epdb;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.enderbyteprograms.epdb.DataTypes;

public class Table {
    private List<HashMap<String, Object>> Data = new ArrayList<HashMap<String, Object>>();
    private File filepath;
    private String tablename;
    private boolean AutoSave = true;
    private HashMap<String, DataTypes> Columns = new HashMap();

    public void SetAutoSave(boolean nval) {
        this.AutoSave = nval;
    }

    public Table(File rootpath, String name) {
        this.tablename = name;
        this.filepath = new File(rootpath, this.tablename + ".ept");
        if (!this.filepath.exists()) {
            try {
                this.filepath.createNewFile();
                Files.writeString(this.filepath.toPath(), (CharSequence)"||||", new OpenOption[0]);
            }
            catch (IOException iOException) {}
        } else {
            String[] lines;
            String rawdata = "";
            try {
                rawdata = Files.readString(this.filepath.toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String head = rawdata.split("\\|\\|\\|\\|")[0];
            for (String columnarentry : head.split(";")) {
                if (columnarentry.isBlank()) continue;
                String k = columnarentry.split(" ")[0];
                int v = Integer.parseInt(columnarentry.split(" ")[1]);
                DataTypes dt = DataTypes.String;
                if (v == 0) {
                    dt = DataTypes.String;
                } else if (v == 1) {
                    dt = DataTypes.Number;
                } else if (v == 2) {
                    dt = DataTypes.Boolean;
                }
                this.Columns.put(k, dt);
            }
            String body = rawdata.split("\\|\\|\\|\\|")[1];
            for (String line : lines = body.split("\\r?\\n")) {
                if (line.isBlank()) continue;
                HashMap<String, Object> currentline = new HashMap<String, Object>();
                for (String section : line.split("\\|")) {
                    String[] kv;
                    String k;
                    if (section.isBlank() || !this.Columns.containsKey(k = (kv = section.split("\\$"))[0])) continue;
                    DataTypes vdt = this.Columns.get(k);
                    String v = new String(Base64.getDecoder().decode(kv[1]), Charset.defaultCharset());
                    Object ov = v;
                    if (vdt == DataTypes.Number) {
                        ov = Double.parseDouble(v);
                    } else if (vdt == DataTypes.Boolean) {
                        ov = Double.parseDouble(v) == 1.0;
                    }
                    currentline.put(k, ov);
                }
                this.Data.add(currentline);
            }
        }
        try {
            this.Save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void Save() throws IOException {
        if (!this.AutoSave) {
            return;
        }
        Object finald = "";
        for (Map.Entry<String, DataTypes> entry : this.Columns.entrySet()) {
            String k = entry.getKey();
            String v = String.valueOf(entry.getValue().toNum(entry.getValue()));
            finald = (String)finald + k;
            finald = (String)finald + " ";
            finald = (String)finald + v;
            finald = (String)finald + ";";
        }
        finald = (String)finald + "||||\n";
        for (HashMap hashMap : this.Data) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String k = (String)entry.getKey();
                if (!this.Columns.containsKey(k)) continue;
                DataTypes vdt = this.Columns.get(k);
                String v = String.valueOf(entry.getValue());
                if (vdt == DataTypes.Boolean) {
                    v = (Boolean)entry.getValue() != false ? "1" : "0";
                }
                finald = (String)finald + k;
                finald = (String)finald + "$";
                String vv = Base64.getEncoder().encodeToString(v.getBytes(StandardCharsets.UTF_8));
                if (vv.isBlank()) continue;
                finald = (String)finald + vv;
                finald = (String)finald + "|";
            }
            finald = (String)finald + "\n";
        }
        if (this.filepath.exists()) {
            Files.delete(this.filepath.toPath());
            this.filepath.createNewFile();
        }
        Files.writeString(this.filepath.toPath(), (CharSequence)finald, Charset.defaultCharset(), StandardOpenOption.WRITE);
    }

    public List<HashMap<String, Object>> GetAll() {
        return this.Data;
    }

    public List<HashMap<String, Object>> GetAll(String sortkey) {
        DataTypes sdt = this.Columns.get(sortkey);
        ArrayList<HashMap<String, Object>> _d = new ArrayList<HashMap<String, Object>>();
        _d.sort((s1, s2) -> {
            if (sdt == DataTypes.String) {
                return ((String)s1.get(sortkey)).compareTo((String)s2.get(sortkey));
            }
            if (sdt == DataTypes.Number) {
                return ((Double)s1.get(sortkey)).compareTo((Double)s2.get(sortkey));
            }
            return ((Boolean)s1.get(sortkey)).compareTo((Boolean)s2.get(sortkey));
        });
        return _d;
    }

    public void Clear() {
        this.Data = new ArrayList<HashMap<String, Object>>();
        try {
            this.Save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void DeleteWhere(String finderkey, Object deletewhere) {
        int doffset = 0;
        for (int i = 0; i < this.Data.toArray().length; ++i) {
            HashMap<String, Object> sel = this.Data.get(i - doffset);
            if (!sel.get(finderkey).equals(deletewhere)) continue;
            this.Data.remove(i - doffset);
            ++doffset;
        }
        try {
            this.Save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void Insert(HashMap<String, Object> o) {
        this.Data.add(o);
        try {
            this.Save();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void AddColumn(String name, DataTypes dt, Object defaultvalue) {
        this.Columns.put(name, dt);
        for (HashMap<String, Object> d : this.Data) {
            if (d.containsKey(name)) continue;
            if (dt == DataTypes.String) {
                d.put(name, defaultvalue);
                continue;
            }
            if (dt == DataTypes.Number) {
                d.put(name, defaultvalue);
                continue;
            }
            d.put(name, defaultvalue);
        }
    }

    public List<HashMap<String, Object>> GetWhere(String searchkey, Object searchvalue) {
        ArrayList<HashMap<String, Object>> fn = new ArrayList<HashMap<String, Object>>();
        for (HashMap<String, Object> row : this.Data) {
            if (!row.get(searchkey).equals(searchvalue)) continue;
            fn.add(row);
        }
        return fn;
    }

    public boolean ExistsWhere(String searchkey, Object searchvalue) {
        for (HashMap<String, Object> row : this.Data) {
            if (!row.get(searchkey).equals(searchvalue)) continue;
            return true;
        }
        return false;
    }
}

