/*
 * Decompiled with CFR 0.152.
 */
package enderbyteprograms.actionspeed.commands;

import enderbyteprograms.actionspeed.ActionSpeedData;
import enderbyteprograms.actionspeed.ActionSpeedMain;
import enderbyteprograms.actionspeed.PlayerData;
import java.util.Iterator;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class Speedometer
implements CommandExecutor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        if (strings.length == 0) {
            commandSender.sendMessage("ActionSpeed Plugin v" + ActionSpeedData.version);
            return true;
        }
        if (strings[0].equals("toggle")) {
            if (!commandSender.hasPermission("actionspeed.speedometer")) {
                commandSender.sendMessage(ChatColor.RED + "Insufficient Permission");
                return false;
            }
            if (!(commandSender instanceof Player)) {
                commandSender.sendMessage(ChatColor.RED + "Only players may execute this command");
                return false;
            }
            Player p = (Player)commandSender;
            try {
                PlayerData playerData = ActionSpeedData.active.get(ActionSpeedData.getpdata(p.getDisplayName()));
            }
            catch (IndexOutOfBoundsException e) {
                ActionSpeedData.active.add(new PlayerData(p.getDisplayName()));
            }
            PlayerData ntp = ActionSpeedData.active.get(ActionSpeedData.getpdata(p.getDisplayName()));
            if (!ActionSpeedData.inlist(p)) {
                commandSender.sendMessage(ChatColor.RED + "Error");
                return true;
            }
            ActionSpeedData.DestroyPlayer(p.getDisplayName());
            ntp.active = !ntp.active;
            ActionSpeedData.active.add(ntp);
            commandSender.sendMessage(ChatColor.GREEN + "Speedometer is now set to: " + ntp.active);
            return true;
        }
        if (strings[0].equals("forceshutdown")) {
            if (commandSender.hasPermission("actionspeed.admin")) {
                HandlerList.unregisterAll((Listener)ActionSpeedMain.LISTENER);
                ActionSpeedData.isregistered = false;
                commandSender.sendMessage(ChatColor.GREEN + "EventManager and Speedometer disabled.");
                return true;
            }
            commandSender.sendMessage(ChatColor.RED + "Insufficient permissions");
            return true;
        }
        if (strings[0].equals("restart")) {
            if (commandSender.hasPermission("actionspeed.admin")) {
                ActionSpeedMain.INSTANCE.getServer().getPluginManager().registerEvents((Listener)ActionSpeedMain.LISTENER, (Plugin)ActionSpeedMain.INSTANCE);
                ActionSpeedData.isregistered = true;
                commandSender.sendMessage(ChatColor.GREEN + "Actionspeed is now ready");
                return true;
            }
            commandSender.sendMessage(ChatColor.RED + "Insufficient permissions");
            return true;
        }
        if (strings[0].equals("setunits")) {
            if (!commandSender.hasPermission("actionspeed.speedometer")) {
                commandSender.sendMessage(ChatColor.RED + "You lack permission to do this");
                return false;
            }
            try {
                String p = strings[1];
            }
            catch (Exception e) {
                commandSender.sendMessage("Please provide unit");
                return false;
            }
            PlayerData pd = ActionSpeedData.active.get(ActionSpeedData.getpdata(((Player)commandSender).getDisplayName()));
            if (strings[1].equals("m/s")) {
                pd.unit = 0;
                ActionSpeedData.DestroyPlayer(pd.username);
                pd.UpdateUnits();
                ActionSpeedData.active.add(pd);
                commandSender.sendMessage("Changed to m/s");
                return true;
            }
            if (strings[1].equals("km/h")) {
                pd.unit = 1;
                ActionSpeedData.DestroyPlayer(pd.username);
                pd.UpdateUnits();
                ActionSpeedData.active.add(pd);
                commandSender.sendMessage("Changed to km/h");
                return true;
            }
            if (strings[1].equals("mi/h")) {
                pd.unit = 2;
                ActionSpeedData.DestroyPlayer(pd.username);
                pd.UpdateUnits();
                ActionSpeedData.active.add(pd);
                commandSender.sendMessage("Changed to mi/h");
                return true;
            }
            if (strings[1].equals("m/min")) {
                pd.unit = 3;
                ActionSpeedData.DestroyPlayer(pd.username);
                pd.UpdateUnits();
                ActionSpeedData.active.add(pd);
                commandSender.sendMessage("Changed to m/min");
                return true;
            }
            if (strings[1].equals("ft/s")) {
                pd.unit = 4;
                ActionSpeedData.DestroyPlayer(pd.username);
                pd.UpdateUnits();
                ActionSpeedData.active.add(pd);
                commandSender.sendMessage("Changed to ft/s");
                return true;
            }
            if (strings[1].equals("mi/min")) {
                pd.unit = 5;
                ActionSpeedData.DestroyPlayer(pd.username);
                pd.UpdateUnits();
                ActionSpeedData.active.add(pd);
                commandSender.sendMessage("Changed to mi/min");
                return true;
            }
            if (!strings[1].equals("knots")) return true;
            pd.unit = 6;
            ActionSpeedData.DestroyPlayer(pd.username);
            pd.UpdateUnits();
            ActionSpeedData.active.add(pd);
            commandSender.sendMessage("Changed to knots");
            return true;
        }
        if (strings[0].equals("allowcolour")) {
            Object pd;
            if (!commandSender.hasPermission("actionspeed.speedometer")) {
                commandSender.sendMessage(ChatColor.RED + "You lack permission to do this");
                return false;
            }
            try {
                pd = strings[1];
            }
            catch (Exception e) {
                commandSender.sendMessage("Please provide \"yes\" or \"no\"");
                return false;
            }
            pd = ActionSpeedData.active.get(ActionSpeedData.getpdata(((Player)commandSender).getDisplayName()));
            if (strings[1].toLowerCase().equals("yes")) {
                ((PlayerData)pd).allowcolour = true;
                ActionSpeedData.DestroyPlayer(((PlayerData)pd).username);
                ActionSpeedData.active.add((PlayerData)pd);
                commandSender.sendMessage(ChatColor.GREEN + "Enabled colour");
                return true;
            }
            if (strings[1].toLowerCase().equals("no")) {
                ((PlayerData)pd).allowcolour = false;
                ActionSpeedData.DestroyPlayer(((PlayerData)pd).username);
                ActionSpeedData.active.add((PlayerData)pd);
                commandSender.sendMessage(ChatColor.GREEN + "Disabled colour");
                return true;
            }
            commandSender.sendMessage(ChatColor.RED + "Please use either yes or no");
            return false;
        }
        if (!strings[0].equals("dumpdata")) return true;
        if (!commandSender.hasPermission("actionspeed.admin")) {
            commandSender.sendMessage(ChatColor.RED + "You lack permission to do this");
            return false;
        }
        commandSender.sendMessage(ChatColor.LIGHT_PURPLE + "ActionSpeed Data Dump");
        commandSender.sendMessage("Datalist length: " + ActionSpeedData.active.size());
        commandSender.sendMessage("enabled=" + ActionSpeedData.isregistered);
        Iterator<PlayerData> iterator = ActionSpeedData.active.iterator();
        while (iterator.hasNext()) {
            PlayerData p = iterator.next();
            commandSender.sendMessage(p.username);
            commandSender.sendMessage("    unitstr=" + p.unitstr);
            commandSender.sendMessage("    unit=" + p.unit);
            commandSender.sendMessage("    allowcolour=" + p.allowcolour);
            commandSender.sendMessage("    active=" + p.active);
        }
        return true;
    }
}

