# ===== NEW PLAYER SETUP =====
# Initialize new players with starting money and job
execute as @a unless score @s money matches 0.. run scoreboard players set @s money 100
execute as @a unless score @s Job matches 0.. run function economy:jobs/general/assign_worker
execute as @a unless score @s lastPaycheck matches 0.. run scoreboard players set @s lastPaycheck 0
execute as @a unless score @s chunksOwned matches 0.. run scoreboard players set @s chunksOwned 0
execute as @a unless score @s money matches 0.. run team join peasant @s
# Process triggers immediately when they're set

execute as @a[scores={withdrawE=1..}] run function economy:banking/withdraw_emeralds
execute as @a[scores={withdrawD=1..}] at @s run function economy:banking/process_diamond_withdraw

# Keep enabling triggers
scoreboard players enable @a withdrawE
scoreboard players enable @a withdrawD
# Process emerald deposits
execute as @a[scores={depositE=1..}] run function economy:banking/deposit_emeralds
execute as @a[scores={depositD=1..}] run function economy:banking/deposit_diamonds

# Enable triggers
scoreboard players enable @a depositE
scoreboard players enable @a depositD
# ===== HUNTER SKILL UPGRADE FOR EXISTING WORKERS =====
# Add hunter skills to existing workers who don't have them yet
execute as @a[scores={Job=1}] unless score @s HunterLevel matches 0.. run scoreboard players set @s HunterLevel 1
execute as @a[scores={Job=1}] unless score @s HunterXP matches 0.. run scoreboard players set @s HunterXP 0
execute as @a[scores={Job=1}] unless score @s HunterLevel matches 0.. run tellraw @s {"text":"Hunter skills added to your Worker job! Kill hostile mobs for XP and pay.","color":"red","bold":true}
# Initialize blacksmith objectives for workers who don't have them
execute as @a[scores={Job=1}] unless score @s BlacksmithLevel matches 0.. run scoreboard players set @s BlacksmithLevel 1
execute as @a[scores={Job=1}] unless score @s BlacksmithXP matches 0.. run scoreboard players set @s BlacksmithXP 0
execute as @a[scores={Job=1}] unless score @s BlacksmithCrafted matches 0.. run scoreboard players set @s BlacksmithCrafted 0
execute as @a[scores={Job=1}] unless score @s craftingFlag matches 0.. run scoreboard players set @s craftingFlag 0
# Initialize fishing objectives for workers who don't have them
execute as @a[scores={Job=1}] unless score @s FishingLevel matches 0.. run scoreboard players set @s FishingLevel 1
execute as @a[scores={Job=1}] unless score @s FishingXP matches 0.. run scoreboard players set @s FishingXP 0
execute as @a[scores={Job=1}] unless score @s FishCaught matches 0.. run scoreboard players set @s FishCaught 0
# Initialize ALL lumber objectives for players who don't have them
scoreboard players add @a log_counter 0
scoreboard players add @a lumberXP 0
scoreboard players add @a lumber 0
scoreboard players add @a lumberlevel 0
scoreboard players add @a lumbertemp 0
scoreboard players add @a multiplier 0

scoreboard players add @a oak_planks_crafted 0
scoreboard players add @a birch_planks_crafted 0
scoreboard players add @a spruce_planks_crafted 0
scoreboard players add @a jungle_planks_crafted 0
scoreboard players add @a acacia_planks_crafted 0
scoreboard players add @a dark_oak_planks_crafted 0
scoreboard players add @a mangrove_planks_crafted 0
scoreboard players add @a cherry_planks_crafted 0

# Set default lumber level to 1 for new players
scoreboard players set @a[scores={lumberlevel=0}] lumberlevel 1
# Check if any player has broken logs and add to main counter
execute as @a[scores={logs_broken=1..}] run scoreboard players operation @s log_counter += @s logs_broken
execute as @a[scores={logs_broken_acacia=1..}] run scoreboard players operation @s log_counter += @s logs_broken_acacia
execute as @a[scores={logs_broken_birch=1..}] run scoreboard players operation @s log_counter += @s logs_broken_birch
execute as @a[scores={logs_broken_cherry=1..}] run scoreboard players operation @s log_counter += @s logs_broken_cherry
execute as @a[scores={logs_broken_dark_oak=1..}] run scoreboard players operation @s log_counter += @s logs_broken_dark_oak
execute as @a[scores={logs_broken_jungle=1..}] run scoreboard players operation @s log_counter += @s logs_broken_jungle
execute as @a[scores={logs_broken_mangrove=1..}] run scoreboard players operation @s log_counter += @s logs_broken_mangrove
execute as @a[scores={logs_broken_spruce=1..}] run scoreboard players operation @s log_counter += @s logs_broken_spruce

# Reset the individual log counters
scoreboard players reset @a[scores={logs_broken=1..}] logs_broken
scoreboard players reset @a[scores={logs_broken_acacia=1..}] logs_broken_acacia
scoreboard players reset @a[scores={logs_broken_birch=1..}] logs_broken_birch
scoreboard players reset @a[scores={logs_broken_cherry=1..}] logs_broken_cherry
scoreboard players reset @a[scores={logs_broken_dark_oak=1..}] logs_broken_dark_oak
scoreboard players reset @a[scores={logs_broken_jungle=1..}] logs_broken_jungle
scoreboard players reset @a[scores={logs_broken_mangrove=1..}] logs_broken_mangrove
scoreboard players reset @a[scores={logs_broken_spruce=1..}] logs_broken_spruce
# ===== TRIGGER SYSTEM =====
# Enable triggers for all players
scoreboard players enable @a chooseWorker
scoreboard players enable @a quitJob
# Enable realtor triggers for all players
scoreboard players enable @a setPrice
scoreboard players enable @a sellChunk
scoreboard players enable @a confirmSale
scoreboard players enable @a cancelSale
scoreboard players enable @a saleInfo
# ===== REAL ESTATE SYSTEM =====
# Handle real estate triggers and operations
function economy:jobs/realtor/real_estate_system
# ===== ORIGINAL ECONOMY SYSTEM =====
# Enable pay trigger for all players
scoreboard players enable @a pay
# Handle /trigger pay set (transfers to closest player within 5 blocks, with balance check)
execute as @a[scores={pay=1..}] if score @s money >= @s pay at @s run execute if entity @p[distance=0.1..5,scores={pay=0}] run scoreboard players operation @p[distance=0.1..5,scores={pay=0}] money += @s pay
execute as @a[scores={pay=1..}] if score @s money >= @s pay at @s run execute if entity @p[distance=0.1..5,scores={pay=0}] run scoreboard players operation @s money -= @s pay
execute as @a[scores={pay=1..}] if score @s money >= @s pay at @s run execute if entity @p[distance=0.1..5,scores={pay=0}] run tellraw @s [{"text":"Paid "},{"score":{"name":"@s","objective":"pay"},"color":"green"},{"text":" to closest player.","color":"white"}]
execute as @a[scores={pay=1..}] if score @s money >= @s pay unless entity @p[distance=0.1..5,scores={pay=0}] run tellraw @s {"text":"No player nearby to pay!","color":"red"}
execute as @a[scores={pay=1..}] if score @s money < @s pay run tellraw @s {"text":"Insufficient funds!","color":"red"}
scoreboard players set @a[scores={pay=1..}] pay 0
# Prevent negative balance
execute as @a[scores={money=..-1}] run scoreboard players set @s money 0
# ===== WORKER SYSTEM =====
# Reduce cooldown timer only once per second (every 20 ticks)
execute store result score #currentTick dummy run time query gametime
execute store result score #tickMod dummy run scoreboard players get #currentTick dummy
scoreboard players operation #tickMod dummy %= #20 dummy
execute as @a[scores={Job=1,ranchCooldown=1..}] if score #tickMod dummy matches 0 run scoreboard players remove @s ranchCooldown 10
# Track animal breeding for XP (separate from harvest)
execute as @a[scores={Job=1,animalsBred=1..}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,animalsBred=1..}] run scoreboard players add @s RancherXP 1
execute as @a[scores={Job=1,animalsBred=1..}] run scoreboard players remove @s animalsBred 1
# Track animal kills and implement anti-exploit
execute as @a[scores={Job=1,cowsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,sheepKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,pigsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,chickensKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,rabbitsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,goatsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,salmonKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,codKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,tropicalFishKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
# Track hostile mob kills and implement anti-exploit (use ranch handler)
execute as @a[scores={Job=1,zombiesKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,skeletonsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,creepersKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,spidersKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,endermenKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,witchesKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,slimesKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,phantomsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,drownedKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,husksKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,straysKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,caveSpidersKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,zombifiedPiglinsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,blazesKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,ghastsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,witherSkeletonsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,magmaCubesKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,hoglinsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,piglinsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,piglinBrutesKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,endermitesKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,shulkersKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,withersKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
execute as @a[scores={Job=1,enderDragonsKilled=1..}] run function economy:jobs/rancher/ranch_kill_handler
# Meat pickup system (check kill count AND no cooldown)
execute as @a[scores={Job=1,pickupBeef=1..,cowsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,pickupBeef=1..,cowsKilled=1..,ranchCooldown=0}] run scoreboard players remove @s cowsKilled 1
execute as @a[scores={Job=1,pickupBeef=1..}] run scoreboard players remove @s pickupBeef 1

execute as @a[scores={Job=1,pickupMutton=1..,sheepKilled=1..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,pickupMutton=1..,sheepKilled=1..,ranchCooldown=0}] run scoreboard players remove @s sheepKilled 1
execute as @a[scores={Job=1,pickupMutton=1..}] run scoreboard players remove @s pickupMutton 1

execute as @a[scores={Job=1,pickupPork=1..,pigsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,pickupPork=1..,pigsKilled=1..,ranchCooldown=0}] run scoreboard players remove @s pigsKilled 1
execute as @a[scores={Job=1,pickupPork=1..}] run scoreboard players remove @s pickupPork 1

execute as @a[scores={Job=1,pickupChicken=1..,chickensKilled=1..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,pickupChicken=1..,chickensKilled=1..,ranchCooldown=0}] run scoreboard players remove @s chickensKilled 1
execute as @a[scores={Job=1,pickupChicken=1..}] run scoreboard players remove @s pickupChicken 1

# Additional meat/item pickup system (check kill count AND no cooldown)
# Rabbit drops - regular rabbit items give 1 XP/harvest, rabbit foot gives 20
execute as @a[scores={Job=1,pickupRawRabbit=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,pickupRawRabbit=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RancherXP 1
execute as @a[scores={Job=1,pickupRawRabbit=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players remove @s rabbitsKilled 1
execute as @a[scores={Job=1,pickupRawRabbit=1..}] run scoreboard players remove @s pickupRawRabbit 1

execute as @a[scores={Job=1,pickupRabbitHide=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,pickupRabbitHide=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RancherXP 1
execute as @a[scores={Job=1,pickupRabbitHide=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players remove @s rabbitsKilled 1
execute as @a[scores={Job=1,pickupRabbitHide=1..}] run scoreboard players remove @s pickupRabbitHide 1

execute as @a[scores={Job=1,pickupRabbitFoot=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 20
execute as @a[scores={Job=1,pickupRabbitFoot=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players add @s RancherXP 20
execute as @a[scores={Job=1,pickupRabbitFoot=1..,rabbitsKilled=1..,ranchCooldown=0}] run scoreboard players remove @s rabbitsKilled 1
execute as @a[scores={Job=1,pickupRabbitFoot=1..}] run scoreboard players remove @s pickupRabbitFoot 1

execute as @a[scores={Job=1,pickupEgg=1..,ranchCooldown=0}] run scoreboard players add @s eggCount 1
execute as @a[scores={Job=1,pickupEgg=1..}] run scoreboard players remove @s pickupEgg 1
execute as @a[scores={Job=1,pickupBrownEgg=1..,ranchCooldown=0}] run scoreboard players add @s eggCount 1
execute as @a[scores={Job=1,pickupBrownEgg=1..}] run scoreboard players remove @s pickupBrownEgg 1
execute as @a[scores={Job=1,pickupBlueEgg=1..,ranchCooldown=0}] run scoreboard players add @s eggCount 1
execute as @a[scores={Job=1,pickupBlueEgg=1..}] run scoreboard players remove @s pickupBlueEgg 1
# Process egg XP (every 2 eggs = 1 XP, no payment)
execute as @a[scores={Job=1,eggCount=2..,ranchCooldown=0}] run scoreboard players add @s RancherXP 0
execute as @a[scores={Job=1,eggCount=2..,ranchCooldown=0}] run scoreboard players remove @s eggCount 2
# Sheep shearing detection (adds to sheepShear counter)
function economy:jobs/rancher/sheep_shearing_detector
# Process wool groups of 3 for payment (after daily processing)
execute as @a[scores={Job=1,woolCount=3..,ranchCooldown=0}] run scoreboard players add @s RanchHarvested 1
execute as @a[scores={Job=1,woolCount=3..,ranchCooldown=0}] run scoreboard players add @s RancherXP 1
execute as @a[scores={Job=1,woolCount=3..,ranchCooldown=0}] run scoreboard players remove @s woolCount 3
# Common Hostile Mobs (1 XP, 1 Hunt each)
execute as @a[scores={Job=1,zombiesKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,zombiesKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,skeletonsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,skeletonsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,creepersKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,creepersKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,spidersKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,spidersKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,drownedKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,drownedKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,husksKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,husksKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,straysKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,straysKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,caveSpidersKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,caveSpidersKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,zombifiedPiglinsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,zombifiedPiglinsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,hoglinsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,hoglinsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,piglinsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,piglinsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
execute as @a[scores={Job=1,endermitesKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 1
execute as @a[scores={Job=1,endermitesKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 1
# Note: Slimes give 0 XP and 0 Hunt as requested, so no reward processing for them
# Strong Mobs (2 XP, 2 Hunt each)
execute as @a[scores={Job=1,phantomsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 2
execute as @a[scores={Job=1,phantomsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 2
execute as @a[scores={Job=1,blazesKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 2
execute as @a[scores={Job=1,blazesKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 2
execute as @a[scores={Job=1,ghastsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 2
execute as @a[scores={Job=1,ghastsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 2
execute as @a[scores={Job=1,witherSkeletonsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 2
execute as @a[scores={Job=1,witherSkeletonsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 2
execute as @a[scores={Job=1,magmaCubesKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 2
execute as @a[scores={Job=1,magmaCubesKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 2
execute as @a[scores={Job=1,piglinBrutesKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 2
execute as @a[scores={Job=1,piglinBrutesKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 2
execute as @a[scores={Job=1,shulkersKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 2
execute as @a[scores={Job=1,shulkersKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 2
# Elite Mobs (3 XP, 3 Hunt each)
execute as @a[scores={Job=1,endermenKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 3
execute as @a[scores={Job=1,endermenKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 3
execute as @a[scores={Job=1,witchesKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 3
execute as @a[scores={Job=1,witchesKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 3
# Boss Mobs (20 XP, 20 Hunt each)
execute as @a[scores={Job=1,withersKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 20
execute as @a[scores={Job=1,withersKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 20
execute as @a[scores={Job=1,enderDragonsKilled=1..,ranchCooldown=0}] run scoreboard players add @s Hunt 20
execute as @a[scores={Job=1,enderDragonsKilled=1..,ranchCooldown=0}] run scoreboard players add @s HunterXP 20
# Reset kill counters immediately after processing
execute as @a[scores={Job=1,cowsKilled=1..}] run scoreboard players set @s cowsKilled 0
execute as @a[scores={Job=1,sheepKilled=1..}] run scoreboard players set @s sheepKilled 0
execute as @a[scores={Job=1,pigsKilled=1..}] run scoreboard players set @s pigsKilled 0
execute as @a[scores={Job=1,chickensKilled=1..}] run scoreboard players set @s chickensKilled 0
execute as @a[scores={Job=1,rabbitsKilled=1..}] run scoreboard players set @s rabbitsKilled 0
execute as @a[scores={Job=1,goatsKilled=1..}] run scoreboard players set @s goatsKilled 0
execute as @a[scores={Job=1,salmonKilled=1..}] run scoreboard players set @s salmonKilled 0
execute as @a[scores={Job=1,codKilled=1..}] run scoreboard players set @s codKilled 0
execute as @a[scores={Job=1,tropicalFishKilled=1..}] run scoreboard players set @s tropicalFishKilled 0
# Reset all mob kill counters immediately after processing
execute as @a[scores={Job=1,zombiesKilled=1..}] run scoreboard players set @s zombiesKilled 0
execute as @a[scores={Job=1,skeletonsKilled=1..}] run scoreboard players set @s skeletonsKilled 0
execute as @a[scores={Job=1,creepersKilled=1..}] run scoreboard players set @s creepersKilled 0
execute as @a[scores={Job=1,spidersKilled=1..}] run scoreboard players set @s spidersKilled 0
execute as @a[scores={Job=1,endermenKilled=1..}] run scoreboard players set @s endermenKilled 0
execute as @a[scores={Job=1,witchesKilled=1..}] run scoreboard players set @s witchesKilled 0
execute as @a[scores={Job=1,slimesKilled=1..}] run scoreboard players set @s slimesKilled 0
execute as @a[scores={Job=1,phantomsKilled=1..}] run scoreboard players set @s phantomsKilled 0
execute as @a[scores={Job=1,drownedKilled=1..}] run scoreboard players set @s drownedKilled 0
execute as @a[scores={Job=1,husksKilled=1..}] run scoreboard players set @s husksKilled 0
execute as @a[scores={Job=1,straysKilled=1..}] run scoreboard players set @s straysKilled 0
execute as @a[scores={Job=1,caveSpidersKilled=1..}] run scoreboard players set @s caveSpidersKilled 0
execute as @a[scores={Job=1,zombifiedPiglinsKilled=1..}] run scoreboard players set @s zombifiedPiglinsKilled 0
execute as @a[scores={Job=1,blazesKilled=1..}] run scoreboard players set @s blazesKilled 0
execute as @a[scores={Job=1,ghastsKilled=1..}] run scoreboard players set @s ghastsKilled 0
execute as @a[scores={Job=1,witherSkeletonsKilled=1..}] run scoreboard players set @s witherSkeletonsKilled 0
execute as @a[scores={Job=1,magmaCubesKilled=1..}] run scoreboard players set @s magmaCubesKilled 0
execute as @a[scores={Job=1,hoglinsKilled=1..}] run scoreboard players set @s hoglinsKilled 0
execute as @a[scores={Job=1,piglinsKilled=1..}] run scoreboard players set @s piglinsKilled 0
execute as @a[scores={Job=1,piglinBrutesKilled=1..}] run scoreboard players set @s piglinBrutesKilled 0
execute as @a[scores={Job=1,endermitesKilled=1..}] run scoreboard players set @s endermitesKilled 0
execute as @a[scores={Job=1,shulkersKilled=1..}] run scoreboard players set @s shulkersKilled 0
execute as @a[scores={Job=1,withersKilled=1..}] run scoreboard players set @s withersKilled 0
execute as @a[scores={Job=1,enderDragonsKilled=1..}] run scoreboard players set @s enderDragonsKilled 0
# Prevent negative kill counts
execute as @a[scores={cowsKilled=..-1}] run scoreboard players set @s cowsKilled 0
execute as @a[scores={sheepKilled=..-1}] run scoreboard players set @s sheepKilled 0
execute as @a[scores={pigsKilled=..-1}] run scoreboard players set @s pigsKilled 0
execute as @a[scores={chickensKilled=..-1}] run scoreboard players set @s chickensKilled 0
execute as @a[scores={rabbitsKilled=..-1}] run scoreboard players set @s rabbitsKilled 0
execute as @a[scores={goatsKilled=..-1}] run scoreboard players set @s goatsKilled 0
execute as @a[scores={salmonKilled=..-1}] run scoreboard players set @s salmonKilled 0
execute as @a[scores={codKilled=..-1}] run scoreboard players set @s codKilled 0
execute as @a[scores={tropicalFishKilled=..-1}] run scoreboard players set @s tropicalFishKilled 0
# Prevent negative hostile mob kill counts
execute as @a[scores={zombiesKilled=..-1}] run scoreboard players set @s zombiesKilled 0
execute as @a[scores={skeletonsKilled=..-1}] run scoreboard players set @s skeletonsKilled 0
execute as @a[scores={creepersKilled=..-1}] run scoreboard players set @s creepersKilled 0
execute as @a[scores={spidersKilled=..-1}] run scoreboard players set @s spidersKilled 0
execute as @a[scores={endermenKilled=..-1}] run scoreboard players set @s endermenKilled 0
execute as @a[scores={witchesKilled=..-1}] run scoreboard players set @s witchesKilled 0
execute as @a[scores={slimesKilled=..-1}] run scoreboard players set @s slimesKilled 0
execute as @a[scores={phantomsKilled=..-1}] run scoreboard players set @s phantomsKilled 0
execute as @a[scores={drownedKilled=..-1}] run scoreboard players set @s drownedKilled 0
execute as @a[scores={husksKilled=..-1}] run scoreboard players set @s husksKilled 0
execute as @a[scores={straysKilled=..-1}] run scoreboard players set @s straysKilled 0
execute as @a[scores={caveSpidersKilled=..-1}] run scoreboard players set @s caveSpidersKilled 0
execute as @a[scores={zombifiedPiglinsKilled=..-1}] run scoreboard players set @s zombifiedPiglinsKilled 0
execute as @a[scores={blazesKilled=..-1}] run scoreboard players set @s blazesKilled 0
execute as @a[scores={ghastsKilled=..-1}] run scoreboard players set @s ghastsKilled 0
execute as @a[scores={witherSkeletonsKilled=..-1}] run scoreboard players set @s witherSkeletonsKilled 0
execute as @a[scores={magmaCubesKilled=..-1}] run scoreboard players set @s magmaCubesKilled 0
execute as @a[scores={hoglinsKilled=..-1}] run scoreboard players set @s hoglinsKilled 0
execute as @a[scores={piglinsKilled=..-1}] run scoreboard players set @s piglinsKilled 0
execute as @a[scores={piglinBrutesKilled=..-1}] run scoreboard players set @s piglinBrutesKilled 0
execute as @a[scores={endermitesKilled=..-1}] run scoreboard players set @s endermitesKilled 0
execute as @a[scores={shulkersKilled=..-1}] run scoreboard players set @s shulkersKilled 0
execute as @a[scores={withersKilled=..-1}] run scoreboard players set @s withersKilled 0
execute as @a[scores={enderDragonsKilled=..-1}] run scoreboard players set @s enderDragonsKilled 0

# ===== FISHING SYSTEM =====
# Initialize new workers with fishing skills
execute as @a[scores={Job=1}] unless score @s FishingLevel matches 0.. run scoreboard players set @s FishingLevel 1
execute as @a[scores={Job=1}] unless score @s FishingXP matches 0.. run scoreboard players set @s FishingXP 0

# Using rod sets rodCount to 1 (max of 1)
execute as @a[scores={Job=1,fishingRodUsed=1..}] run scoreboard players set @s rodCount 1

# Dropping any item resets rodCount to 0 and notifies player
execute as @a[scores={Job=1,itemDropped=1..}] run scoreboard players set @s rodCount 0
# Dropping any item resets ALL counters to prevent exploits
execute as @a[scores={Job=1,itemDropped=1..}] run scoreboard players set @s rodCount 0

# Anti-exploit: Reset progress when items are dropped or when containers are opened
execute as @a[scores={Job=1,itemDropped=1..}] run function economy:utilities/cleanup/reset_items
execute as @a[scores={Job=1,openChest=1..}] run function economy:utilities/cleanup/reset_items
execute as @a[scores={Job=1,openTrappedChest=1..}] run function economy:utilities/cleanup/reset_items
execute as @a[scores={Job=1,openBarrel=1..}] run function economy:utilities/cleanup/reset_items
execute as @a[scores={Job=1,openShulkerBox=1..}] run function economy:utilities/cleanup/reset_items

# Fish catches with XP and payment (only if rodCount > 0)
# Cod: 1 XP, 1 Fish
execute as @a[scores={Job=1,rodCount=1..,codCaught=1..}] run scoreboard players add @s FishingXP 1
execute as @a[scores={Job=1,rodCount=1..,codCaught=1..}] run scoreboard players add @s FishCaught 1

# Salmon: 1 XP, 1 Fish
execute as @a[scores={Job=1,rodCount=1..,salmonCaught=1..}] run scoreboard players add @s FishingXP 1
execute as @a[scores={Job=1,rodCount=1..,salmonCaught=1..}] run scoreboard players add @s FishCaught 1

# Pufferfish: 2 XP, 2 Fish
execute as @a[scores={Job=1,rodCount=1..,pufferfishCaught=1..}] run scoreboard players add @s FishingXP 2
execute as @a[scores={Job=1,rodCount=1..,pufferfishCaught=1..}] run scoreboard players add @s FishCaught 2

# Tropical Fish: 5 XP, 5 Fish
execute as @a[scores={Job=1,rodCount=1..,tropicalFishCaught=1..}] run scoreboard players add @s FishingXP 5
execute as @a[scores={Job=1,rodCount=1..,tropicalFishCaught=1..}] run scoreboard players add @s FishCaught 5

# Reduce rodCount by 1 for any fish caught
execute as @a[scores={Job=1,rodCount=1..,codCaught=1..}] run scoreboard players remove @s rodCount 1
execute as @a[scores={Job=1,rodCount=1..,salmonCaught=1..}] run scoreboard players remove @s rodCount 1
execute as @a[scores={Job=1,rodCount=1..,pufferfishCaught=1..}] run scoreboard players remove @s rodCount 1
execute as @a[scores={Job=1,rodCount=1..,tropicalFishCaught=1..}] run scoreboard players remove @s rodCount 1

# Prevent negative rodCount
execute as @a[scores={rodCount=..-1}] run scoreboard players set @s rodCount 0
# Reset counters
execute as @a[scores={fishingRodUsed=1..}] run scoreboard players set @s fishingRodUsed 0
execute as @a[scores={codCaught=1..}] run scoreboard players set @s codCaught 0
execute as @a[scores={salmonCaught=1..}] run scoreboard players set @s salmonCaught 0
execute as @a[scores={tropicalFishCaught=1..}] run scoreboard players set @s tropicalFishCaught 0
execute as @a[scores={pufferfishCaught=1..}] run scoreboard players set @s pufferfishCaught 0
execute as @a[scores={itemDropped=1..}] run scoreboard players set @s itemDropped 0
# ===== FARMER SYSTEM =====
# Track Farmer harvest (all crop item drops near player)
# Wheat, Potatoes, Carrots (normal value - 1 XP, 1 count each)
# Wheat
execute as @a[scores={Job=1,pickupWheat=1..,brokenWheat=1..}] run scoreboard players remove @s brokenWheat 1
execute as @a[scores={Job=1,pickupWheat=1..,brokenWheat=1..}] run scoreboard players add @s WheatHarvested 1
execute as @a[scores={Job=1,pickupWheat=1..,brokenWheat=1..}] run scoreboard players add @s FarmerXP 1
execute as @a[scores={Job=1,pickupWheat=1..}] run scoreboard players remove @s pickupWheat 1
# Potatoes
execute as @a[scores={Job=1,pickupPotato=1..,brokenPotatoes=1..}] run scoreboard players add @s WheatHarvested 1
execute as @a[scores={Job=1,pickupPotato=1..,brokenPotatoes=1..}] run scoreboard players add @s FarmerXP 1
execute as @a[scores={Job=1,pickupPotato=1..,brokenPotatoes=1..}] run scoreboard players remove @s brokenPotatoes 1
execute as @a[scores={Job=1,pickupPotato=1..}] run scoreboard players remove @s pickupPotato 1
# Carrots
execute as @a[scores={Job=1,pickupCarrot=1..,brokenCarrots=1..}] run scoreboard players remove @s brokenCarrots 1
execute as @a[scores={Job=1,pickupCarrot=1..,brokenCarrots=1..}] run scoreboard players add @s carrotCount 1
execute as @a[scores={Job=1,pickupCarrot=1..}] run scoreboard players remove @s pickupCarrot 1
# Process carrot groups of 3
execute as @a[scores={Job=1,carrotCount=3..}] run scoreboard players add @s WheatHarvested 1
execute as @a[scores={Job=1,carrotCount=3..}] run scoreboard players add @s FarmerXP 1
execute as @a[scores={Job=1,carrotCount=3..}] run scoreboard players remove @s carrotCount 3
# Beetroots
execute as @a[scores={Job=1,pickupBeetroot=1..,brokenBeetroots=1..}] run scoreboard players remove @s brokenBeetroots 1
execute as @a[scores={Job=1,pickupBeetroot=1..,brokenBeetroots=1..}] run scoreboard players add @s beetrootCount 1
execute as @a[scores={Job=1,pickupBeetroot=1..}] run scoreboard players remove @s pickupBeetroot 1
# Process beetroot pairs
execute as @a[scores={Job=1,beetrootCount=2..}] run scoreboard players add @s WheatHarvested 1
execute as @a[scores={Job=1,beetrootCount=2..}] run scoreboard players add @s FarmerXP 1
execute as @a[scores={Job=1,beetrootCount=2..}] run scoreboard players remove @s beetrootCount 2
# Pumpkins
execute as @a[scores={Job=1,pickupPumpkin=1..,brokenPumpkins=1..}] run scoreboard players add @s WheatHarvested 2
execute as @a[scores={Job=1,pickupPumpkin=1..,brokenPumpkins=1..}] run scoreboard players add @s FarmerXP 2
execute as @a[scores={Job=1,pickupPumpkin=1..,brokenPumpkins=1..}] run scoreboard players remove @s brokenPumpkins 1
execute as @a[scores={Job=1,pickupPumpkin=1..}] run scoreboard players remove @s pickupPumpkin 1
# Melons
execute as @a[scores={Job=1,pickupMelonSlice=1..,brokenMelons=1..}] run scoreboard players add @s melonSliceCount 1
execute as @a[scores={Job=1,pickupMelonSlice=1..}] run scoreboard players remove @s pickupMelonSlice 1
execute as @a[scores={Job=1,pickupMelonSlice=3..,brokenMelons=1..}] run scoreboard players remove @s brokenMelons 1
# Process melon slice groups of 3
execute as @a[scores={Job=1,melonSliceCount=3..}] run scoreboard players add @s WheatHarvested 2
execute as @a[scores={Job=1,melonSliceCount=3..}] run scoreboard players add @s FarmerXP 2
execute as @a[scores={Job=1,melonSliceCount=3..}] run scoreboard players remove @s melonSliceCount 3

# Only set proximity if it wasn't recently reset
execute as @a[scores={Job=1,pickupEgg=1..,eggProximity=0,eggResetTimer=0}] at @s if entity @e[type=chicken,distance=..5] run scoreboard players set @s eggProximity 1

# When items dropped, set reset timer instead of just resetting proximity
execute as @a[scores={Job=1,itemDropped=1..}] run scoreboard players set @s eggProximity 0
execute as @a[scores={Job=1,itemDropped=1..}] run scoreboard players set @s eggResetTimer 600

# Count down reset timer (600 ticks = 30 seconds)
execute as @a[scores={eggResetTimer=1..}] run scoreboard players remove @s eggResetTimer 1

# Award eggs only if proximity is valid
execute as @a[scores={Job=1,pickupEgg=1..,eggProximity=1,ranchCooldown=0}] run scoreboard players add @s eggCount 1
execute as @a[scores={Job=1,pickupEgg=1..}] run scoreboard players remove @s pickupEgg 1

# Reset eggProximity when containers opened (items already handled above)
execute as @a[scores={Job=1,openChest=1..}] run scoreboard players set @s eggProximity 0
execute as @a[scores={Job=1,openBarrel=1..}] run scoreboard players set @s eggProximity 0

# Process egg XP (every 2 eggs = 1 XP, no payment)
execute as @a[scores={Job=1,eggCount=2..,ranchCooldown=0}] run scoreboard players add @s RancherXP 1
execute as @a[scores={Job=1,eggCount=2..,ranchCooldown=0}] run scoreboard players remove @s eggCount 2

# Prevents negative broken count
execute as @a[scores={brokenWheat=..0}] run scoreboard players set @s brokenWheat 0
execute as @a[scores={brokenPotatoes=..0}] run scoreboard players set @s brokenPotatoes 0
execute as @a[scores={brokenCarrots=..0}] run scoreboard players set @s brokenCarrots 0
execute as @a[scores={brokenBeetroots=..0}] run scoreboard players set @s brokenBeetroots 0
execute as @a[scores={brokenPumpkins=..0}] run scoreboard players set @s brokenPumpkins 0
execute as @a[scores={brokenMelons=..0}] run scoreboard players set @s brokenMelons 0
# ===== MINER SYSTEM =====
# Track ore mining for Workers (Job=1) - Regular ores
execute as @a[scores={Job=1,pickupCoal=1..,brokenCoal=1..}] run scoreboard players add @s ores_mined 1
execute as @a[scores={Job=1,pickupCoal=1..,brokenCoal=1..}] run scoreboard players add @s MinerXP 1
execute as @a[scores={Job=1,pickupCoal=1..,brokenCoal=1..}] run scoreboard players remove @s brokenCoal 1
execute as @a[scores={Job=1,pickupCoal=1..}] run scoreboard players remove @s pickupCoal 1
execute as @a[scores={Job=1,pickupIron=1..,brokenIron=1..}] run scoreboard players remove @s brokenIron 1
execute as @a[scores={Job=1,pickupIron=1..,brokenIron=1..}] run scoreboard players add @s ores_mined 2
execute as @a[scores={Job=1,pickupIron=1..,brokenIron=1..}] run scoreboard players add @s MinerXP 2
execute as @a[scores={Job=1,pickupIron=1..}] run scoreboard players remove @s pickupIron 1
execute as @a[scores={Job=1,pickupGold=1..,brokenGold=1..}] run scoreboard players remove @s brokenGold 1
execute as @a[scores={Job=1,pickupGold=1..,brokenGold=1..}] run scoreboard players add @s ores_mined 3
execute as @a[scores={Job=1,pickupGold=1..,brokenGold=1..}] run scoreboard players add @s MinerXP 3
execute as @a[scores={Job=1,pickupGold=1..}] run scoreboard players remove @s pickupGold 1
execute as @a[scores={Job=1,pickupDiamond=1..,brokenDiamond=1..}] run scoreboard players remove @s brokenDiamond 1
execute as @a[scores={Job=1,pickupDiamond=1..,brokenDiamond=1..}] run scoreboard players add @s ores_mined 5
execute as @a[scores={Job=1,pickupDiamond=1..,brokenDiamond=1..}] run scoreboard players add @s MinerXP 5
execute as @a[scores={Job=1,pickupDiamond=1..}] run scoreboard players remove @s pickupDiamond 1
execute as @a[scores={Job=1,brokenEmerald=1..}] run scoreboard players add @s ores_mined 5
execute as @a[scores={Job=1,brokenEmerald=1..}] run scoreboard players add @s MinerXP 5
execute as @a[scores={Job=1,brokenEmerald=1..}] run scoreboard players remove @s brokenEmerald 1
execute as @a[scores={Job=1,brokenLapis=1..}] run scoreboard players add @s ores_mined 1
execute as @a[scores={Job=1,brokenLapis=1..}] run scoreboard players add @s MinerXP 1
execute as @a[scores={Job=1,brokenLapis=1..}] run scoreboard players remove @s brokenLapis 1
execute as @a[scores={Job=1,brokenRedstone=1..}] run scoreboard players add @s ores_mined 2
execute as @a[scores={Job=1,brokenRedstone=1..}] run scoreboard players add @s MinerXP 2
execute as @a[scores={Job=1,brokenRedstone=1..}] run scoreboard players remove @s brokenRedstone 1
execute as @a[scores={Job=1,brokenCopper=1..}] run scoreboard players add @s ores_mined 1
execute as @a[scores={Job=1,brokenCopper=1..}] run scoreboard players add @s MinerXP 1
execute as @a[scores={Job=1,brokenCopper=1..}] run scoreboard players remove @s brokenCopper 1
# Track Nether ore mining for Workers (Job=1)
execute as @a[scores={Job=1,pickupGoldNugget=1..,brokenNetherGold=1..}] run scoreboard players remove @s brokenNetherGold 1
execute as @a[scores={Job=1,pickupGoldNugget=1..,brokenNetherGold=1..}] run scoreboard players add @s ores_mined 3
execute as @a[scores={Job=1,pickupGoldNugget=1..,brokenNetherGold=1..}] run scoreboard players add @s MinerXP 3
execute as @a[scores={Job=1,pickupGoldNugget=1..}] run scoreboard players remove @s pickupGoldNugget 1
execute as @a[scores={Job=1,pickupQuartz=1..,brokenNetherQuartz=1..}] run scoreboard players remove @s brokenNetherQuartz 1
execute as @a[scores={Job=1,pickupQuartz=1..,brokenNetherQuartz=1..}] run scoreboard players add @s ores_mined 2
execute as @a[scores={Job=1,pickupQuartz=1..,brokenNetherQuartz=1..}] run scoreboard players add @s MinerXP 2
execute as @a[scores={Job=1,pickupQuartz=1..}] run scoreboard players remove @s pickupQuartz 1
# Track deepslate ore mining for Workers
execute as @a[scores={Job=1,brokenDeepCoal=1..}] run scoreboard players add @s ores_mined 2
execute as @a[scores={Job=1,brokenDeepCoal=1..}] run scoreboard players add @s MinerXP 2
execute as @a[scores={Job=1,brokenDeepCoal=1..}] run scoreboard players remove @s brokenDeepCoal 1
execute as @a[scores={Job=1,brokenDeepIron=1..}] run scoreboard players add @s ores_mined 2
execute as @a[scores={Job=1,brokenDeepIron=1..}] run scoreboard players add @s MinerXP 2
execute as @a[scores={Job=1,brokenDeepIron=1..}] run scoreboard players remove @s brokenDeepIron 1
execute as @a[scores={Job=1,brokenDeepGold=1..}] run scoreboard players add @s ores_mined 4
execute as @a[scores={Job=1,brokenDeepGold=1..}] run scoreboard players add @s MinerXP 4
execute as @a[scores={Job=1,brokenDeepGold=1..}] run scoreboard players remove @s brokenDeepGold 1
execute as @a[scores={Job=1,brokenDeepDiamond=1..}] run scoreboard players add @s ores_mined 6
execute as @a[scores={Job=1,brokenDeepDiamond=1..}] run scoreboard players add @s MinerXP 6
execute as @a[scores={Job=1,brokenDeepDiamond=1..}] run scoreboard players remove @s brokenDeepDiamond 1
execute as @a[scores={Job=1,brokenDeepEmerald=1..}] run scoreboard players add @s ores_mined 6
execute as @a[scores={Job=1,brokenDeepEmerald=1..}] run scoreboard players add @s MinerXP 6
execute as @a[scores={Job=1,brokenDeepEmerald=1..}] run scoreboard players remove @s brokenDeepEmerald 1
execute as @a[scores={Job=1,brokenDeepLapis=1..}] run scoreboard players add @s ores_mined 2
execute as @a[scores={Job=1,brokenDeepLapis=1..}] run scoreboard players add @s MinerXP 2
execute as @a[scores={Job=1,brokenDeepLapis=1..}] run scoreboard players remove @s brokenDeepLapis 1
execute as @a[scores={Job=1,brokenDeepRedstone=1..}] run scoreboard players add @s ores_mined 3
execute as @a[scores={Job=1,brokenDeepRedstone=1..}] run scoreboard players add @s MinerXP 3
execute as @a[scores={Job=1,brokenDeepRedstone=1..}] run scoreboard players remove @s brokenDeepRedstone 1
execute as @a[scores={Job=1,brokenDeepCopper=1..}] run scoreboard players add @s ores_mined 2
execute as @a[scores={Job=1,brokenDeepCopper=1..}] run scoreboard players add @s MinerXP 2
execute as @a[scores={Job=1,brokenDeepCopper=1..}] run scoreboard players remove @s brokenDeepCopper 1
# Prevent negative ore counts
execute as @a[scores={brokenCoal=..-1}] run scoreboard players set @s brokenCoal 0
execute as @a[scores={brokenIron=..-1}] run scoreboard players set @s brokenIron 0
execute as @a[scores={brokenGold=..-1}] run scoreboard players set @s brokenGold 0
execute as @a[scores={brokenDiamond=..-1}] run scoreboard players set @s brokenDiamond 0
execute as @a[scores={brokenEmerald=..-1}] run scoreboard players set @s brokenEmerald 0
execute as @a[scores={brokenLapis=..-1}] run scoreboard players set @s brokenLapis 0
execute as @a[scores={brokenRedstone=..-1}] run scoreboard players set @s brokenRedstone 0
execute as @a[scores={brokenCopper=..-1}] run scoreboard players set @s brokenCopper 0
execute as @a[scores={brokenDeepCoal=..-1}] run scoreboard players set @s brokenDeepCoal 0
execute as @a[scores={brokenDeepIron=..-1}] run scoreboard players set @s brokenDeepIron 0
execute as @a[scores={brokenDeepGold=..-1}] run scoreboard players set @s brokenDeepGold 0
execute as @a[scores={brokenDeepDiamond=..-1}] run scoreboard players set @s brokenDeepDiamond 0
execute as @a[scores={brokenDeepEmerald=..-1}] run scoreboard players set @s brokenDeepEmerald 0
execute as @a[scores={brokenDeepLapis=..-1}] run scoreboard players set @s brokenDeepLapis 0
execute as @a[scores={brokenDeepRedstone=..-1}] run scoreboard players set @s brokenDeepRedstone 0
execute as @a[scores={brokenDeepCopper=..-1}] run scoreboard players set @s brokenDeepCopper 0
# Prevent negative Nether ore counts
execute as @a[scores={brokenNetherGold=..-1}] run scoreboard players set @s brokenNetherGold 0
execute as @a[scores={brokenNetherQuartz=..-1}] run scoreboard players set @s brokenNetherQuartz 0

# Daily preprocessing calculations
execute store result score #currentTick dummy run time query daytime
execute if score #currentTick dummy matches 11800..11900 unless score #preprocessFlag preprocessFlag matches 1 run function economy:preprocessing/daily_calculations
execute if score #currentTick dummy matches 11901.. run scoreboard players set #preprocessFlag preprocessFlag 0

# Handle price setting trigger
execute as @a[scores={setPrice=1..}] run function economy:jobs/realtor/set_chunk_price
# ===== DAILY PAYMENT SYSTEM =====
execute store result score #currentTime dummy run time query daytime
# Update individual sidebar display every 60 ticks (3 seconds)
execute if score #currentTime dummy matches 0..23999 run function economy:utilities/display/individual_sidebar
# Pay workers at sunset (only once per day)
execute if score #currentTime dummy matches 12000..13000 if score workerPayFlag workerPayFlag matches 0 run function economy:jobs/general/pay_workers
execute if score #currentTime dummy matches 12000..13000 if score workerPayFlag workerPayFlag matches 0 run scoreboard players set workerPayFlag workerPayFlag 1
# Reset flags at dawn
execute if score #currentTime dummy matches 0..11999 run scoreboard players set workerPayFlag workerPayFlag 0
execute if score #currentTime dummy matches 0..11999 run scoreboard players set woolProcessFlag woolProcessFlag 0