# Pay Workers (Combined payment with individual job level bonuses)
# Calculates separate payments for farming, mining, and ranching based on individual levels

# Save money before payment for PayDiff calculation
execute as @a[scores={Job=1}] run scoreboard players operation @s moneyBefore = @s money

# Initialize payment calculations
execute as @a[scores={Job=1}] run scoreboard players set @s dummy 0

# Calculate farming payment based on FarmerLevel
execute as @a[scores={Job=1,FarmerLevel=1,WheatHarvested=1..}] run scoreboard players set @s targetJob 1
execute as @a[scores={Job=1,FarmerLevel=2,WheatHarvested=1..}] run scoreboard players set @s targetJob 2
execute as @a[scores={Job=1,FarmerLevel=3,WheatHarvested=1..}] run scoreboard players set @s targetJob 3
execute as @a[scores={Job=1,FarmerLevel=4,WheatHarvested=1..}] run scoreboard players set @s targetJob 4
execute as @a[scores={Job=1,FarmerLevel=5,WheatHarvested=1..}] run scoreboard players set @s targetJob 5
execute as @a[scores={Job=1,FarmerLevel=6,WheatHarvested=1..}] run scoreboard players set @s targetJob 6
execute as @a[scores={Job=1,FarmerLevel=7,WheatHarvested=1..}] run scoreboard players set @s targetJob 7
execute as @a[scores={Job=1,FarmerLevel=8,WheatHarvested=1..}] run scoreboard players set @s targetJob 8
execute as @a[scores={Job=1,FarmerLevel=9,WheatHarvested=1..}] run scoreboard players set @s targetJob 9
execute as @a[scores={Job=1,FarmerLevel=10,WheatHarvested=1..}] run scoreboard players set @s targetJob 10

# Add farming payment to total
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s targetJob *= @s WheatHarvested
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s dummy += @s targetJob

# Calculate mining payment based on MinerLevel
execute as @a[scores={Job=1,MinerLevel=1,ores_mined=1..}] run scoreboard players set @s targetJob 3
execute as @a[scores={Job=1,MinerLevel=2,ores_mined=1..}] run scoreboard players set @s targetJob 4
execute as @a[scores={Job=1,MinerLevel=3,ores_mined=1..}] run scoreboard players set @s targetJob 5
execute as @a[scores={Job=1,MinerLevel=4,ores_mined=1..}] run scoreboard players set @s targetJob 6
execute as @a[scores={Job=1,MinerLevel=5,ores_mined=1..}] run scoreboard players set @s targetJob 7
execute as @a[scores={Job=1,MinerLevel=6,ores_mined=1..}] run scoreboard players set @s targetJob 8
execute as @a[scores={Job=1,MinerLevel=7,ores_mined=1..}] run scoreboard players set @s targetJob 9
execute as @a[scores={Job=1,MinerLevel=8,ores_mined=1..}] run scoreboard players set @s targetJob 10
execute as @a[scores={Job=1,MinerLevel=9,ores_mined=1..}] run scoreboard players set @s targetJob 11
execute as @a[scores={Job=1,MinerLevel=10,ores_mined=1..}] run scoreboard players set @s targetJob 12

# Add mining payment to total
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s targetJob *= @s ores_mined
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s dummy += @s targetJob

# Calculate ranching payment based on RancherLevel
execute as @a[scores={Job=1,RancherLevel=1,RanchHarvested=1..}] run scoreboard players set @s targetJob 1
execute as @a[scores={Job=1,RancherLevel=2,RanchHarvested=1..}] run scoreboard players set @s targetJob 2
execute as @a[scores={Job=1,RancherLevel=3,RanchHarvested=1..}] run scoreboard players set @s targetJob 3
execute as @a[scores={Job=1,RancherLevel=4,RanchHarvested=1..}] run scoreboard players set @s targetJob 4
execute as @a[scores={Job=1,RancherLevel=5,RanchHarvested=1..}] run scoreboard players set @s targetJob 5
execute as @a[scores={Job=1,RancherLevel=6,RanchHarvested=1..}] run scoreboard players set @s targetJob 6
execute as @a[scores={Job=1,RancherLevel=7,RanchHarvested=1..}] run scoreboard players set @s targetJob 7
execute as @a[scores={Job=1,RancherLevel=8,RanchHarvested=1..}] run scoreboard players set @s targetJob 8
execute as @a[scores={Job=1,RancherLevel=9,RanchHarvested=1..}] run scoreboard players set @s targetJob 9
execute as @a[scores={Job=1,RancherLevel=10,RanchHarvested=1..}] run scoreboard players set @s targetJob 10

# Calculate blacksmith payment based on BlacksmithLevel
execute as @a[scores={Job=1,BlacksmithLevel=1,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 2
execute as @a[scores={Job=1,BlacksmithLevel=2,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 3
execute as @a[scores={Job=1,BlacksmithLevel=3,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 4
execute as @a[scores={Job=1,BlacksmithLevel=4,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 5
execute as @a[scores={Job=1,BlacksmithLevel=5,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 6
execute as @a[scores={Job=1,BlacksmithLevel=6,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 7
execute as @a[scores={Job=1,BlacksmithLevel=7,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 8
execute as @a[scores={Job=1,BlacksmithLevel=8,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 9
execute as @a[scores={Job=1,BlacksmithLevel=9,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 10
execute as @a[scores={Job=1,BlacksmithLevel=10,BlacksmithCrafted=1..}] run scoreboard players set @s targetJob 11

# Calculate lumber payment based on lumberlevel
execute as @a[scores={Job=1,lumberlevel=1,lumber=1..}] run scoreboard players set @s targetJob 2
execute as @a[scores={Job=1,lumberlevel=2,lumber=1..}] run scoreboard players set @s targetJob 3
execute as @a[scores={Job=1,lumberlevel=3,lumber=1..}] run scoreboard players set @s targetJob 4
execute as @a[scores={Job=1,lumberlevel=4,lumber=1..}] run scoreboard players set @s targetJob 5
execute as @a[scores={Job=1,lumberlevel=5,lumber=1..}] run scoreboard players set @s targetJob 6
execute as @a[scores={Job=1,lumberlevel=6,lumber=1..}] run scoreboard players set @s targetJob 7
execute as @a[scores={Job=1,lumberlevel=7,lumber=1..}] run scoreboard players set @s targetJob 8
execute as @a[scores={Job=1,lumberlevel=8,lumber=1..}] run scoreboard players set @s targetJob 9
execute as @a[scores={Job=1,lumberlevel=9,lumber=1..}] run scoreboard players set @s targetJob 10
execute as @a[scores={Job=1,lumberlevel=10,lumber=1..}] run scoreboard players set @s targetJob 11

# Add lumber payment to total
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s targetJob *= @s lumber
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s dummy += @s targetJob

# Add blacksmith payment to total
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s targetJob *= @s BlacksmithCrafted
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s dummy += @s targetJob

# Add ranching payment to total
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s targetJob *= @s RanchHarvested
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s dummy += @s targetJob

# Calculate hunting payment based on HunterLevel
execute as @a[scores={Job=1,HunterLevel=1,Hunt=1..}] run scoreboard players set @s targetJob 2
execute as @a[scores={Job=1,HunterLevel=2,Hunt=1..}] run scoreboard players set @s targetJob 3
execute as @a[scores={Job=1,HunterLevel=3,Hunt=1..}] run scoreboard players set @s targetJob 4
execute as @a[scores={Job=1,HunterLevel=4,Hunt=1..}] run scoreboard players set @s targetJob 5
execute as @a[scores={Job=1,HunterLevel=5,Hunt=1..}] run scoreboard players set @s targetJob 6
execute as @a[scores={Job=1,HunterLevel=6,Hunt=1..}] run scoreboard players set @s targetJob 7
execute as @a[scores={Job=1,HunterLevel=7,Hunt=1..}] run scoreboard players set @s targetJob 8
execute as @a[scores={Job=1,HunterLevel=8,Hunt=1..}] run scoreboard players set @s targetJob 9
execute as @a[scores={Job=1,HunterLevel=9,Hunt=1..}] run scoreboard players set @s targetJob 10
execute as @a[scores={Job=1,HunterLevel=10,Hunt=1..}] run scoreboard players set @s targetJob 11

# Add hunting payment to total
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s targetJob *= @s Hunt
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s dummy += @s targetJob

# Calculate fishing payment based on FishingLevel
execute as @a[scores={Job=1,FishingLevel=1,FishCaught=1..}] run scoreboard players set @s targetJob 1
execute as @a[scores={Job=1,FishingLevel=2,FishCaught=1..}] run scoreboard players set @s targetJob 2
execute as @a[scores={Job=1,FishingLevel=3,FishCaught=1..}] run scoreboard players set @s targetJob 3
execute as @a[scores={Job=1,FishingLevel=4,FishCaught=1..}] run scoreboard players set @s targetJob 4
execute as @a[scores={Job=1,FishingLevel=5,FishCaught=1..}] run scoreboard players set @s targetJob 5
execute as @a[scores={Job=1,FishingLevel=6,FishCaught=1..}] run scoreboard players set @s targetJob 6
execute as @a[scores={Job=1,FishingLevel=7,FishCaught=1..}] run scoreboard players set @s targetJob 7
execute as @a[scores={Job=1,FishingLevel=8,FishCaught=1..}] run scoreboard players set @s targetJob 8
execute as @a[scores={Job=1,FishingLevel=9,FishCaught=1..}] run scoreboard players set @s targetJob 9
execute as @a[scores={Job=1,FishingLevel=10,FishCaught=1..}] run scoreboard players set @s targetJob 10

# Add fishing payment to total
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s targetJob *= @s FishCaught
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s dummy += @s targetJob

# Apply total payment
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s lastPaycheck = @s dummy
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s money += @s dummy

# Set $0 paycheck for workers with no work
execute as @a[scores={Job=1,dummy=0}] run scoreboard players set @s lastPaycheck 0

# Send detailed payment breakdown
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"=== SUNSET PAYMENT ===","color":"gold","bold":true}]
execute as @a[scores={Job=1,WheatHarvested=1..}] run tellraw @s [{"text":"Farm Work: ","color":"green"},{"score":{"name":"@s","objective":"WheatHarvested"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"FarmerLevel"},"color":"green"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,ores_mined=1..}] run tellraw @s [{"text":"Mine Work: ","color":"blue"},{"score":{"name":"@s","objective":"ores_mined"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"MinerLevel"},"color":"blue"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,RanchHarvested=1..}] run tellraw @s [{"text":"Ranch Work: ","color":"gold"},{"score":{"name":"@s","objective":"RanchHarvested"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"RancherLevel"},"color":"gold"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"Total Pay: $","color":"yellow","bold":true},{"score":{"name":"@s","objective":"dummy"},"color":"green","bold":true}]
execute as @a[scores={Job=1,Hunt=1..}] run tellraw @s [{"text":"Hunt Work: ","color":"red"},{"score":{"name":"@s","objective":"Hunt"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"HunterLevel"},"color":"red"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,FishCaught=1..}] run tellraw @s [{"text":"Fish Work: ","color":"aqua"},{"score":{"name":"@s","objective":"FishCaught"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"FishingLevel"},"color":"aqua"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run tellraw @s [{"text":"Blacksmith Work: ","color":"gold"},{"score":{"name":"@s","objective":"BlacksmithCrafted"},"color":"white"},{"text":" items (Lv","color":"gray"},{"score":{"name":"@s","objective":"BlacksmithLevel"},"color":"gold"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,lumber=1..}] run tellraw @s [{"text":"Lumber Work: ","color":"dark_green"},{"score":{"name":"@s","objective":"lumber"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"lumberlevel"},"color":"dark_green"},{"text":")","color":"gray"}]


execute as @a[scores={Job=1,dummy=0}] run tellraw @s {"text":"No work completed today, no pay!","color":"red"}


# Debug message showing XP breakdown
execute as @a[scores={Job=1}] run tellraw @s [{"text":"XP - Farm: ","color":"gray"},{"score":{"name":"@s","objective":"FarmerXP"},"color":"green"},{"text":" | Mine: ","color":"gray"},{"score":{"name":"@s","objective":"MinerXP"},"color":"blue"},{"text":" | Ranch: ","color":"gray"},{"score":{"name":"@s","objective":"RancherXP"},"color":"gold"},{"text":" | Hunt: ","color":"gray"},{"score":{"name":"@s","objective":"HunterXP"},"color":"red"},{"text":" | Fish: ","color":"gray"},{"score":{"name":"@s","objective":"FishingXP"},"color":"aqua"},{"text":" | Smith: ","color":"gray"},{"score":{"name":"@s","objective":"BlacksmithXP"},"color":"gold"},{"text":" | Lumber: ","color":"gray"},{"score":{"name":"@s","objective":"lumberXP"},"color":"dark_green"}]


# Check promotions for all workers after paying them
execute as @a[scores={Job=1}] run function economy:jobs/general/check_promotion
execute as @a[scores={Job=1}] run function economy:jobs/general/team_promotion
# Reset work counters
scoreboard players set @a[scores={Job=1}] WheatHarvested 0
scoreboard players set @a[scores={Job=1}] ores_mined 0
scoreboard players set @a[scores={Job=1}] RanchHarvested 0
scoreboard players set @a[scores={Job=1}] Hunt 0
scoreboard players set @a[scores={Job=1}] FishCaught 0
scoreboard players set @a[scores={Job=1}] BlacksmithCrafted 0
scoreboard players set @a[scores={Job=1}] lumber 0

# Reset temporary scores
scoreboard players set @a[scores={Job=1}] dummy 0
scoreboard players set @a[scores={Job=1}] targetJob 0

# Calculate PayDiff (money gained) after payment
execute as @a[scores={Job=1}] run scoreboard players operation @s PayDiff = @s money
execute as @a[scores={Job=1}] run scoreboard players operation @s PayDiff -= @s moneyBefore

# Set flag to prevent multiple pays
scoreboard players set workerPayFlag workerPayFlag 1