# Player wants to sell cook stock
# Format: /trigger sellCookStock set <shares>

# Store requested amount
scoreboard players operation @s tradeAmount = @s sellCookStock

# Calculate value (price * shares * 0.95 after commission)
scoreboard players operation @s tradeCost = #cookStock cookStockPrice
scoreboard players operation @s tradeCost *= @s tradeAmount
scoreboard players operation @s commission = @s tradeCost
scoreboard players set @s stockTemp 20
scoreboard players operation @s commission /= @s stockTemp
scoreboard players operation @s tradeCost -= @s commission

# Check if player has enough shares
execute if score @s cookShares >= @s tradeAmount run scoreboard players operation @s cookShares -= @s tradeAmount
execute if score @s cookShares >= @s tradeAmount run scoreboard players operation @s money += @s tradeCost
execute if score @s cookShares >= @s tradeAmount run scoreboard players operation #cityBank cityBank += @s commission
execute if score @s cookShares >= @s tradeAmount run scoreboard players operation #cookStock cookSellPressure += @s tradeAmount
execute if score @s cookShares >= @s tradeAmount run tellraw @s [{"text":"✓ Sold ","color":"green"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" Cook shares for $","color":"green"},{"score":{"name":"@s","objective":"tradeCost"},"color":"white"},{"text":" (after $","color":"gray"},{"score":{"name":"@s","objective":"commission"},"color":"white"},{"text":" commission)","color":"gray"}]

# Enhanced insufficient shares message
execute unless score @s cookShares >= @s tradeAmount run tellraw @s [{"text":"✗ Insufficient shares!","color":"red"}]
execute unless score @s cookShares >= @s tradeAmount run tellraw @s [{"text":"You own: ","color":"yellow"},{"score":{"name":"@s","objective":"cookShares"},"color":"white"},{"text":" Cook shares","color":"yellow"}]
execute unless score @s cookShares >= @s tradeAmount run tellraw @s [{"text":"You tried to sell: ","color":"yellow"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" shares","color":"yellow"}]
execute unless score @s cookShares >= @s tradeAmount run scoreboard players operation @s shareValue = @s tradeAmount
execute unless score @s cookShares >= @s tradeAmount run scoreboard players operation @s shareValue -= @s cookShares
execute unless score @s cookShares >= @s tradeAmount run tellraw @s [{"text":"You need ","color":"red"},{"score":{"name":"@s","objective":"shareValue"},"color":"white"},{"text":" more shares!","color":"red"}]

# Reset trigger
scoreboard players set @s sellCookStock 0
scoreboard players enable @s sellCookStock