# Pay Workers (Combined payment with individual job level bonuses)
# Calculates separate payments for farming, mining, and ranching based on individual levels
# Save money before payment for PayDiff calculation
execute as @a[scores={Job=1}] run scoreboard players operation @s moneyBefore = @s money

# Initialize payment calculations
execute as @a[scores={Job=1}] run scoreboard players set @s dummy 0

# FARMER PAYMENT (with multiplier)
execute as @a[scores={Job=1,FarmerLevel=1,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 10
execute as @a[scores={Job=1,FarmerLevel=2,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 12
execute as @a[scores={Job=1,FarmerLevel=3,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 14
execute as @a[scores={Job=1,FarmerLevel=4,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 16
execute as @a[scores={Job=1,FarmerLevel=5,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 18
execute as @a[scores={Job=1,FarmerLevel=6,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 20
execute as @a[scores={Job=1,FarmerLevel=7,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 22
execute as @a[scores={Job=1,FarmerLevel=8,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 24
execute as @a[scores={Job=1,FarmerLevel=9,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 26
execute as @a[scores={Job=1,FarmerLevel=10,WheatHarvested=1..}] run scoreboard players set @s totalFarmer 30

# Divide payment by 10 (always applied)
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s totalFarmer /= #10 dummy

# Apply multiplier to farming payment
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s totalFarmer *= @s WheatHarvested
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s totalFarmer *= #global farmerMult
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s totalFarmer /= @s multiplier

# Apply event multiplier if Harvest Festival is active
execute as @a[scores={Job=1,WheatHarvested=1..}] if score #global eventActive matches 1 if score #global eventJob matches 1 run scoreboard players operation @s totalFarmer *= #global eventMoneyMult
execute as @a[scores={Job=1,WheatHarvested=1..}] if score #global eventActive matches 1 if score #global eventJob matches 1 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,WheatHarvested=1..}] if score #global eventActive matches 1 if score #global eventJob matches 1 run scoreboard players operation @s totalFarmer /= @s multiplier

# Add to final payment
execute as @a[scores={Job=1,WheatHarvested=1..}] run scoreboard players operation @s dummy += @s totalFarmer

# Divide mining values by 10 before payment calculations
execute as @a[scores={Job=1,MinerXP=1..}] run scoreboard players operation @s MinerXP /= #10 dummy
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s ores_mined /= #10 dummy
# MINER PAYMENT (with multiplier)
execute as @a[scores={Job=1,MinerLevel=1,ores_mined=1..}] run scoreboard players set @s totalMiner 10
execute as @a[scores={Job=1,MinerLevel=2,ores_mined=1..}] run scoreboard players set @s totalMiner 12
execute as @a[scores={Job=1,MinerLevel=3,ores_mined=1..}] run scoreboard players set @s totalMiner 14
execute as @a[scores={Job=1,MinerLevel=4,ores_mined=1..}] run scoreboard players set @s totalMiner 16
execute as @a[scores={Job=1,MinerLevel=5,ores_mined=1..}] run scoreboard players set @s totalMiner 18
execute as @a[scores={Job=1,MinerLevel=6,ores_mined=1..}] run scoreboard players set @s totalMiner 20
execute as @a[scores={Job=1,MinerLevel=7,ores_mined=1..}] run scoreboard players set @s totalMiner 22
execute as @a[scores={Job=1,MinerLevel=8,ores_mined=1..}] run scoreboard players set @s totalMiner 24
execute as @a[scores={Job=1,MinerLevel=9,ores_mined=1..}] run scoreboard players set @s totalMiner 26
execute as @a[scores={Job=1,MinerLevel=10,ores_mined=1..}] run scoreboard players set @s totalMiner 30
# Apply multiplier to mining payment
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s totalMiner /= #10 dummy
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s totalMiner *= @s ores_mined
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s totalMiner *= #global minerMult
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s totalMiner /= @s multiplier
# Apply event multiplier if Gold Rush is active
execute as @a[scores={Job=1,ores_mined=1..}] if score #global eventActive matches 1 if score #global eventJob matches 2 run scoreboard players operation @s totalMiner *= #global eventMoneyMult
execute as @a[scores={Job=1,ores_mined=1..}] if score #global eventActive matches 1 if score #global eventJob matches 2 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,ores_mined=1..}] if score #global eventActive matches 1 if score #global eventJob matches 2 run scoreboard players operation @s totalMiner /= @s multiplier
execute as @a[scores={Job=1,ores_mined=1..}] run scoreboard players operation @s dummy += @s totalMiner

# RANCHER PAYMENT (with multiplier)
execute as @a[scores={Job=1,RancherLevel=1,RanchHarvested=1..}] run scoreboard players set @s totalRancher 10
execute as @a[scores={Job=1,RancherLevel=2,RanchHarvested=1..}] run scoreboard players set @s totalRancher 12
execute as @a[scores={Job=1,RancherLevel=3,RanchHarvested=1..}] run scoreboard players set @s totalRancher 14
execute as @a[scores={Job=1,RancherLevel=4,RanchHarvested=1..}] run scoreboard players set @s totalRancher 16
execute as @a[scores={Job=1,RancherLevel=5,RanchHarvested=1..}] run scoreboard players set @s totalRancher 18
execute as @a[scores={Job=1,RancherLevel=6,RanchHarvested=1..}] run scoreboard players set @s totalRancher 20
execute as @a[scores={Job=1,RancherLevel=7,RanchHarvested=1..}] run scoreboard players set @s totalRancher 22
execute as @a[scores={Job=1,RancherLevel=8,RanchHarvested=1..}] run scoreboard players set @s totalRancher 24
execute as @a[scores={Job=1,RancherLevel=9,RanchHarvested=1..}] run scoreboard players set @s totalRancher 26
execute as @a[scores={Job=1,RancherLevel=10,RanchHarvested=1..}] run scoreboard players set @s totalRancher 30
# Apply multiplier to rancher payment
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s totalRancher /= #10 dummy
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s totalRancher *= @s RanchHarvested
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s totalRancher *= #global hunterMult
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s totalRancher /= @s multiplier
# Apply event multiplier if Livestock Fair is active
execute as @a[scores={Job=1,RanchHarvested=1..}] if score #global eventActive matches 1 if score #global eventJob matches 3 run scoreboard players operation @s totalRancher *= #global eventMoneyMult
execute as @a[scores={Job=1,RanchHarvested=1..}] if score #global eventActive matches 1 if score #global eventJob matches 3 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,RanchHarvested=1..}] if score #global eventActive matches 1 if score #global eventJob matches 3 run scoreboard players operation @s totalRancher /= @s multiplier
execute as @a[scores={Job=1,RanchHarvested=1..}] run scoreboard players operation @s dummy += @s totalRancher

# BLACKSMITH PAYMENT (with multiplier)
execute as @a[scores={Job=1,BlacksmithLevel=1,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 10
execute as @a[scores={Job=1,BlacksmithLevel=2,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 12
execute as @a[scores={Job=1,BlacksmithLevel=3,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 14
execute as @a[scores={Job=1,BlacksmithLevel=4,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 16
execute as @a[scores={Job=1,BlacksmithLevel=5,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 18
execute as @a[scores={Job=1,BlacksmithLevel=6,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 20
execute as @a[scores={Job=1,BlacksmithLevel=7,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 22
execute as @a[scores={Job=1,BlacksmithLevel=8,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 24
execute as @a[scores={Job=1,BlacksmithLevel=9,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 26
execute as @a[scores={Job=1,BlacksmithLevel=10,BlacksmithCrafted=1..}] run scoreboard players set @s totalBlacksmith 30
# Apply multiplier to blacksmith payment
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s totalBlacksmith /= #10 dummy
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s totalBlacksmith *= @s BlacksmithCrafted
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s totalBlacksmith *= #global blacksmithMult
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s totalBlacksmith /= @s multiplier
# Apply event multiplier if Forge Masters Week is active
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] if score #global eventActive matches 1 if score #global eventJob matches 6 run scoreboard players operation @s totalBlacksmith *= #global eventMoneyMult
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] if score #global eventActive matches 1 if score #global eventJob matches 6 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] if score #global eventActive matches 1 if score #global eventJob matches 6 run scoreboard players operation @s totalBlacksmith /= @s multiplier
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run scoreboard players operation @s dummy += @s totalBlacksmith

# lumber PAYMENT (with multiplier)
execute as @a[scores={Job=1,lumberlevel=1,lumber=1..}] run scoreboard players set @s totallumber 10
execute as @a[scores={Job=1,lumberlevel=2,lumber=1..}] run scoreboard players set @s totallumber 12
execute as @a[scores={Job=1,lumberlevel=3,lumber=1..}] run scoreboard players set @s totallumber 14
execute as @a[scores={Job=1,lumberlevel=4,lumber=1..}] run scoreboard players set @s totallumber 16
execute as @a[scores={Job=1,lumberlevel=5,lumber=1..}] run scoreboard players set @s totallumber 18
execute as @a[scores={Job=1,lumberlevel=6,lumber=1..}] run scoreboard players set @s totallumber 20
execute as @a[scores={Job=1,lumberlevel=7,lumber=1..}] run scoreboard players set @s totallumber 22
execute as @a[scores={Job=1,lumberlevel=8,lumber=1..}] run scoreboard players set @s totallumber 24
execute as @a[scores={Job=1,lumberlevel=9,lumber=1..}] run scoreboard players set @s totallumber 26
execute as @a[scores={Job=1,lumberlevel=10,lumber=1..}] run scoreboard players set @s totallumber 30
# Apply multiplier to lumber payment
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s totallumber /= #10 dummy
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s totallumber *= @s lumber
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s totallumber *= #global lumberjackMult
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s totallumber /= @s multiplier
# Apply event multiplier if Timber Boom is active
execute as @a[scores={Job=1,lumber=1..}] if score #global eventActive matches 1 if score #global eventJob matches 7 run scoreboard players operation @s totallumber *= #global eventMoneyMult
execute as @a[scores={Job=1,lumber=1..}] if score #global eventActive matches 1 if score #global eventJob matches 7 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,lumber=1..}] if score #global eventActive matches 1 if score #global eventJob matches 7 run scoreboard players operation @s totallumber /= @s multiplier
execute as @a[scores={Job=1,lumber=1..}] run scoreboard players operation @s dummy += @s totallumber

# ARCHER PAYMENT (with multiplier)
execute as @a[scores={Job=1,ArcherLevel=1,ArcherKills=1..}] run scoreboard players set @s totalArcher 10
execute as @a[scores={Job=1,ArcherLevel=2,ArcherKills=1..}] run scoreboard players set @s totalArcher 12
execute as @a[scores={Job=1,ArcherLevel=3,ArcherKills=1..}] run scoreboard players set @s totalArcher 14
execute as @a[scores={Job=1,ArcherLevel=4,ArcherKills=1..}] run scoreboard players set @s totalArcher 16
execute as @a[scores={Job=1,ArcherLevel=5,ArcherKills=1..}] run scoreboard players set @s totalArcher 18
execute as @a[scores={Job=1,ArcherLevel=6,ArcherKills=1..}] run scoreboard players set @s totalArcher 20
execute as @a[scores={Job=1,ArcherLevel=7,ArcherKills=1..}] run scoreboard players set @s totalArcher 22
execute as @a[scores={Job=1,ArcherLevel=8,ArcherKills=1..}] run scoreboard players set @s totalArcher 24
execute as @a[scores={Job=1,ArcherLevel=9,ArcherKills=1..}] run scoreboard players set @s totalArcher 26
execute as @a[scores={Job=1,ArcherLevel=10,ArcherKills=1..}] run scoreboard players set @s totalArcher 30
# Apply multiplier to archer payment
execute as @a[scores={Job=1,ArcherKills=1..}] run scoreboard players operation @s totalArcher /= #10 dummy
execute as @a[scores={Job=1,ArcherKills=1..}] run scoreboard players operation @s totalArcher *= @s ArcherKills
execute as @a[scores={Job=1,ArcherKills=1..}] run scoreboard players operation @s totalArcher *= #global archerMult
execute as @a[scores={Job=1,ArcherKills=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,ArcherKills=1..}] run scoreboard players operation @s totalArcher /= @s multiplier
# Apply event multiplier if Marksmanship Tournament is active
execute as @a[scores={Job=1,ArcherKills=1..}] if score #global eventActive matches 1 if score #global eventJob matches 9 run scoreboard players operation @s totalArcher *= #global eventMoneyMult
execute as @a[scores={Job=1,ArcherKills=1..}] if score #global eventActive matches 1 if score #global eventJob matches 9 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,ArcherKills=1..}] if score #global eventActive matches 1 if score #global eventJob matches 9 run scoreboard players operation @s totalArcher /= @s multiplier
execute as @a[scores={Job=1,ArcherKills=1..}] run scoreboard players operation @s dummy += @s totalArcher

# WARRIOR PAYMENT (with multiplier)
execute as @a[scores={Job=1,WarriorLevel=1,WarriorKills=1..}] run scoreboard players set @s totalWarrior 10
execute as @a[scores={Job=1,WarriorLevel=2,WarriorKills=1..}] run scoreboard players set @s totalWarrior 12
execute as @a[scores={Job=1,WarriorLevel=3,WarriorKills=1..}] run scoreboard players set @s totalWarrior 14
execute as @a[scores={Job=1,WarriorLevel=4,WarriorKills=1..}] run scoreboard players set @s totalWarrior 16
execute as @a[scores={Job=1,WarriorLevel=5,WarriorKills=1..}] run scoreboard players set @s totalWarrior 18
execute as @a[scores={Job=1,WarriorLevel=6,WarriorKills=1..}] run scoreboard players set @s totalWarrior 20
execute as @a[scores={Job=1,WarriorLevel=7,WarriorKills=1..}] run scoreboard players set @s totalWarrior 22
execute as @a[scores={Job=1,WarriorLevel=8,WarriorKills=1..}] run scoreboard players set @s totalWarrior 24
execute as @a[scores={Job=1,WarriorLevel=9,WarriorKills=1..}] run scoreboard players set @s totalWarrior 26
execute as @a[scores={Job=1,WarriorLevel=10,WarriorKills=1..}] run scoreboard players set @s totalWarrior 30
# Apply multiplier to warrior payment
execute as @a[scores={Job=1,WarriorKills=1..}] run scoreboard players operation @s totalWarrior /= #10 dummy
execute as @a[scores={Job=1,WarriorKills=1..}] run scoreboard players operation @s totalWarrior *= @s WarriorKills
execute as @a[scores={Job=1,WarriorKills=1..}] run scoreboard players operation @s totalWarrior *= #global warriorMult
execute as @a[scores={Job=1,WarriorKills=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,WarriorKills=1..}] run scoreboard players operation @s totalWarrior /= @s multiplier
# Apply event multiplier if Combat Games is active
execute as @a[scores={Job=1,WarriorKills=1..}] if score #global eventActive matches 1 if score #global eventJob matches 10 run scoreboard players operation @s totalWarrior *= #global eventMoneyMult
execute as @a[scores={Job=1,WarriorKills=1..}] if score #global eventActive matches 1 if score #global eventJob matches 10 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,WarriorKills=1..}] if score #global eventActive matches 1 if score #global eventJob matches 10 run scoreboard players operation @s totalWarrior /= @s multiplier
execute as @a[scores={Job=1,WarriorKills=1..}] run scoreboard players operation @s dummy += @s totalWarrior

# HUNTER PAYMENT (with multiplier)
execute as @a[scores={Job=1,HunterLevel=1,Hunt=1..}] run scoreboard players set @s totalHunter 10
execute as @a[scores={Job=1,HunterLevel=2,Hunt=1..}] run scoreboard players set @s totalHunter 12
execute as @a[scores={Job=1,HunterLevel=3,Hunt=1..}] run scoreboard players set @s totalHunter 14
execute as @a[scores={Job=1,HunterLevel=4,Hunt=1..}] run scoreboard players set @s totalHunter 16
execute as @a[scores={Job=1,HunterLevel=5,Hunt=1..}] run scoreboard players set @s totalHunter 18
execute as @a[scores={Job=1,HunterLevel=6,Hunt=1..}] run scoreboard players set @s totalHunter 20
execute as @a[scores={Job=1,HunterLevel=7,Hunt=1..}] run scoreboard players set @s totalHunter 22
execute as @a[scores={Job=1,HunterLevel=8,Hunt=1..}] run scoreboard players set @s totalHunter 24
execute as @a[scores={Job=1,HunterLevel=9,Hunt=1..}] run scoreboard players set @s totalHunter 26
execute as @a[scores={Job=1,HunterLevel=10,Hunt=1..}] run scoreboard players set @s totalHunter 30
# Apply multiplier to hunter payment
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s totalHunter /= #10 dummy
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s totalHunter *= @s Hunt
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s totalHunter *= #global hunterMult
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s totalHunter /= @s multiplier
# Apply event multiplier if Great Hunt is active
execute as @a[scores={Job=1,Hunt=1..}] if score #global eventActive matches 1 if score #global eventJob matches 4 run scoreboard players operation @s totalHunter *= #global eventMoneyMult
execute as @a[scores={Job=1,Hunt=1..}] if score #global eventActive matches 1 if score #global eventJob matches 4 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,Hunt=1..}] if score #global eventActive matches 1 if score #global eventJob matches 4 run scoreboard players operation @s totalHunter /= @s multiplier
execute as @a[scores={Job=1,Hunt=1..}] run scoreboard players operation @s dummy += @s totalHunter

# COOKING PAYMENT (with multiplier and division by 4)
execute as @a[scores={Job=1,cookinglevel=1,cooking=1..}] run scoreboard players set @s totalCook 10
execute as @a[scores={Job=1,cookinglevel=2,cooking=1..}] run scoreboard players set @s totalCook 12
execute as @a[scores={Job=1,cookinglevel=3,cooking=1..}] run scoreboard players set @s totalCook 14
execute as @a[scores={Job=1,cookinglevel=4,cooking=1..}] run scoreboard players set @s totalCook 16
execute as @a[scores={Job=1,cookinglevel=5,cooking=1..}] run scoreboard players set @s totalCook 18
execute as @a[scores={Job=1,cookinglevel=6,cooking=1..}] run scoreboard players set @s totalCook 20
execute as @a[scores={Job=1,cookinglevel=7,cooking=1..}] run scoreboard players set @s totalCook 22
execute as @a[scores={Job=1,cookinglevel=8,cooking=1..}] run scoreboard players set @s totalCook 24
execute as @a[scores={Job=1,cookinglevel=9,cooking=1..}] run scoreboard players set @s totalCook 26
execute as @a[scores={Job=1,cookinglevel=10,cooking=1..}] run scoreboard players set @s totalCook 30
# Apply multiplier to cooking payment
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s totalCook /= #10 dummy
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s totalCook *= @s cooking
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s totalCook *= #global cookMult
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s totalCook /= @s multiplier
# Apply event multiplier if Culinary Contest is active
execute as @a[scores={Job=1,cooking=1..}] if score #global eventActive matches 1 if score #global eventJob matches 8 run scoreboard players operation @s totalCook *= #global eventMoneyMult
execute as @a[scores={Job=1,cooking=1..}] if score #global eventActive matches 1 if score #global eventJob matches 8 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,cooking=1..}] if score #global eventActive matches 1 if score #global eventJob matches 8 run scoreboard players operation @s totalCook /= @s multiplier
execute as @a[scores={Job=1,cooking=1..}] run scoreboard players operation @s dummy += @s totalCook

# FISHING PAYMENT (with multiplier)
execute as @a[scores={Job=1,FishingLevel=1,FishCaught=1..}] run scoreboard players set @s totalFisher 10
execute as @a[scores={Job=1,FishingLevel=2,FishCaught=1..}] run scoreboard players set @s totalFisher 12
execute as @a[scores={Job=1,FishingLevel=3,FishCaught=1..}] run scoreboard players set @s totalFisher 14
execute as @a[scores={Job=1,FishingLevel=4,FishCaught=1..}] run scoreboard players set @s totalFisher 16
execute as @a[scores={Job=1,FishingLevel=5,FishCaught=1..}] run scoreboard players set @s totalFisher 18
execute as @a[scores={Job=1,FishingLevel=6,FishCaught=1..}] run scoreboard players set @s totalFisher 20
execute as @a[scores={Job=1,FishingLevel=7,FishCaught=1..}] run scoreboard players set @s totalFisher 22
execute as @a[scores={Job=1,FishingLevel=8,FishCaught=1..}] run scoreboard players set @s totalFisher 24
execute as @a[scores={Job=1,FishingLevel=9,FishCaught=1..}] run scoreboard players set @s totalFisher 26
execute as @a[scores={Job=1,FishingLevel=10,FishCaught=1..}] run scoreboard players set @s totalFisher 30
# Apply multiplier to fishing payment
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s totalFisher /= #10 dummy
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s totalFisher *= @s FishCaught
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s totalFisher *= #global fisherMult
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s totalFisher /= @s multiplier
# Apply event multiplier if Fishing Derby is active
execute as @a[scores={Job=1,FishCaught=1..}] if score #global eventActive matches 1 if score #global eventJob matches 5 run scoreboard players operation @s totalFisher *= #global eventMoneyMult
execute as @a[scores={Job=1,FishCaught=1..}] if score #global eventActive matches 1 if score #global eventJob matches 5 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,FishCaught=1..}] if score #global eventActive matches 1 if score #global eventJob matches 5 run scoreboard players operation @s totalFisher /= @s multiplier
execute as @a[scores={Job=1,FishCaught=1..}] run scoreboard players operation @s dummy += @s totalFisher

# ENCHANTER PAYMENT (with multiplier)
execute as @a[scores={Job=1,EnchanterLevel=1,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 10
execute as @a[scores={Job=1,EnchanterLevel=2,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 12
execute as @a[scores={Job=1,EnchanterLevel=3,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 14
execute as @a[scores={Job=1,EnchanterLevel=4,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 16
execute as @a[scores={Job=1,EnchanterLevel=5,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 18
execute as @a[scores={Job=1,EnchanterLevel=6,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 20
execute as @a[scores={Job=1,EnchanterLevel=7,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 22
execute as @a[scores={Job=1,EnchanterLevel=8,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 24
execute as @a[scores={Job=1,EnchanterLevel=9,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 26
execute as @a[scores={Job=1,EnchanterLevel=10,EnchantWork=1..}] run scoreboard players set @s totalEnchanter 30
# Apply multiplier to enchanter payment
execute as @a[scores={Job=1,EnchantWork=1..}] run scoreboard players operation @s totalEnchanter /= #10 dummy
execute as @a[scores={Job=1,EnchantWork=1..}] run scoreboard players operation @s totalEnchanter *= @s EnchantWork
execute as @a[scores={Job=1,EnchantWork=1..}] run scoreboard players operation @s totalEnchanter *= #global enchanterMult
execute as @a[scores={Job=1,EnchantWork=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,EnchantWork=1..}] run scoreboard players operation @s totalEnchanter /= @s multiplier
# Apply event multiplier if Mystic Arts Fair is active
execute as @a[scores={Job=1,EnchantWork=1..}] if score #global eventActive matches 1 if score #global eventJob matches 11 run scoreboard players operation @s totalEnchanter *= #global eventMoneyMult
execute as @a[scores={Job=1,EnchantWork=1..}] if score #global eventActive matches 1 if score #global eventJob matches 11 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,EnchantWork=1..}] if score #global eventActive matches 1 if score #global eventJob matches 11 run scoreboard players operation @s totalEnchanter /= @s multiplier
execute as @a[scores={Job=1,EnchantWork=1..}] run scoreboard players operation @s dummy += @s totalEnchanter

# ALCHEMY PAYMENT (with multiplier)
execute as @a[scores={Job=1,AlchemyLevel=1,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 10
execute as @a[scores={Job=1,AlchemyLevel=2,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 12
execute as @a[scores={Job=1,AlchemyLevel=3,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 14
execute as @a[scores={Job=1,AlchemyLevel=4,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 16
execute as @a[scores={Job=1,AlchemyLevel=5,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 18
execute as @a[scores={Job=1,AlchemyLevel=6,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 20
execute as @a[scores={Job=1,AlchemyLevel=7,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 22
execute as @a[scores={Job=1,AlchemyLevel=8,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 24
execute as @a[scores={Job=1,AlchemyLevel=9,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 26
execute as @a[scores={Job=1,AlchemyLevel=10,AlchemyWork=1..}] run scoreboard players set @s totalAlchemy 30
# Apply multiplier to alchemy payment
execute as @a[scores={Job=1,AlchemyWork=1..}] run scoreboard players operation @s totalAlchemy /= #10 dummy
execute as @a[scores={Job=1,AlchemyWork=1..}] run scoreboard players operation @s totalAlchemy *= @s AlchemyWork
execute as @a[scores={Job=1,AlchemyWork=1..}] run scoreboard players operation @s totalAlchemy *= #global alchemyMult
execute as @a[scores={Job=1,AlchemyWork=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,AlchemyWork=1..}] run scoreboard players operation @s totalAlchemy /= @s multiplier
# Apply event multiplier if Potion Masters Guild is active
execute as @a[scores={Job=1,AlchemyWork=1..}] if score #global eventActive matches 1 if score #global eventJob matches 12 run scoreboard players operation @s totalAlchemy *= #global eventMoneyMult
execute as @a[scores={Job=1,AlchemyWork=1..}] if score #global eventActive matches 1 if score #global eventJob matches 12 run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,AlchemyWork=1..}] if score #global eventActive matches 1 if score #global eventJob matches 12 run scoreboard players operation @s totalAlchemy /= @s multiplier
execute as @a[scores={Job=1,AlchemyWork=1..}] run scoreboard players operation @s dummy += @s totalAlchemy

# After calculating total payment (in dummy objective), add tax calculation:
# Calculate dynamic tax on payment
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s banktemp = @s dummy
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s multiplier = #taxRate taxRate
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s banktemp *= @s multiplier
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players set @s multiplier 100
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s banktemp /= @s multiplier

# Multiply tax by 5 before adding to city bank
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players set @s multiplier 5
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s temp = @s banktemp
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s temp *= @s multiplier

# Add multiplied tax to city bank
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation #cityBank cityBank += @s temp

# Subtract original tax from player payment (not the multiplied amount)
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s dummy -= @s banktemp

# Apply final payment to player (after tax deduction)
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s lastPaycheck = @s dummy
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s money += @s dummy

# Calculate gross pay for display (net + tax)
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s multiplier = @s dummy
execute as @a[scores={Job=1,dummy=1..}] run scoreboard players operation @s multiplier += @s banktemp

# Set $0 paycheck for workers with no work
execute as @a[scores={Job=1,dummy=0}] run scoreboard players set @s lastPaycheck 0

# Pay treasurers their flat daily rate
execute as @a[scores={TreasurerJob=1..,treasurerlevel=1}] run scoreboard players add @s money 100
execute as @a[scores={TreasurerJob=1..,treasurerlevel=2}] run scoreboard players add @s money 200
execute as @a[scores={TreasurerJob=1..,treasurerlevel=3}] run scoreboard players add @s money 300
execute as @a[scores={TreasurerJob=1..,treasurerlevel=4}] run scoreboard players add @s money 400
execute as @a[scores={TreasurerJob=1..,treasurerlevel=5}] run scoreboard players add @s money 500
execute as @a[scores={TreasurerJob=1..,treasurerlevel=6}] run scoreboard players add @s money 600
execute as @a[scores={TreasurerJob=1..,treasurerlevel=7}] run scoreboard players add @s money 700
execute as @a[scores={TreasurerJob=1..,treasurerlevel=8}] run scoreboard players add @s money 800
execute as @a[scores={TreasurerJob=1..,treasurerlevel=9}] run scoreboard players add @s money 900
execute as @a[scores={TreasurerJob=1..,treasurerlevel=10}] run scoreboard players add @s money 1000

# Give treasurers 1 cityXP per sunset
execute as @a[scores={TreasurerJob=1..}] run scoreboard players add @s cityXP 1

# Add payment breakdown to payment messages
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"=== SUNSET PAYMENT ===","color":"gold","bold":true}]
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"Gross Pay: $","color":"yellow"},{"score":{"name":"@s","objective":"multiplier"},"color":"green"}]
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"Tax Paid: $","color":"red"},{"score":{"name":"@s","objective":"banktemp"},"color":"white"},{"text":" (","color":"gray"},{"score":{"name":"#taxRate","objective":"taxRate"},"color":"white"},{"text":"% to City Bank)","color":"gray"}]
execute as @a[scores={Job=1,dummy=1..}] run tellraw @s [{"text":"Net Pay: $","color":"yellow","bold":true},{"score":{"name":"@s","objective":"dummy"},"color":"green","bold":true}]
# Send detailed payment breakdown
execute as @a[scores={Job=1,WheatHarvested=1..}] run tellraw @s [{"text":"Farm Work: ","color":"green"},{"score":{"name":"@s","objective":"WheatHarvested"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"FarmerLevel"},"color":"green"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,ores_mined=1..}] run tellraw @s [{"text":"Mine Work: ","color":"blue"},{"score":{"name":"@s","objective":"ores_mined"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"MinerLevel"},"color":"blue"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,RanchHarvested=1..}] run tellraw @s [{"text":"Ranch Work: ","color":"gold"},{"score":{"name":"@s","objective":"RanchHarvested"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"RancherLevel"},"color":"gold"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,Hunt=1..}] run tellraw @s [{"text":"Hunt Work: ","color":"red"},{"score":{"name":"@s","objective":"Hunt"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"HunterLevel"},"color":"red"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,FishCaught=1..}] run tellraw @s [{"text":"Fish Work: ","color":"aqua"},{"score":{"name":"@s","objective":"FishCaught"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"FishingLevel"},"color":"aqua"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,BlacksmithCrafted=1..}] run tellraw @s [{"text":"Blacksmith Work: ","color":"gold"},{"score":{"name":"@s","objective":"BlacksmithCrafted"},"color":"white"},{"text":" items (Lv","color":"gray"},{"score":{"name":"@s","objective":"BlacksmithLevel"},"color":"gold"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,lumber=1..}] run tellraw @s [{"text":"lumber Work: ","color":"dark_green"},{"score":{"name":"@s","objective":"lumber"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"lumberlevel"},"color":"dark_green"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,cooking=1..}] run tellraw @s [{"text":"Cooking Work: ","color":"light_purple"},{"score":{"name":"@s","objective":"cooking"},"color":"white"},{"text":" units (Lv","color":"gray"},{"score":{"name":"@s","objective":"cookinglevel"},"color":"light_purple"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,ArcherKills=1..}] run tellraw @s [{"text":"Archer Work: ","color":"dark_purple"},{"score":{"name":"@s","objective":"ArcherKills"},"color":"white"},{"text":" kills (Lv","color":"gray"},{"score":{"name":"@s","objective":"ArcherLevel"},"color":"dark_purple"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,WarriorKills=1..}] run tellraw @s [{"text":"Warrior Work: ","color":"dark_red"},{"score":{"name":"@s","objective":"WarriorKills"},"color":"white"},{"text":" kills (Lv","color":"gray"},{"score":{"name":"@s","objective":"WarriorLevel"},"color":"dark_red"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,EnchantWork=1..}] run tellraw @s [{"text":"Enchanter Work: ","color":"dark_purple"},{"score":{"name":"@s","objective":"EnchantWork"},"color":"white"},{"text":" items (Lv","color":"gray"},{"score":{"name":"@s","objective":"EnchanterLevel"},"color":"dark_purple"},{"text":")","color":"gray"}]
execute as @a[scores={Job=1,AlchemyWork=1..}] run tellraw @s [{"text":"Alchemy Work: ","color":"light_purple"},{"score":{"name":"@s","objective":"AlchemyWork"},"color":"white"},{"text":" potions (Lv","color":"gray"},{"score":{"name":"@s","objective":"AlchemyLevel"},"color":"light_purple"},{"text":")","color":"gray"}]

execute as @a[scores={Job=1,dummy=0}] run tellraw @s {"text":"No work completed today, no pay!","color":"red"}

# Debug message showing XP breakdown
execute as @a[scores={Job=1}] run tellraw @s [{"text":"XP - Farm: ","color":"gray"},{"score":{"name":"@s","objective":"FarmerXP"},"color":"green"},{"text":" | Mine: ","color":"gray"},{"score":{"name":"@s","objective":"MinerXP"},"color":"blue"},{"text":" | Ranch: ","color":"gray"},{"score":{"name":"@s","objective":"RancherXP"},"color":"gold"},{"text":" | Hunt: ","color":"gray"},{"score":{"name":"@s","objective":"HunterXP"},"color":"red"},{"text":" | Fish: ","color":"gray"},{"score":{"name":"@s","objective":"FishingXP"},"color":"aqua"},{"text":" | Smith: ","color":"gray"},{"score":{"name":"@s","objective":"BlacksmithXP"},"color":"gold"},{"text":" | lumber: ","color":"gray"},{"score":{"name":"@s","objective":"lumberXP"},"color":"dark_green"},{"text":" | Cook: ","color":"gray"},{"score":{"name":"@s","objective":"cookingXP"},"color":"light_purple"},{"text":" | Archer: ","color":"gray"},{"score":{"name":"@s","objective":"ArcherXP"},"color":"dark_purple"},{"text":" | Warrior: ","color":"gray"},{"score":{"name":"@s","objective":"WarriorXP"},"color":"dark_red"},{"text":" | Enchanter: ","color":"gray"},{"score":{"name":"@s","objective":"EnchanterXP"},"color":"dark_purple"},{"text":" | Alchemy: ","color":"gray"},{"score":{"name":"@s","objective":"AlchemyXP"},"color":"light_purple"}]

# Treasurer payment notification
execute as @a[scores={TreasurerJob=1..}] run tellraw @s [{"text":"=== TREASURER PAYMENT ===","color":"gold","bold":true}]
execute as @a[scores={TreasurerJob=1..}] run tellraw @s [{"text":"Daily Salary: $","color":"yellow"},{"score":{"name":"@s","objective":"treasurerlevel"},"color":"white"},{"text":"00 (Level ","color":"yellow"},{"score":{"name":"@s","objective":"treasurerlevel"},"color":"white"},{"text":")","color":"yellow"}]

# ===== PAY DIVIDENDS TO ALL SHAREHOLDERS =====
# Calculate and pay daily dividends based on portfolio value

# Only process if dividend rate is enabled (> 0)
execute if score #global dividendRate matches 1.. run function economy:jobs/general/pay_dividends

# Check promotions for all workers after paying them
execute as @a[scores={Job=1}] run function economy:jobs/general/check_promotion
execute as @a[scores={Job=1}] run function economy:jobs/general/team_promotion

# Reset work counters
scoreboard players set @a[scores={Job=1}] WheatHarvested 0
scoreboard players set @a[scores={Job=1}] ores_mined 0
scoreboard players set @a[scores={Job=1}] RanchHarvested 0
scoreboard players set @a[scores={Job=1}] Hunt 0
scoreboard players set @a[scores={Job=1}] FishCaught 0
scoreboard players set @a[scores={Job=1}] BlacksmithCrafted 0
scoreboard players set @a[scores={Job=1}] lumber 0
scoreboard players set @a[scores={Job=1}] cooking 0
scoreboard players set @a[scores={Job=1}] ArcherKills 0
scoreboard players set @a[scores={Job=1}] WarriorKills 0
scoreboard players set @a[scores={Job=1}] EnchantWork 0
scoreboard players set @a[scores={Job=1}] AlchemyWork 0


# Reset temporary scores (including all job totals)
scoreboard players set @a[scores={Job=1}] dummy 0
scoreboard players set @a[scores={Job=1}] targetJob 0
scoreboard players set @a[scores={Job=1}] totalFarmer 0
scoreboard players set @a[scores={Job=1}] totalMiner 0
scoreboard players set @a[scores={Job=1}] totalRancher 0
scoreboard players set @a[scores={Job=1}] totalBlacksmith 0
scoreboard players set @a[scores={Job=1}] totallumber 0
scoreboard players set @a[scores={Job=1}] totalHunter 0
scoreboard players set @a[scores={Job=1}] totalCook 0
scoreboard players set @a[scores={Job=1}] totalFisher 0
scoreboard players set @a[scores={Job=1}] totalArcher 0
scoreboard players set @a[scores={Job=1}] totalWarrior 0
scoreboard players set @a[scores={Job=1}] totalEnchanter 0
scoreboard players set @a[scores={Job=1}] totalAlchemy 0

# Calculate PayDiff (money gained) after payment
execute as @a[scores={Job=1}] run scoreboard players operation @s PayDiff = @s money
execute as @a[scores={Job=1}] run scoreboard players operation @s PayDiff -= @s moneyBefore

# Set flag to prevent multiple pays
scoreboard players set workerPayFlag workerPayFlag 1
scoreboard players set #startup startupFlag 0