# Debug Function for Realtor Sale to Other Players
# Run this as the realtor to diagnose issues
# Usage: /function economy:jobs/realtor/debug_sale

tellraw @s {"text":"=== REALTOR DEBUG INFO ===","color":"aqua","bold":true}

# Check realtor job
execute if score @s realtorJob matches 1 run tellraw @s {"text":"✓ You are a realtor (realtorJob=1)","color":"green"}
execute unless score @s realtorJob matches 1 run tellraw @s {"text":"✗ You are NOT a realtor!","color":"red"}

# Check testMode
execute if score @s testMode matches 1 run tellraw @s {"text":"⚠ Test mode is ENABLED - will sell to yourself","color":"yellow"}
execute unless score @s testMode matches 1 run tellraw @s {"text":"✓ Test mode is disabled","color":"green"}

# Check for nearby players
execute at @s if entity @p[distance=0.1..10,gamemode=!spectator] run tellraw @s [{"text":"✓ Found player nearby: ","color":"green"},{"selector":"@p[distance=0.1..10,gamemode=!spectator]"}]
execute at @s unless entity @p[distance=0.1..10,gamemode=!spectator] run tellraw @s {"text":"✗ No player found within 10 blocks!","color":"red"}

# Check for pending sales
execute if entity @a[scores={pendingSale=1}] run tellraw @s [{"text":"⚠ There is already a pending sale: ","color":"yellow"},{"selector":"@a[scores={pendingSale=1}]"}]
execute unless entity @a[scores={pendingSale=1}] run tellraw @s {"text":"✓ No pending sales","color":"green"}

# Check chunk price set
execute if score @s chunkPrice matches 1.. run tellraw @s [{"text":"✓ Custom price set: $","color":"green"},{"score":{"name":"@s","objective":"chunkPrice"},"color":"white"}]
execute unless score @s chunkPrice matches 1.. run tellraw @s {"text":"ℹ No custom price set - will auto-calculate","color":"gray"}

# Check triggers enabled
tellraw @s {"text":"","color":"white"}
tellraw @s {"text":"Trigger Status:","color":"aqua","bold":true}
execute store result score #sellChunkEnabled dummy run scoreboard players get @s sellChunk
execute if score #sellChunkEnabled dummy matches -2147483648..2147483647 run tellraw @s {"text":"✓ sellChunk trigger is enabled","color":"green"}

tellraw @s {"text":"","color":"white"}
tellraw @s {"text":"Next Steps:","color":"gold","bold":true}
tellraw @s {"text":"1. Stand within 10 blocks of another player","color":"yellow"}
tellraw @s {"text":"2. Use /trigger sellChunk set 1","color":"yellow"}
tellraw @s {"text":"3. The other player uses /trigger confirmSale set 1","color":"yellow"}