# ===== FILE: process_chunk_sale.mcfunction =====
# Process Chunk Sale
# This runs as the buyer who is confirming the purchase

# Store values for calculations
scoreboard players operation @s agentCommission = @s chunkPrice
scoreboard players operation @s agentCommission /= #20 dummy

# Ensure minimum commission of $50
execute if score @s agentCommission matches ..49 run scoreboard players set @s agentCommission 50

# Deduct money from buyer
scoreboard players operation @s money -= @s chunkPrice

# Add commission to the realtor (only if not the same player)
execute unless entity @s[scores={realtorJob=1}] as @a[scores={realtorJob=1}] run scoreboard players operation @s money += @p[scores={pendingSale=1}] agentCommission

# Add XP to realtor
execute as @a[scores={realtorJob=1}] run scoreboard players add @s RealtorXP 50

# Claim the chunk using Open Parties and Claims
# Calculate chunk center coordinates (multiply by 16 and add 8)
execute store result score #centerX dummy run scoreboard players get @s saleAgentX
execute store result score #centerZ dummy run scoreboard players get @s saleAgentZ
scoreboard players operation #centerX dummy *= #16 dummy
scoreboard players operation #centerZ dummy *= #16 dummy
scoreboard players add #centerX dummy 8
scoreboard players add #centerZ dummy 8

# Store coordinates in temporary storage
execute store result storage minecraft:temp centerX int 1 run scoreboard players get #centerX dummy
execute store result storage minecraft:temp centerZ int 1 run scoreboard players get #centerZ dummy

# Execute the claim command at chunk center
function economy:jobs/realtor/claim_chunk_at_location with storage minecraft:temp

# Increment buyer's chunk count
scoreboard players add @s chunksOwned 1

# Success messages
tellraw @s {"text":"=== PURCHASE SUCCESSFUL ===","color":"green","bold":true}
tellraw @s [{"text":"Chunk (","color":"green"},{"score":{"name":"@s","objective":"saleAgentX"},"color":"white"},{"text":", ","color":"green"},{"score":{"name":"@s","objective":"saleAgentZ"},"color":"white"},{"text":") claimed for $","color":"green"},{"score":{"name":"@s","objective":"chunkPrice"},"color":"white"},{"text":"!","color":"green"}]
tellraw @s [{"text":"New balance: $","color":"yellow"},{"score":{"name":"@s","objective":"money"},"color":"yellow"}]
tellraw @s [{"text":"You now own ","color":"aqua"},{"score":{"name":"@s","objective":"chunksOwned"},"color":"white"},{"text":" chunks total.","color":"aqua"}]

# Notify realtor (only if different player)
execute unless entity @s[scores={realtorJob=1}] as @p[scores={realtorJob=1}] run tellraw @s {"text":"=== SALE COMPLETED ===","color":"green","bold":true}
execute unless entity @s[scores={realtorJob=1}] as @p[scores={realtorJob=1}] run tellraw @s [{"text":"You earned $","color":"green"},{"score":{"name":"@p[scores={pendingSale=1}]","objective":"agentCommission"},"color":"white"},{"text":" commission! (+50 XP)","color":"green"}]

# Test mode notification
execute if entity @s[scores={realtorJob=1}] run tellraw @s {"text":"Test mode: Sale completed successfully! (+50 XP)","color":"gold"}

# Clear pending sale
function economy:clear_pending_sale