# Apply moderate event change to Miner stock based on price brackets

# Store old price for comparison
scoreboard players operation #oldPrice dummy = #minerStock minerStockPrice

# Generate random number 1-10 for positive/negative determination
execute store result score #direction dummy run random value 1..10

# Price bracket: 0-99 (80% positive 5%, 20% negative 1%)
execute if score #minerStock minerStockPrice matches ..99 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/positive_3
execute if score #minerStock minerStockPrice matches ..99 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/negative_1

# Price bracket: 100-199 (60% negative 10%, 40% positive 3%)
execute if score #minerStock minerStockPrice matches 100..199 if score #direction dummy matches 1..5 run function economy:stock_market/events/changes/negative_2
execute if score #minerStock minerStockPrice matches 100..199 if score #direction dummy matches 6..10 run function economy:stock_market/events/changes/positive_2

# Price bracket: 200-299 (70% negative 20%, 30% positive 3%)
execute if score #minerStock minerStockPrice matches 200..299 if score #direction dummy matches 1..5 run function economy:stock_market/events/changes/negative_2
execute if score #minerStock minerStockPrice matches 200..299 if score #direction dummy matches 6..10 run function economy:stock_market/events/changes/positive_2

# Price bracket: 300-399 (80% negative 30%, 20% positive 3%)
execute if score #minerStock minerStockPrice matches 300..399 if score #direction dummy matches 1..5 run function economy:stock_market/events/changes/negative_2
execute if score #minerStock minerStockPrice matches 300..399 if score #direction dummy matches 6..10 run function economy:stock_market/events/changes/positive_2

# Price bracket: 400-499 (90% negative 40%, 10% positive 3%)
execute if score #minerStock minerStockPrice matches 400..499 if score #direction dummy matches 1..6 run function economy:stock_market/events/changes/negative_3
execute if score #minerStock minerStockPrice matches 400..499 if score #direction dummy matches 7..10 run function economy:stock_market/events/changes/positive_2

execute if score #minerStock minerStockPrice matches 500.. if score #direction dummy matches 1..6 run function economy:stock_market/events/changes/negative_3
execute if score #minerStock minerStockPrice matches 500.. if score #direction dummy matches 7..10 run function economy:stock_market/events/changes/positive_2

# Apply the calculated change to the actual price
scoreboard players operation #minerStock minerStockPrice += #priceChange dummy

# Enforce min/max limits
execute if score #minerStock minerStockPrice < #global stockMinPrice run scoreboard players operation #minerStock minerStockPrice = #global stockMinPrice
execute if score #minerStock minerStockPrice > #global stockMaxPrice run scoreboard players operation #minerStock minerStockPrice = #global stockMaxPrice

# Announce the change
execute if score #minerStock minerStockPrice > #oldPrice dummy run tellraw @a [{"text":"  Miner: $","color":"blue"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#minerStock","objective":"minerStockPrice"},"color":"green"},{"text":" ▲","color":"green","bold":true}]
execute if score #minerStock minerStockPrice < #oldPrice dummy run tellraw @a [{"text":"  Miner: $","color":"blue"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#minerStock","objective":"minerStockPrice"},"color":"red"},{"text":" ▼","color":"red","bold":true}]