# Check if amount is valid (must be at least $1)
execute if score @s pay matches ..0 run tellraw @s {"text":"You must specify an amount to pay!","color":"red"}
execute if score @s pay matches ..0 run scoreboard players set @s pay 0
execute if score @s pay matches ..0 run return 0

# Check if player has enough money
execute if score @s money < @s pay run tellraw @s {"text":"Insufficient funds!","color":"red"}
execute if score @s money < @s pay run scoreboard players set @s pay 0
execute if score @s money < @s pay run return 0

# Check if there's a player nearby to pay
execute at @s unless entity @p[distance=0.1..10,gamemode=!spectator] run tellraw @s {"text":"No player nearby to pay! Get within 10 blocks.","color":"red"}
execute at @s unless entity @p[distance=0.1..10,gamemode=!spectator] run scoreboard players set @s pay 0
execute at @s unless entity @p[distance=0.1..10,gamemode=!spectator] run return 0

# Store payment amount in temporary variable (only if they can afford it)
scoreboard players operation #pay payTemp = @s pay

# Deduct money from payer
scoreboard players operation @s money -= @s pay

# Give money to nearest player
execute at @s as @p[distance=0.1..10,gamemode=!spectator] run scoreboard players operation @s money += #pay payTemp

# Notify payer
tellraw @s [{"text":"You paid ","color":"green"},{"text":" $","color":"green"},{"score":{"name":"#pay","objective":"payTemp"},"color":"white"}]

# Notify recipient (only if payTemp has a value)
# Since we're already running AS the payer, just use their position
execute if score #pay payTemp matches 1.. as @p[distance=0.1..10,gamemode=!spectator] at @s run tellraw @s [{"text":"You have been paid $","color":"green"},{"score":{"name":"#pay","objective":"payTemp"},"color":"green"}]

# Reset temporary variable
scoreboard players set #pay payTemp 0

# Reset trigger
scoreboard players set @s pay 0