say KHEconomy
function economy:preprocessing/startup_tasks
# Setup economy objectives
scoreboard objectives add money dummy {"text":"Money"}
scoreboard objectives add pay trigger {"text":"Pay"}
scoreboard objectives add lastPaycheck dummy {"text":"Last Paycheck"}
scoreboard objectives add moneyBefore dummy {"text":"Money Before Pay"}
scoreboard objectives add PayDiff dummy {"text":"Pay Difference"}
scoreboard objectives add levelCheck trigger "Check Skill Levels"

scoreboard objectives add pumpkins_placed dummy "Pumpkins Placed"
scoreboard objectives add ancientDebris_placed dummy "Ancient Debris Placed"
scoreboard objectives add kheco_timer dummy "KH Economy Timer"

# Create static number objectives
scoreboard players set #1 dummy 1
scoreboard players set #2 dummy 2
scoreboard players set #3 dummy 3
scoreboard players set #4 dummy 4
scoreboard players set #5 dummy 5
scoreboard players set #6 dummy 6
scoreboard players set #7 dummy 7
scoreboard players set #8 dummy 8
scoreboard players set #9 dummy 9
scoreboard players set #10 dummy 10
scoreboard players set #12 dummy 12
scoreboard players set #16 dummy 16
scoreboard players set #32 dummy 32
scoreboard players set #48 dummy 48
scoreboard players set #64 dummy 64

# Create startup flag objective
scoreboard objectives add startupFlag dummy "Startup Flag"

# Initialize startup flag to 0 (will count up to 100)
scoreboard players set #startup startupFlag 0

# Banking system objectives
scoreboard objectives add banktemp dummy "Banking Temp"
# City bank objective (not player-specific)
scoreboard objectives add cityBank dummy "City Bank Fund"

# Simple withdrawal triggers
scoreboard objectives add withdrawEmeralds trigger "Withdraw Emeralds"
scoreboard objectives add withdrawDiamonds trigger "Withdraw Diamonds"
# Deposit trigger objectives
scoreboard objectives add depositEmeralds trigger "Deposit Emeralds"
scoreboard objectives add depositDiamonds trigger "Deposit Diamonds"

# Setup job objectives
scoreboard objectives add Job dummy {"text":"Job"}
scoreboard objectives add WorkerLevel dummy {"text":"Worker Level"}
scoreboard objectives add FarmerLevel dummy {"text":"Farmer Level"}
scoreboard objectives add MinerLevel dummy {"text":"Miner Level"}
scoreboard objectives add RancherLevel dummy {"text":"Rancher Level"}
scoreboard objectives add FarmerXP dummy {"text":"Farmer XP"}
scoreboard objectives add MinerXP dummy {"text":"Miner XP"}
scoreboard objectives add RancherXP dummy {"text":"Rancher XP"}
scoreboard objectives add chooseWorker trigger {"text":"Choose Worker Job"}
scoreboard objectives add quitJob trigger {"text":"Quit Job"}

scoreboard objectives add totalFarmer dummy "Total Farmer Pay"
scoreboard objectives add totalMiner dummy "Total Miner Pay"
scoreboard objectives add totalRancher dummy "Total Rancher Pay"
scoreboard objectives add totalBlacksmith dummy "Total Blacksmith Pay"
scoreboard objectives add totallumber dummy "Total lumber Pay"
scoreboard objectives add totalHunter dummy "Total Hunter Pay"
scoreboard objectives add totalCook dummy "Total Cook Pay"
scoreboard objectives add totalFisher dummy "Total Fisher Pay"
scoreboard objectives add totalArcher dummy
scoreboard objectives add totalWarrior dummy

# Work tracking objectives
scoreboard objectives add WheatHarvested dummy {"text":"Crops Harvested"}
scoreboard objectives add ores_mined dummy {"text":"Ores Mined"}
scoreboard objectives add RanchHarvested dummy {"text":"Ranch Products Harvested"}
scoreboard objectives add carrotCount dummy {"text":"Carrot Counter"}
scoreboard objectives add beetrootCount dummy {"text":"Beetroot Counter"}
scoreboard objectives add melonSliceCount dummy {"text":"Melon Slice Counter"}
scoreboard objectives add eggCount dummy {"text":"Egg Counter"}
scoreboard objectives add woolCount dummy {"text":"Wool Counter"}

# Realtor objectives
scoreboard objectives add RealtorLevel dummy {"text":"Realtor Level"}
scoreboard objectives add RealtorXP dummy {"text":"Realtor XP"}
scoreboard objectives add pendingSale dummy {"text":"Pending Sale"}
scoreboard objectives add saleTimer dummy {"text":"Sale Timer"}
scoreboard objectives add chunkPrice dummy {"text":"Chunk Price"}
scoreboard objectives add buyerMoney dummy {"text":"Buyer Money"}
scoreboard objectives add agentCommission dummy {"text":"Agent Commission"}
scoreboard objectives add chunksOwned dummy {"text":"Chunks Owned"}
scoreboard objectives add saleAgentX dummy {"text":"Sale Agent Chunk X"}
scoreboard objectives add saleAgentZ dummy {"text":"Sale Agent Chunk Z"}
scoreboard objectives add chunkX dummy {"text":"Chunk X"}
scoreboard objectives add chunkZ dummy {"text":"Chunk Z"}
scoreboard objectives add chooseRealtor trigger {"text":"Choose Realtor Job"}

# Treasurer job objectives
scoreboard objectives add TreasurerJob dummy "Treasurer Job"
scoreboard objectives add cityXP dummy "City XP"
scoreboard objectives add treasurerlevel dummy "Treasurer Level"
scoreboard objectives add taxRate dummy "Tax Rate Percentage"

# Treasurer commands (admin only)
scoreboard objectives add setTreasurer trigger "Set Treasurer"
scoreboard objectives add removeTreasurer trigger "Remove Treasurer"
scoreboard objectives add setTaxRate trigger "Set Tax Rate"
scoreboard objectives add spendCity trigger "Spend City Money"
scoreboard objectives add depositCity trigger "Deposit to City Bank"

# Initialize default tax rate to 5%
execute unless score #taxRate taxRate matches 0.. run scoreboard players set #taxRate taxRate 5

# Set default treasurer level
scoreboard players set @a[scores={treasurerlevel=0,TreasurerJob=1..}] treasurerlevel 1


# Cooking objectives
scoreboard objectives add cookingXP dummy "Cooking XP"
scoreboard objectives add cookinglevel dummy "Cooking Level"
scoreboard objectives add cooking dummy "Cooking Work Done"
scoreboard objectives add cookingtemp dummy "Cooking Temp"

# Level 1 foods (1 XP each)
scoreboard objectives add bread_crafted minecraft.crafted:minecraft.bread
scoreboard objectives add dried_kelp_crafted minecraft.crafted:minecraft.dried_kelp
scoreboard objectives add cooked_beef_crafted minecraft.crafted:minecraft.cooked_beef
scoreboard objectives add cooked_pork_crafted minecraft.crafted:minecraft.cooked_porkchop
scoreboard objectives add cooked_chicken_crafted minecraft.crafted:minecraft.cooked_chicken
scoreboard objectives add cooked_mutton_crafted minecraft.crafted:minecraft.cooked_mutton
scoreboard objectives add cooked_salmon_crafted minecraft.crafted:minecraft.cooked_salmon
scoreboard objectives add cooked_cod_crafted minecraft.crafted:minecraft.cooked_cod
scoreboard objectives add baked_potato_crafted minecraft.crafted:minecraft.baked_potato
scoreboard objectives add pumpkin_pie_crafted minecraft.crafted:minecraft.pumpkin_pie
scoreboard objectives add fermented_spider_eye_crafted minecraft.crafted:minecraft.fermented_spider_eye

# Level 2 foods (2 XP each)
scoreboard objectives add cookie_crafted minecraft.crafted:minecraft.cookie
scoreboard objectives add beetroot_soup_crafted minecraft.crafted:minecraft.beetroot_soup
scoreboard objectives add mushroom_stew_crafted minecraft.crafted:minecraft.mushroom_stew
scoreboard objectives add suspicious_stew_crafted minecraft.crafted:minecraft.suspicious_stew

# Level 3 foods (3 XP each)
scoreboard objectives add golden_carrot_crafted minecraft.crafted:minecraft.golden_carrot
scoreboard objectives add honey_bottle_crafted minecraft.crafted:minecraft.honey_bottle
scoreboard objectives add cake_crafted minecraft.crafted:minecraft.cake
scoreboard objectives add rabbit_stew_crafted minecraft.crafted:minecraft.rabbit_stew
scoreboard objectives add glistering_melon_crafted minecraft.crafted:minecraft.glistering_melon_slice

# Level 4 foods (4 XP each)
scoreboard objectives add golden_apple_crafted minecraft.crafted:minecraft.golden_apple

# Set default cooking level
scoreboard players set @a[scores={cookinglevel=0}] cookinglevel 1

# lumber job objectives
scoreboard objectives add log_counter dummy "Logs Available"
scoreboard objectives add lumberXP dummy "lumber XP"
scoreboard objectives add lumberlevel dummy "lumber Level"
scoreboard objectives add lumber dummy "lumber Work Done"

# Plank crafting detection objectives
scoreboard objectives add oak_planks_crafted minecraft.crafted:minecraft.oak_planks
scoreboard objectives add birch_planks_crafted minecraft.crafted:minecraft.birch_planks
scoreboard objectives add spruce_planks_crafted minecraft.crafted:minecraft.spruce_planks
scoreboard objectives add jungle_planks_crafted minecraft.crafted:minecraft.jungle_planks
scoreboard objectives add acacia_planks_crafted minecraft.crafted:minecraft.acacia_planks
scoreboard objectives add dark_oak_planks_crafted minecraft.crafted:minecraft.dark_oak_planks
scoreboard objectives add mangrove_planks_crafted minecraft.crafted:minecraft.mangrove_planks
scoreboard objectives add cherry_planks_crafted minecraft.crafted:minecraft.cherry_planks
scoreboard objectives add lumbertemp dummy
scoreboard objectives add multiplier dummy "Multiplier"
scoreboard objectives add setarcherMult trigger "Set Archer Multiplier"
scoreboard objectives add setwarriorMult trigger "Set Warrior Multiplier"
scoreboard objectives add archerMult dummy "Archer Multiplier"
scoreboard objectives add warriorMult dummy "Warrior Multiplier"

# Set default multipliers to 100% (100)
scoreboard players set #global archerMult 100
scoreboard players set #global warriorMult 100

# Set default lumber level to 1 for new players
scoreboard players set @a[scores={lumberlevel=0}] lumberlevel 1

# Dropped Items
scoreboard objectives add itemDropped minecraft.custom:minecraft.drop "Items Dropped"

# ADD THESE CORRECTED LINES TO YOUR LOAD.MCFUNCTION
# Replace the existing multiplier trigger objectives with these:

# Treasurer trigger objectives for setting multipliers (corrected names)
scoreboard objectives add setFarmerMult trigger "Set Farmer Multiplier"
scoreboard objectives add setMinerMult trigger "Set Miner Multiplier"
scoreboard objectives add setlumberMult trigger "Set lumber Multiplier"  
scoreboard objectives add setBlacksmithMult trigger "Set Blacksmith Multiplier"
scoreboard objectives add setFisherMult trigger "Set Fisher Multiplier"
scoreboard objectives add setHunterMult trigger "Set Hunter Multiplier"
scoreboard objectives add setCookMult trigger "Set Cook Multiplier"
scoreboard objectives add setRancherMult trigger "Set Rancher Multiplier"

# Keep the same multiplier storage objectives (these are fine):
scoreboard objectives add farmerMult dummy "Farmer Multiplier"
scoreboard objectives add minerMult dummy "Miner Multiplier" 
scoreboard objectives add lumberjackMult dummy "lumberjack Multiplier" 
scoreboard objectives add blacksmithMult dummy "Builder Multiplier"      
scoreboard objectives add fisherMult dummy "Fisher Multiplier"
scoreboard objectives add hunterMult dummy "Ranger Multiplier"         
scoreboard objectives add cookMult dummy "Cook Multiplier"

# Set default multipliers to 100% (100)
scoreboard players set #global farmerMult 100
scoreboard players set #global minerMult 100
scoreboard players set #global lumberjackMult 100
scoreboard players set #global blacksmithMult 100
scoreboard players set #global fisherMult 100
scoreboard players set #global hunterMult 100
scoreboard players set #global cookMult 100

# Fishing objectives
scoreboard objectives add fishingRodUsed minecraft.used:minecraft.fishing_rod "Fishing Rod Used"
scoreboard objectives add codCaught minecraft.picked_up:minecraft.cod "Cod Caught"
scoreboard objectives add rodCount dummy "Rod Count"
scoreboard objectives add rodTimer dummy "Rod Timer"
scoreboard objectives add lastRodUse dummy "Last Rod Use"
scoreboard objectives add salmonCaught minecraft.picked_up:minecraft.salmon "Salmon Caught"
scoreboard objectives add tropicalFishCaught minecraft.picked_up:minecraft.tropical_fish "Tropical Fish Caught"
scoreboard objectives add pufferfishCaught minecraft.picked_up:minecraft.pufferfish "Pufferfish Caught"
scoreboard objectives add FishingXP dummy "Fishing XP"
scoreboard objectives add FishingLevel dummy "Fishing Level"
scoreboard objectives add FishCaught dummy "Fish Caught"

# Animal tracking
scoreboard objectives add cowsKilled minecraft.killed:minecraft.cow {"text":"Cows Killed"}
scoreboard objectives add sheepKilled minecraft.killed:minecraft.sheep {"text":"Sheep Killed"}
scoreboard objectives add pigsKilled minecraft.killed:minecraft.pig {"text":"Pigs Killed"}
scoreboard objectives add chickensKilled minecraft.killed:minecraft.chicken {"text":"Chickens Killed"}
scoreboard objectives add animalsBred minecraft.custom:minecraft.animals_bred {"text":"Animals Bred"}
scoreboard objectives add animalKillCount dummy {"text":"Animal Kill Count"}
scoreboard objectives add lastAnimalKill dummy {"text":"Last Animal Kill Time"}
scoreboard objectives add ranchCooldown dummy {"text":"Ranch Cooldown"}
scoreboard objectives add rabbitsKilled minecraft.killed:minecraft.rabbit {"text":"Rabbits Killed"}
scoreboard objectives add goatsKilled minecraft.killed:minecraft.goat {"text":"Goats Killed"}

# Additional item pickup objectives
scoreboard objectives add pickupRawRabbit minecraft.picked_up:minecraft.rabbit {"text":"Raw Rabbit Picked Up"}
scoreboard objectives add pickupRabbitHide minecraft.picked_up:minecraft.rabbit_hide {"text":"Rabbit Hide Picked Up"}
scoreboard objectives add pickupRabbitFoot minecraft.picked_up:minecraft.rabbit_foot {"text":"Rabbit Foot Picked Up"}

# Item pickup objectives
scoreboard objectives add pickupBeef minecraft.picked_up:minecraft.beef {"text":"Beef Picked Up"}
scoreboard objectives add pickupMutton minecraft.picked_up:minecraft.mutton {"text":"Mutton Picked Up"}
scoreboard objectives add pickupPork minecraft.picked_up:minecraft.porkchop {"text":"Pork Picked Up"}
scoreboard objectives add pickupChicken minecraft.picked_up:minecraft.chicken {"text":"Chicken Picked Up"}
scoreboard objectives add pickupEgg minecraft.picked_up:minecraft.egg {"text":"Eggs Picked Up"}
scoreboard objectives add pickupBrownEgg minecraft.picked_up:minecraft.brown_egg {"text":"Brown Eggs Picked Up"}
scoreboard objectives add pickupBlueEgg minecraft.picked_up:minecraft.blue_egg {"text":"Blue Eggs Picked Up"}
scoreboard objectives add pickupGoatHorn minecraft.picked_up:minecraft.goat_horn {"text":"Goat Horn Picked Up"}
scoreboard objectives add eggProximity dummy "Egg Proximity Counter"

# Wool pickup objectives
scoreboard objectives add pickupWool1 minecraft.picked_up:minecraft.white_wool {"text":"White Wool Picked Up"}
scoreboard objectives add pickupWool2 minecraft.picked_up:minecraft.orange_wool {"text":"Orange Wool Picked Up"}
scoreboard objectives add pickupWool3 minecraft.picked_up:minecraft.magenta_wool {"text":"Magenta Wool Picked Up"}
scoreboard objectives add pickupWool4 minecraft.picked_up:minecraft.light_blue_wool {"text":"Light Blue Wool Picked Up"}
scoreboard objectives add pickupWool5 minecraft.picked_up:minecraft.yellow_wool {"text":"Yellow Wool Picked Up"}
scoreboard objectives add pickupWool6 minecraft.picked_up:minecraft.lime_wool {"text":"Lime Wool Picked Up"}
scoreboard objectives add pickupWool7 minecraft.picked_up:minecraft.pink_wool {"text":"Pink Wool Picked Up"}
scoreboard objectives add pickupWool8 minecraft.picked_up:minecraft.gray_wool {"text":"Gray Wool Picked Up"}
scoreboard objectives add pickupWool9 minecraft.picked_up:minecraft.light_gray_wool {"text":"Light Gray Wool Picked Up"}
scoreboard objectives add pickupWool10 minecraft.picked_up:minecraft.cyan_wool {"text":"Cyan Wool Picked Up"}
scoreboard objectives add pickupWool11 minecraft.picked_up:minecraft.purple_wool {"text":"Purple Wool Picked Up"}
scoreboard objectives add pickupWool12 minecraft.picked_up:minecraft.blue_wool {"text":"Blue Wool Picked Up"}
scoreboard objectives add pickupWool13 minecraft.picked_up:minecraft.brown_wool {"text":"Brown Wool Picked Up"}
scoreboard objectives add pickupWool14 minecraft.picked_up:minecraft.green_wool {"text":"Green Wool Picked Up"}
scoreboard objectives add pickupWool15 minecraft.picked_up:minecraft.red_wool {"text":"Red Wool Picked Up"}
scoreboard objectives add pickupWool16 minecraft.picked_up:minecraft.black_wool {"text":"Black Wool Picked Up"}

# Utility objectives
scoreboard objectives add dummy dummy
scoreboard objectives add targetJob dummy {"text":"Target Job Assignment"}
scoreboard objectives add workerPayFlag dummy
scoreboard objectives add sidebar dummy {"text":"§6§lKH Economy"}

# Farming objectives
scoreboard objectives add brokenWheat minecraft.mined:minecraft.wheat {"text":"Wheat Broken"}
scoreboard objectives add brokenPotatoes minecraft.mined:minecraft.potatoes {"text":"Potatoes Broken"}
scoreboard objectives add brokenCarrots minecraft.mined:minecraft.carrots {"text":"Carrots Broken"}
scoreboard objectives add brokenBeetroots minecraft.mined:minecraft.beetroots {"text":"Beetroots Broken"}
scoreboard objectives add brokenPumpkins minecraft.mined:minecraft.pumpkin {"text":"Pumpkins Broken"}
scoreboard objectives add brokenMelons minecraft.mined:minecraft.melon {"text":"Melons Broken"}
scoreboard objectives add pickupWheat minecraft.picked_up:minecraft.wheat {"text":"Wheat Picked Up"}
scoreboard objectives add pickupPotato minecraft.picked_up:minecraft.potato {"text":"Potatoes Picked Up"}
scoreboard objectives add pickupCarrot minecraft.picked_up:minecraft.carrot {"text":"Carrots Picked Up"}
scoreboard objectives add pickupBeetroot minecraft.picked_up:minecraft.beetroot {"text":"Beetroots Picked Up"}
scoreboard objectives add pickupPumpkin minecraft.picked_up:minecraft.pumpkin {"text":"Pumpkins Picked Up"}
scoreboard objectives add pickupMelonSlice minecraft.picked_up:minecraft.melon_slice {"text":"Melon Slices Picked Up"}

#Egg objectives
scoreboard objectives add eggResetTimer dummy "Egg Reset Timer"

# Mining objectives
scoreboard objectives add brokenCoal minecraft.mined:minecraft.coal_ore {"text":"Coal Broken"}
scoreboard objectives add brokenIron minecraft.mined:minecraft.iron_ore {"text":"Iron Broken"}
scoreboard objectives add brokenGold minecraft.mined:minecraft.gold_ore {"text":"Gold Broken"}
scoreboard objectives add brokenDiamond minecraft.mined:minecraft.diamond_ore {"text":"Diamond Broken"}
scoreboard objectives add brokenEmerald minecraft.mined:minecraft.emerald_ore {"text":"Emerald Broken"}
scoreboard objectives add brokenLapis minecraft.mined:minecraft.lapis_ore {"text":"Lapis Broken"}
scoreboard objectives add brokenRedstone minecraft.mined:minecraft.redstone_ore {"text":"Redstone Broken"}
scoreboard objectives add brokenCopper minecraft.mined:minecraft.copper_ore {"text":"Copper Broken"}
scoreboard objectives add pickupCoal minecraft.picked_up:minecraft.coal {"text":"Coal Picked Up"}
scoreboard objectives add pickupIron minecraft.picked_up:minecraft.raw_iron {"text":"Raw Iron Picked Up"}
scoreboard objectives add pickupGold minecraft.picked_up:minecraft.raw_gold {"text":"Raw Gold Picked Up"}
scoreboard objectives add pickupDiamond minecraft.picked_up:minecraft.diamond {"text":"Diamond Picked Up"}
scoreboard objectives add pickupEmerald minecraft.picked_up:minecraft.emerald {"text":"Emerald Picked Up"}
scoreboard objectives add pickupLapis minecraft.picked_up:minecraft.lapis_lazuli {"text":"Lapis Picked Up"}
scoreboard objectives add pickupRedstone minecraft.picked_up:minecraft.redstone {"text":"Redstone Picked Up"}
scoreboard objectives add pickupCopper minecraft.picked_up:minecraft.raw_copper {"text":"Raw Copper Picked Up"}

# Nether mining objectives
scoreboard objectives add brokenNetherGold minecraft.mined:minecraft.nether_gold_ore {"text":"Nether Gold Broken"}
scoreboard objectives add brokenNetherQuartz minecraft.mined:minecraft.nether_quartz_ore {"text":"Nether Quartz Broken"}
scoreboard objectives add pickupGoldNugget minecraft.picked_up:minecraft.gold_nugget {"text":"Gold Nugget Picked Up"}
scoreboard objectives add pickupQuartz minecraft.picked_up:minecraft.quartz {"text":"Quartz Picked Up"}

# Deepslate mining objectives
scoreboard objectives add brokenDeepCoal minecraft.mined:minecraft.deepslate_coal_ore {"text":"Deepslate Coal Broken"}
scoreboard objectives add brokenDeepIron minecraft.mined:minecraft.deepslate_iron_ore {"text":"Deepslate Iron Broken"}
scoreboard objectives add brokenDeepGold minecraft.mined:minecraft.deepslate_gold_ore {"text":"Deepslate Gold Broken"}
scoreboard objectives add brokenDeepDiamond minecraft.mined:minecraft.deepslate_diamond_ore {"text":"Deepslate Diamond Broken"}
scoreboard objectives add brokenDeepEmerald minecraft.mined:minecraft.deepslate_emerald_ore {"text":"Deepslate Emerald Broken"}
scoreboard objectives add brokenDeepLapis minecraft.mined:minecraft.deepslate_lapis_ore {"text":"Deepslate Lapis Broken"}
scoreboard objectives add brokenDeepRedstone minecraft.mined:minecraft.deepslate_redstone_ore {"text":"Deepslate Redstone Broken"}
scoreboard objectives add brokenDeepCopper minecraft.mined:minecraft.deepslate_copper_ore {"text":"Deepslate Copper Broken"}

# Miner ore placement detection
scoreboard objectives add coalPlaced minecraft.used:minecraft.coal_ore
scoreboard objectives add ironPlaced minecraft.used:minecraft.iron_ore
scoreboard objectives add goldPlaced minecraft.used:minecraft.gold_ore
scoreboard objectives add diamondPlaced minecraft.used:minecraft.diamond_ore
scoreboard objectives add emeraldPlaced minecraft.used:minecraft.emerald_ore
scoreboard objectives add lapisPlaced minecraft.used:minecraft.lapis_ore
scoreboard objectives add redstonePlaced minecraft.used:minecraft.redstone_ore
scoreboard objectives add copperPlaced minecraft.used:minecraft.copper_ore
scoreboard objectives add deepCoalPlaced minecraft.used:minecraft.deepslate_coal_ore
scoreboard objectives add deepIronPlaced minecraft.used:minecraft.deepslate_iron_ore
scoreboard objectives add deepGoldPlaced minecraft.used:minecraft.deepslate_gold_ore
scoreboard objectives add deepDiamondPlaced minecraft.used:minecraft.deepslate_diamond_ore
scoreboard objectives add deepEmeraldPlaced minecraft.used:minecraft.deepslate_emerald_ore
scoreboard objectives add deepLapisPlaced minecraft.used:minecraft.deepslate_lapis_ore
scoreboard objectives add deepRedstonePlaced minecraft.used:minecraft.deepslate_redstone_ore
scoreboard objectives add deepCopperPlaced minecraft.used:minecraft.deepslate_copper_ore
scoreboard objectives add netherGoldPlaced minecraft.used:minecraft.nether_gold_ore
scoreboard objectives add netherQuartzPlaced minecraft.used:minecraft.nether_quartz_ore
scoreboard objectives add brokenAncientDebris minecraft.mined:minecraft.ancient_debris "Ancient Debris Broken"
scoreboard objectives add pickupAncientDebris minecraft.picked_up:minecraft.ancient_debris "Ancient Debris Picked Up"

# Farmer crop placement detection
scoreboard objectives add wheatPlaced minecraft.used:minecraft.wheat
scoreboard objectives add potatoPlaced minecraft.used:minecraft.potato
scoreboard objectives add carrotPlaced minecraft.used:minecraft.carrot
scoreboard objectives add beetrootPlaced minecraft.used:minecraft.beetroot
scoreboard objectives add pumpkinPlaced minecraft.used:minecraft.pumpkin
scoreboard objectives add melonPlaced minecraft.used:minecraft.melon

# Hunter job objectives
scoreboard objectives add HunterLevel dummy {"text":"Hunter Level"}
scoreboard objectives add HunterXP dummy {"text":"Hunter XP"}
scoreboard objectives add Hunt dummy {"text":"Hunt Count"}
scoreboard objectives add chooseHunter trigger {"text":"Choose Hunter Job"}
scoreboard objectives add lastHunterKill dummy {"text":"Last Hunter Kill Time"}
scoreboard objectives add hunterKillCount dummy {"text":"Hunter Kill Count"}

# Hunter anti-exploit system
scoreboard objectives add lastMobKill dummy {"text":"Last Mob Kill Time"}
scoreboard objectives add mobKillCount dummy {"text":"Mob Kill Count"}

# Hunter mob kill tracking - Common Hostile Mobs
scoreboard objectives add zombiesKilled minecraft.killed:minecraft.zombie {"text":"Zombies Killed"}
scoreboard objectives add skeletonsKilled minecraft.killed:minecraft.skeleton {"text":"Skeletons Killed"}
scoreboard objectives add creepersKilled minecraft.killed:minecraft.creeper {"text":"Creepers Killed"}
scoreboard objectives add spidersKilled minecraft.killed:minecraft.spider {"text":"Spiders Killed"}
scoreboard objectives add endermenKilled minecraft.killed:minecraft.enderman {"text":"Endermen Killed"}
scoreboard objectives add witchesKilled minecraft.killed:minecraft.witch {"text":"Witches Killed"}
scoreboard objectives add slimesKilled minecraft.killed:minecraft.slime {"text":"Slimes Killed"}
scoreboard objectives add phantomsKilled minecraft.killed:minecraft.phantom {"text":"Phantoms Killed"}
scoreboard objectives add drownedKilled minecraft.killed:minecraft.drowned {"text":"Drowned Killed"}
scoreboard objectives add husksKilled minecraft.killed:minecraft.husk {"text":"Husks Killed"}
scoreboard objectives add straysKilled minecraft.killed:minecraft.stray {"text":"Strays Killed"}
scoreboard objectives add caveSpidersKilled minecraft.killed:minecraft.cave_spider {"text":"Cave Spiders Killed"}
scoreboard objectives add wardenKilled minecraft.killed:minecraft.warden
scoreboard objectives add elderGuardianKilled minecraft.killed:minecraft.elder_guardian
scoreboard objectives add guardianKilled minecraft.killed:minecraft.guardian
scoreboard objectives add ravagerKilled minecraft.killed:minecraft.ravager
scoreboard objectives add pillagerKilled minecraft.killed:minecraft.pillager
scoreboard objectives add vindicatorKilled minecraft.killed:minecraft.vindicator
scoreboard objectives add evokerKilled minecraft.killed:minecraft.evoker
scoreboard objectives add vexKilled minecraft.killed:minecraft.vex
scoreboard objectives add silverfishKilled minecraft.killed:minecraft.silverfish
scoreboard objectives add zoglinKilled minecraft.killed:minecraft.zoglin
# Hunter mob kill tracking - Nether Mobs
scoreboard objectives add zombifiedPiglinsKilled minecraft.killed:minecraft.zombified_piglin {"text":"Zombified Piglins Killed"}
scoreboard objectives add blazesKilled minecraft.killed:minecraft.blaze {"text":"Blazes Killed"}
scoreboard objectives add ghastsKilled minecraft.killed:minecraft.ghast {"text":"Ghasts Killed"}
scoreboard objectives add witherSkeletonsKilled minecraft.killed:minecraft.wither_skeleton {"text":"Wither Skeletons Killed"}
scoreboard objectives add magmaCubesKilled minecraft.killed:minecraft.magma_cube {"text":"Magma Cubes Killed"}
scoreboard objectives add hoglinsKilled minecraft.killed:minecraft.hoglin {"text":"Hoglins Killed"}
scoreboard objectives add piglinsKilled minecraft.killed:minecraft.piglin {"text":"Piglins Killed"}
scoreboard objectives add piglinBrutesKilled minecraft.killed:minecraft.piglin_brute {"text":"Piglin Brutes Killed"}

# Hunter mob kill tracking - End Mobs
scoreboard objectives add endermitesKilled minecraft.killed:minecraft.endermite {"text":"Endermites Killed"}
scoreboard objectives add shulkersKilled minecraft.killed:minecraft.shulker {"text":"Shulkers Killed"}

# Hunter mob kill tracking - Boss Mobs
scoreboard objectives add withersKilled minecraft.killed:minecraft.wither {"text":"Withers Killed"}
scoreboard objectives add enderDragonsKilled minecraft.killed:minecraft.ender_dragon {"text":"Ender Dragons Killed"}

scoreboard objectives add itemsCrafted minecraft.custom:minecraft.interact_with_crafting_table

# Blacksmith detection scoreboards (add to existing load.mcfunction)
scoreboard objectives add BlacksmithLevel dummy {"text":"Blacksmith Level"}
scoreboard objectives add BlacksmithXP dummy {"text":"Blacksmith XP"}
scoreboard objectives add BlacksmithCrafted dummy {"text":"Items Crafted"}
scoreboard objectives add BlacksmithCrafted dummy {"text":"Items Crafted"}
scoreboard objectives add craftingFlag dummy

# Iron equipment crafting - these auto-increment when items are crafted
scoreboard objectives add craftIronHelmet minecraft.crafted:minecraft.iron_helmet
scoreboard objectives add craftIronChest minecraft.crafted:minecraft.iron_chestplate
scoreboard objectives add craftIronLegs minecraft.crafted:minecraft.iron_leggings
scoreboard objectives add craftIronBoots minecraft.crafted:minecraft.iron_boots
scoreboard objectives add craftIronSword minecraft.crafted:minecraft.iron_sword
scoreboard objectives add craftIronPickaxe minecraft.crafted:minecraft.iron_pickaxe
scoreboard objectives add craftIronAxe minecraft.crafted:minecraft.iron_axe
scoreboard objectives add craftIronShovel minecraft.crafted:minecraft.iron_shovel
scoreboard objectives add craftIronHoe minecraft.crafted:minecraft.iron_hoe

# Gold, Diamond, Netherite objectives...
scoreboard objectives add craftGoldHelmet minecraft.crafted:minecraft.golden_helmet
scoreboard objectives add craftGoldChest minecraft.crafted:minecraft.golden_chestplate
scoreboard objectives add craftGoldLegs minecraft.crafted:minecraft.golden_leggings
scoreboard objectives add craftGoldBoots minecraft.crafted:minecraft.golden_boots
scoreboard objectives add craftGoldSword minecraft.crafted:minecraft.golden_sword
scoreboard objectives add craftGoldPickaxe minecraft.crafted:minecraft.golden_pickaxe
scoreboard objectives add craftGoldAxe minecraft.crafted:minecraft.golden_axe
scoreboard objectives add craftGoldShovel minecraft.crafted:minecraft.golden_shovel
scoreboard objectives add craftGoldHoe minecraft.crafted:minecraft.golden_hoe

scoreboard objectives add craftDiamondHelmet minecraft.crafted:minecraft.diamond_helmet
scoreboard objectives add craftDiamondChest minecraft.crafted:minecraft.diamond_chestplate
scoreboard objectives add craftDiamondLegs minecraft.crafted:minecraft.diamond_leggings
scoreboard objectives add craftDiamondBoots minecraft.crafted:minecraft.diamond_boots
scoreboard objectives add craftDiamondSword minecraft.crafted:minecraft.diamond_sword
scoreboard objectives add craftDiamondPickaxe minecraft.crafted:minecraft.diamond_pickaxe
scoreboard objectives add craftDiamondAxe minecraft.crafted:minecraft.diamond_axe
scoreboard objectives add craftDiamondShovel minecraft.crafted:minecraft.diamond_shovel
scoreboard objectives add craftDiamondHoe minecraft.crafted:minecraft.diamond_hoe

scoreboard objectives add craftNetheriteHelmet minecraft.crafted:minecraft.netherite_helmet
scoreboard objectives add craftNetheriteChest minecraft.crafted:minecraft.netherite_chestplate
scoreboard objectives add craftNetheriteLegs minecraft.crafted:minecraft.netherite_leggings
scoreboard objectives add craftNetheriteBoots minecraft.crafted:minecraft.netherite_boots
scoreboard objectives add craftNetheriteSword minecraft.crafted:minecraft.netherite_sword
scoreboard objectives add craftNetheritePickaxe minecraft.crafted:minecraft.netherite_pickaxe
scoreboard objectives add craftNetheriteAxe minecraft.crafted:minecraft.netherite_axe
scoreboard objectives add craftNetheriteShovel minecraft.crafted:minecraft.netherite_shovel
scoreboard objectives add craftNetheriteHoe minecraft.crafted:minecraft.netherite_hoe

scoreboard objectives add preprocessFlag dummy
scoreboard players set #preprocessFlag dummy 0

# Enable hunter job trigger
scoreboard players enable @a chooseHunter

# Create and setup teams for ranks
team add peasant {"text":"Peasant","color":"white"}
team add commoner {"text":"Commoner","color":"green"}
team add noble {"text":"Noble","color":"yellow"}
team add royal {"text":"Royal","color":"red"}

# Set team colors and prefixes
team modify peasant color white
team modify commoner color green
team modify noble color yellow
team modify royal color red
team modify peasant prefix {"text":"[Peasant]","color":"white"}
team modify commoner prefix {"text":"[Commoner]","color":"green"}
team modify noble prefix {"text":"[Noble]","color":"yellow"}
team modify royal prefix {"text":"[Royal]","color":"red"}

# Set display areas
scoreboard objectives setdisplay list money

# Initialize flags
scoreboard players set workerPayFlag workerPayFlag 0
scoreboard objectives add woolProcessFlag dummy
scoreboard players set woolProcessFlag woolProcessFlag 0

# Initialize realtor system
scoreboard players set @a chunksOwned 0
scoreboard players set @a pendingSale 0
scoreboard players set @a saleTimer 0

# Enable trigger objectives
scoreboard players enable @a pay
scoreboard players enable @a chooseWorker
scoreboard players enable @a quitJob
scoreboard players enable @a sellChunk
scoreboard players enable @a confirmSale
scoreboard players enable @a cancelSale
scoreboard players enable @a saleInfo
scoreboard players enable @a testMode

# Stock Market Objectives - Add these to your load.mcfunction

# Stock price tracking
scoreboard objectives add farmerStockPrice dummy "Farmer Stock Price"

# Individual player share ownership
scoreboard objectives add farmerShares dummy "Farmer Shares Owned"

# Buy/sell pressure accumulators
scoreboard objectives add farmerBuyPressure dummy "Farmer Buy Pressure"
scoreboard objectives add farmerSellPressure dummy "Farmer Sell Pressure"

# Player trading triggers (THESE ARE CRITICAL - without these, triggers won't work)
scoreboard objectives add buyFarmerStock trigger "Buy Farmer Stock"
scoreboard objectives add sellFarmerStock trigger "Sell Farmer Stock"

# Daily collective XP tracking
scoreboard objectives add dailyFarmerXP dummy "Daily Farmer XP Total"

# Stock market update timer (shared across all stocks)
scoreboard objectives add stockUpdateTimer dummy "Stock Update Timer"

# Miner shares
scoreboard objectives add minerStockPrice dummy "Miner Stock Price"
scoreboard objectives add minerShares dummy "Miner Shares Owned"
scoreboard objectives add minerBuyPressure dummy "Miner Buy Pressure"
scoreboard objectives add minerSellPressure dummy "Miner Sell Pressure"
scoreboard objectives add buyMinerStock trigger "Buy Miner Stock"
scoreboard objectives add sellMinerStock trigger "Sell Miner Stock"
scoreboard objectives add dailyMinerXP dummy "Daily Miner XP Total"

# Rancher shares
scoreboard objectives add rancherStockPrice dummy "Rancher Stock Price"
scoreboard objectives add rancherShares dummy "Rancher Shares Owned"
scoreboard objectives add rancherBuyPressure dummy "Rancher Buy Pressure"
scoreboard objectives add rancherSellPressure dummy "Rancher Sell Pressure"
scoreboard objectives add buyRancherStock trigger "Buy Rancher Stock"
scoreboard objectives add sellRancherStock trigger "Sell Rancher Stock"
scoreboard objectives add dailyRancherXP dummy "Daily Rancher XP Total"

# Hunter shares
scoreboard objectives add hunterStockPrice dummy "Hunter Stock Price"
scoreboard objectives add hunterShares dummy "Hunter Shares Owned"
scoreboard objectives add hunterBuyPressure dummy "Hunter Buy Pressure"
scoreboard objectives add hunterSellPressure dummy "Hunter Sell Pressure"
scoreboard objectives add buyHunterStock trigger "Buy Hunter Stock"
scoreboard objectives add sellHunterStock trigger "Sell Hunter Stock"
scoreboard objectives add dailyHunterXP dummy "Daily Hunter XP Total"

# Fisher shares
scoreboard objectives add fisherStockPrice dummy "Fisher Stock Price"
scoreboard objectives add fisherShares dummy "Fisher Shares Owned"
scoreboard objectives add fisherBuyPressure dummy "Fisher Buy Pressure"
scoreboard objectives add fisherSellPressure dummy "Fisher Sell Pressure"
scoreboard objectives add buyFisherStock trigger "Buy Fisher Stock"
scoreboard objectives add sellFisherStock trigger "Sell Fisher Stock"
scoreboard objectives add dailyFisherXP dummy "Daily Fisher XP Total"

# Blacksmith shares
scoreboard objectives add blacksmithStockPrice dummy "Blacksmith Stock Price"
scoreboard objectives add blacksmithShares dummy "Blacksmith Shares Owned"
scoreboard objectives add blacksmithBuyPressure dummy "Blacksmith Buy Pressure"
scoreboard objectives add blacksmithSellPressure dummy "Blacksmith Sell Pressure"
scoreboard objectives add buyBlacksmithStock trigger "Buy Blacksmith Stock"
scoreboard objectives add sellBlacksmithStock trigger "Sell Blacksmith Stock"
scoreboard objectives add dailyBlacksmithXP dummy "Daily Blacksmith XP Total"

# Lumberjack shares
scoreboard objectives add lumberStockPrice dummy "Lumber Stock Price"
scoreboard objectives add lumberShares dummy "Lumber Shares Owned"
scoreboard objectives add lumberBuyPressure dummy "Lumber Buy Pressure"
scoreboard objectives add lumberSellPressure dummy "Lumber Sell Pressure"
scoreboard objectives add buyLumberStock trigger "Buy Lumber Stock"
scoreboard objectives add sellLumberStock trigger "Sell Lumber Stock"
scoreboard objectives add dailyLumberXP dummy "Daily Lumber XP Total"

# Cook shares
scoreboard objectives add cookStockPrice dummy "Cook Stock Price"
scoreboard objectives add cookShares dummy "Cook Shares Owned"
scoreboard objectives add cookBuyPressure dummy "Cook Buy Pressure"
scoreboard objectives add cookSellPressure dummy "Cook Sell Pressure"
scoreboard objectives add buyCookStock trigger "Buy Cook Stock"
scoreboard objectives add sellCookStock trigger "Sell Cook Stock"
scoreboard objectives add dailyCookXP dummy "Daily Cook XP Total"

# Archer shares
scoreboard objectives add archerStockPrice dummy "Archer Stock Price"
scoreboard objectives add archerShares dummy "Archer Shares Owned"
scoreboard objectives add archerBuyPressure dummy "Archer Buy Pressure"
scoreboard objectives add archerSellPressure dummy "Archer Sell Pressure"
scoreboard objectives add buyArcherStock trigger "Buy Archer Stock"
scoreboard objectives add sellArcherStock trigger "Sell Archer Stock"
scoreboard objectives add dailyArcherXP dummy "Daily Archer XP Total"

# Warrior shares
scoreboard objectives add warriorStockPrice dummy "Warrior Stock Price"
scoreboard objectives add warriorShares dummy "Warrior Shares Owned"
scoreboard objectives add warriorBuyPressure dummy "Warrior Buy Pressure"
scoreboard objectives add warriorSellPressure dummy "Warrior Sell Pressure"
scoreboard objectives add buyWarriorStock trigger "Buy Warrior Stock"
scoreboard objectives add sellWarriorStock trigger "Sell Warrior Stock"
scoreboard objectives add dailyWarriorXP dummy "Daily Warrior XP Total"

# Enchanter Stock Market
scoreboard objectives add enchanterStockPrice dummy "Enchanter Stock Price"
scoreboard objectives add enchanterShares dummy "Enchanter Shares Owned"
scoreboard objectives add enchanterBuyPressure dummy "Enchanter Buy Pressure"
scoreboard objectives add enchanterSellPressure dummy "Enchanter Sell Pressure"
scoreboard objectives add buyEnchanterStock trigger "Buy Enchanter Stock"
scoreboard objectives add sellEnchanterStock trigger "Sell Enchanter Stock"
scoreboard objectives add dailyEnchanterXP dummy "Daily Enchanter XP Total"
scoreboard objectives add giveEnchanterShares trigger "Give Enchanter Shares"
# Enchanter payment calculation temp variables
scoreboard objectives add enchantertemp dummy "Enchanter Temp Calculations"

# Alchemy objectives
scoreboard objectives add AlchemyLevel dummy "Alchemy Level"
scoreboard objectives add AlchemyXP dummy "Alchemy XP"
scoreboard objectives add AlchemyWork dummy "Alchemy Work Done"
scoreboard objectives add alchemyMult dummy "Alchemy Multiplier"
scoreboard objectives add setAlchemyMult trigger "Set Alchemy Multiplier"
scoreboard objectives add totalAlchemy dummy "Total Alchemy Pay"
scoreboard objectives add alchemytemp dummy "Alchemy Temp Calculations"

# Alchemy Stock Market
scoreboard objectives add alchemyStockPrice dummy "Alchemy Stock Price"
scoreboard objectives add alchemyShares dummy "Alchemy Shares Owned"
scoreboard objectives add alchemyBuyPressure dummy "Alchemy Buy Pressure"
scoreboard objectives add alchemySellPressure dummy "Alchemy Sell Pressure"
scoreboard objectives add buyAlchemyStock trigger "Buy Alchemy Stock"
scoreboard objectives add sellAlchemyStock trigger "Sell Alchemy Stock"
scoreboard objectives add dailyAlchemyXP dummy "Daily Alchemy XP Total"
scoreboard objectives add giveAlchemyShares trigger "Give Alchemy Shares"

# Event System Objectives
scoreboard objectives add eventActive dummy "Event Active Flag"
scoreboard objectives add eventDaysRemaining dummy "Event Days Left"
scoreboard objectives add eventJob dummy "Event Job Type"
scoreboard objectives add eventMoneyMult dummy "Event Money Multiplier"
scoreboard objectives add eventXPMult dummy "Event XP Multiplier"
scoreboard objectives add eventQueued dummy "Queued Event Flag"
scoreboard objectives add queuedEventJob dummy "Queued Job Type"
scoreboard objectives add queuedMoneyMult dummy "Queued Money Mult"
scoreboard objectives add queuedXPMult dummy "Queued XP Mult"
scoreboard objectives add queuedDuration dummy "Queued Duration"

# Event Control Triggers (Treasurer only)
scoreboard objectives add eventDaysDuration trigger "Set Event Duration"
scoreboard objectives add eventMoneyMultiplier trigger "Set Money Multiplier"
scoreboard objectives add eventXPMultiplier trigger "Set XP Multiplier"
scoreboard objectives add eventCancel trigger "Cancel Event"

# Job-specific Event Triggers
scoreboard objectives add eventFarming trigger "Farming Event"
scoreboard objectives add eventMining trigger "Mining Event"
scoreboard objectives add eventRanching trigger "Ranching Event"
scoreboard objectives add eventHunter trigger "Hunter Event"
scoreboard objectives add eventFisher trigger "Fisher Event"
scoreboard objectives add eventBlacksmith trigger "Blacksmith Event"
scoreboard objectives add eventLumber trigger "Lumber Event"
scoreboard objectives add eventCook trigger "Cook Event"
scoreboard objectives add eventArcher trigger "Archer Event"
scoreboard objectives add eventWarrior trigger "Warrior Event"
scoreboard objectives add eventEnchanter trigger "Enchanter Event"
scoreboard objectives add eventAlchemy trigger "Alchemy Event"

# Set default multiplier and level
scoreboard players set #global alchemyMult 100
scoreboard players set @a[scores={AlchemyLevel=0}] AlchemyLevel 1

# Temporary calculation objectives (these are REUSED from existing ones, so check if you already have them)
# If you don't have these already, add them:
scoreboard objectives add stockTemp dummy "Stock Temp Calculations"
scoreboard objectives add tradeAmount dummy "Trade Amount"
scoreboard objectives add tradeCost dummy "Trade Cost"
scoreboard objectives add shareValue dummy "Share Value"
scoreboard objectives add commission dummy "Commission Amount"

scoreboard objectives add shearsUsed minecraft.used:minecraft.shears {"text":"Shears Used"}
scoreboard objectives add damageDealt minecraft.custom:minecraft.damage_dealt {"text":"Damage Dealt"}
scoreboard objectives add swordUsed minecraft.used:minecraft.wooden_sword
scoreboard objectives add sheepShear dummy {"text":"Sheep Shearing Counter"}

# mailbox System Objectives
scoreboard objectives add mailboxNumber dummy "Player's mailbox Number"
scoreboard objectives add nextmailbox dummy "Next Available mailbox Number"
scoreboard objectives add createmailbox trigger "Create mailbox"
scoreboard objectives add checkMail trigger "Check Mail"
scoreboard objectives add sendMail trigger "Send Mail to mailbox"
scoreboard objectives add sendMoney trigger "Send Money Amount"
scoreboard objectives add claimMail trigger "Claim Mail Money"
scoreboard objectives add mailTemp dummy "Mail Temporary Storage"


# Pre-create mailbox storage (for first 10 players)
scoreboard objectives add mailbox0001 dummy "mailbox 0001"
scoreboard objectives add mailbox0002 dummy "mailbox 0002"
scoreboard objectives add mailbox0003 dummy "mailbox 0003"
scoreboard objectives add mailbox0004 dummy "mailbox 0004"
scoreboard objectives add mailbox0005 dummy "mailbox 0005"
scoreboard objectives add mailbox0006 dummy "mailbox 0006"
scoreboard objectives add mailbox0007 dummy "mailbox 0007"
scoreboard objectives add mailbox0008 dummy "mailbox 0008"
scoreboard objectives add mailbox0009 dummy "mailbox 0009"
scoreboard objectives add mailbox0010 dummy "mailbox 0010"
scoreboard objectives add mailbox0011 dummy "mailbox 0011"
scoreboard objectives add mailbox0012 dummy "mailbox 0012"
scoreboard objectives add mailbox0013 dummy "mailbox 0013"
scoreboard objectives add mailbox0014 dummy "mailbox 0014"
scoreboard objectives add mailbox0015 dummy "mailbox 0015"
scoreboard objectives add mailbox0016 dummy "mailbox 0016"
scoreboard objectives add mailbox0017 dummy "mailbox 0017"
scoreboard objectives add mailbox0018 dummy "mailbox 0018"
scoreboard objectives add mailbox0019 dummy "mailbox 0019"
scoreboard objectives add mailbox0020 dummy "mailbox 0020"
scoreboard objectives add mailbox0021 dummy "mailbox 0021"
scoreboard objectives add mailbox0022 dummy "mailbox 0022"
scoreboard objectives add mailbox0023 dummy "mailbox 0023"
scoreboard objectives add mailbox0024 dummy "mailbox 0024"
scoreboard objectives add mailbox0025 dummy "mailbox 0025"
scoreboard objectives add mailbox0026 dummy "mailbox 0026"
scoreboard objectives add mailbox0027 dummy "mailbox 0027"
scoreboard objectives add mailbox0028 dummy "mailbox 0028"
scoreboard objectives add mailbox0029 dummy "mailbox 0029"
scoreboard objectives add mailbox0030 dummy "mailbox 0030"
scoreboard objectives add mailbox0031 dummy "mailbox 0031"
scoreboard objectives add mailbox0032 dummy "mailbox 0032"
scoreboard objectives add mailbox0033 dummy "mailbox 0033"
scoreboard objectives add mailbox0034 dummy "mailbox 0034"
scoreboard objectives add mailbox0035 dummy "mailbox 0035"
scoreboard objectives add mailbox0036 dummy "mailbox 0036"
scoreboard objectives add mailbox0037 dummy "mailbox 0037"
scoreboard objectives add mailbox0038 dummy "mailbox 0038"
scoreboard objectives add mailbox0039 dummy "mailbox 0039"
scoreboard objectives add mailbox0040 dummy "mailbox 0040"
scoreboard objectives add mailbox0041 dummy "mailbox 0041"
scoreboard objectives add mailbox0042 dummy "mailbox 0042"
scoreboard objectives add mailbox0043 dummy "mailbox 0043"
scoreboard objectives add mailbox0044 dummy "mailbox 0044"
scoreboard objectives add mailbox0045 dummy "mailbox 0045"
scoreboard objectives add mailbox0046 dummy "mailbox 0046"
scoreboard objectives add mailbox0047 dummy "mailbox 0047"
scoreboard objectives add mailbox0048 dummy "mailbox 0048"
scoreboard objectives add mailbox0049 dummy "mailbox 0049"
scoreboard objectives add mailbox0050 dummy "mailbox 0050"
scoreboard objectives add mailbox0051 dummy "mailbox 0051"
scoreboard objectives add mailbox0052 dummy "mailbox 0052"
scoreboard objectives add mailbox0053 dummy "mailbox 0053"
scoreboard objectives add mailbox0054 dummy "mailbox 0054"
scoreboard objectives add mailbox0055 dummy "mailbox 0055"
scoreboard objectives add mailbox0056 dummy "mailbox 0056"
scoreboard objectives add mailbox0057 dummy "mailbox 0057"
scoreboard objectives add mailbox0058 dummy "mailbox 0058"
scoreboard objectives add mailbox0059 dummy "mailbox 0059"
scoreboard objectives add mailbox0060 dummy "mailbox 0060"
scoreboard objectives add mailbox0071 dummy "mailbox 0071"
scoreboard objectives add mailbox0072 dummy "mailbox 0072"
scoreboard objectives add mailbox0073 dummy "mailbox 0073"
scoreboard objectives add mailbox0074 dummy "mailbox 0074"
scoreboard objectives add mailbox0075 dummy "mailbox 0075"
scoreboard objectives add mailbox0076 dummy "mailbox 0076"
scoreboard objectives add mailbox0077 dummy "mailbox 0077"
scoreboard objectives add mailbox0078 dummy "mailbox 0078"
scoreboard objectives add mailbox0079 dummy "mailbox 0079"
scoreboard objectives add mailbox0080 dummy "mailbox 0080"
scoreboard objectives add mailbox0081 dummy "mailbox 0081"
scoreboard objectives add mailbox0082 dummy "mailbox 0082"
scoreboard objectives add mailbox0083 dummy "mailbox 0083"
scoreboard objectives add mailbox0084 dummy "mailbox 0084"
scoreboard objectives add mailbox0085 dummy "mailbox 0085"
scoreboard objectives add mailbox0086 dummy "mailbox 0086"
scoreboard objectives add mailbox0087 dummy "mailbox 0087"
scoreboard objectives add mailbox0088 dummy "mailbox 0088"
scoreboard objectives add mailbox0089 dummy "mailbox 0089"
scoreboard objectives add mailbox0090 dummy "mailbox 0090"
scoreboard objectives add mailbox0091 dummy "mailbox 0091"
scoreboard objectives add mailbox0092 dummy "mailbox 0092"
scoreboard objectives add mailbox0093 dummy "mailbox 0093"
scoreboard objectives add mailbox0094 dummy "mailbox 0094"
scoreboard objectives add mailbox0095 dummy "mailbox 0095"
scoreboard objectives add mailbox0096 dummy "mailbox 0096"
scoreboard objectives add mailbox0097 dummy "mailbox 0097"
scoreboard objectives add mailbox0098 dummy "mailbox 0098"
scoreboard objectives add mailbox0099 dummy "mailbox 0099"
scoreboard objectives add mailbox0100 dummy "mailbox 0100"
scoreboard objectives add mailbox0101 dummy "mailbox 0101"
scoreboard objectives add mailbox0102 dummy "mailbox 0102"
scoreboard objectives add mailbox0103 dummy "mailbox 0103"
scoreboard objectives add mailbox0104 dummy "mailbox 0104"
scoreboard objectives add mailbox0105 dummy "mailbox 0105"
scoreboard objectives add mailbox0106 dummy "mailbox 0106"
scoreboard objectives add mailbox0107 dummy "mailbox 0107"
scoreboard objectives add mailbox0108 dummy "mailbox 0108"
scoreboard objectives add mailbox0109 dummy "mailbox 0109"
scoreboard objectives add mailbox0110 dummy "mailbox 0110"
scoreboard objectives add mailbox0111 dummy "mailbox 0111"
scoreboard objectives add mailbox0112 dummy "mailbox 0112"
scoreboard objectives add mailbox0113 dummy "mailbox 0113"
scoreboard objectives add mailbox0114 dummy "mailbox 0114"
scoreboard objectives add mailbox0115 dummy "mailbox 0115"
scoreboard objectives add mailbox0116 dummy "mailbox 0116"
scoreboard objectives add mailbox0117 dummy "mailbox 0117"
scoreboard objectives add mailbox0118 dummy "mailbox 0118"
scoreboard objectives add mailbox0119 dummy "mailbox 0119"
scoreboard objectives add mailbox0120 dummy "mailbox 0120"
scoreboard objectives add mailbox0121 dummy "mailbox 0121"
scoreboard objectives add mailbox0122 dummy "mailbox 0122"
scoreboard objectives add mailbox0123 dummy "mailbox 0123"
scoreboard objectives add mailbox0124 dummy "mailbox 0124"
scoreboard objectives add mailbox0125 dummy "mailbox 0125"
scoreboard objectives add mailbox0126 dummy "mailbox 0126"
scoreboard objectives add mailbox0127 dummy "mailbox 0127"
scoreboard objectives add mailbox0128 dummy "mailbox 0128"
scoreboard objectives add mailbox0129 dummy "mailbox 0129"
scoreboard objectives add mailbox0130 dummy "mailbox 0130"
scoreboard objectives add mailbox0131 dummy "mailbox 0131"
scoreboard objectives add mailbox0132 dummy "mailbox 0132"
scoreboard objectives add mailbox0133 dummy "mailbox 0133"
scoreboard objectives add mailbox0134 dummy "mailbox 0134"
scoreboard objectives add mailbox0135 dummy "mailbox 0135"
scoreboard objectives add mailbox0136 dummy "mailbox 0136"
scoreboard objectives add mailbox0137 dummy "mailbox 0137"
scoreboard objectives add mailbox0138 dummy "mailbox 0138"
scoreboard objectives add mailbox0139 dummy "mailbox 0139"
scoreboard objectives add mailbox0140 dummy "mailbox 0140"
scoreboard objectives add mailbox0141 dummy "mailbox 0141"
scoreboard objectives add mailbox0142 dummy "mailbox 0142"
scoreboard objectives add mailbox0143 dummy "mailbox 0143"
scoreboard objectives add mailbox0144 dummy "mailbox 0144"
scoreboard objectives add mailbox0145 dummy "mailbox 0145"
scoreboard objectives add mailbox0146 dummy "mailbox 0146"
scoreboard objectives add mailbox0147 dummy "mailbox 0147"
scoreboard objectives add mailbox0148 dummy "mailbox 0148"
scoreboard objectives add mailbox0149 dummy "mailbox 0149"
scoreboard objectives add mailbox0150 dummy "mailbox 0150"
scoreboard objectives add mailbox0151 dummy "mailbox 0151"
scoreboard objectives add mailbox0152 dummy "mailbox 0152"
scoreboard objectives add mailbox0153 dummy "mailbox 0153"
scoreboard objectives add mailbox0154 dummy "mailbox 0154"
scoreboard objectives add mailbox0155 dummy "mailbox 0155"
scoreboard objectives add mailbox0156 dummy "mailbox 0156"
scoreboard objectives add mailbox0157 dummy "mailbox 0157"
scoreboard objectives add mailbox0158 dummy "mailbox 0158"
scoreboard objectives add mailbox0159 dummy "mailbox 0159"
scoreboard objectives add mailbox0160 dummy "mailbox 0160"
scoreboard objectives add mailbox0171 dummy "mailbox 0171"
scoreboard objectives add mailbox0172 dummy "mailbox 0172"
scoreboard objectives add mailbox0173 dummy "mailbox 0173"
scoreboard objectives add mailbox0174 dummy "mailbox 0174"
scoreboard objectives add mailbox0175 dummy "mailbox 0175"
scoreboard objectives add mailbox0176 dummy "mailbox 0176"
scoreboard objectives add mailbox0177 dummy "mailbox 0177"
scoreboard objectives add mailbox0178 dummy "mailbox 0178"
scoreboard objectives add mailbox0179 dummy "mailbox 0179"
scoreboard objectives add mailbox0180 dummy "mailbox 0180"
scoreboard objectives add mailbox0181 dummy "mailbox 0181"
scoreboard objectives add mailbox0182 dummy "mailbox 0182"
scoreboard objectives add mailbox0183 dummy "mailbox 0183"
scoreboard objectives add mailbox0184 dummy "mailbox 0184"
scoreboard objectives add mailbox0185 dummy "mailbox 0185"
scoreboard objectives add mailbox0186 dummy "mailbox 0186"
scoreboard objectives add mailbox0187 dummy "mailbox 0187"
scoreboard objectives add mailbox0188 dummy "mailbox 0188"
scoreboard objectives add mailbox0189 dummy "mailbox 0189"
scoreboard objectives add mailbox0190 dummy "mailbox 0190"
scoreboard objectives add mailbox0191 dummy "mailbox 0191"
scoreboard objectives add mailbox0192 dummy "mailbox 0192"
scoreboard objectives add mailbox0193 dummy "mailbox 0193"
scoreboard objectives add mailbox0194 dummy "mailbox 0194"
scoreboard objectives add mailbox0195 dummy "mailbox 0195"
scoreboard objectives add mailbox0196 dummy "mailbox 0196"
scoreboard objectives add mailbox0197 dummy "mailbox 0197"
scoreboard objectives add mailbox0198 dummy "mailbox 0198"
scoreboard objectives add mailbox0199 dummy "mailbox 0199"
scoreboard objectives add mailbox0200 dummy "mailbox 0200"
scoreboard objectives add mailbox0201 dummy "mailbox 0201"
scoreboard objectives add mailbox0202 dummy "mailbox 0202"
scoreboard objectives add mailbox0203 dummy "mailbox 0203"
scoreboard objectives add mailbox0204 dummy "mailbox 0204"
scoreboard objectives add mailbox0205 dummy "mailbox 0205"
scoreboard objectives add mailbox0206 dummy "mailbox 0206"
scoreboard objectives add mailbox0207 dummy "mailbox 0207"
scoreboard objectives add mailbox0208 dummy "mailbox 0208"
scoreboard objectives add mailbox0209 dummy "mailbox 0209"
scoreboard objectives add mailbox0210 dummy "mailbox 0210"
scoreboard objectives add mailbox0211 dummy "mailbox 0211"
scoreboard objectives add mailbox0212 dummy "mailbox 0212"
scoreboard objectives add mailbox0213 dummy "mailbox 0213"
scoreboard objectives add mailbox0214 dummy "mailbox 0214"
scoreboard objectives add mailbox0215 dummy "mailbox 0215"
scoreboard objectives add mailbox0216 dummy "mailbox 0216"
scoreboard objectives add mailbox0217 dummy "mailbox 0217"
scoreboard objectives add mailbox0218 dummy "mailbox 0218"
scoreboard objectives add mailbox0219 dummy "mailbox 0219"
scoreboard objectives add mailbox0220 dummy "mailbox 0220"
scoreboard objectives add mailbox0221 dummy "mailbox 0221"
scoreboard objectives add mailbox0222 dummy "mailbox 0222"
scoreboard objectives add mailbox0223 dummy "mailbox 0223"
scoreboard objectives add mailbox0224 dummy "mailbox 0224"
scoreboard objectives add mailbox0225 dummy "mailbox 0225"
scoreboard objectives add mailbox0226 dummy "mailbox 0226"
scoreboard objectives add mailbox0227 dummy "mailbox 0227"
scoreboard objectives add mailbox0228 dummy "mailbox 0228"
scoreboard objectives add mailbox0229 dummy "mailbox 0229"
scoreboard objectives add mailbox0230 dummy "mailbox 0230"
scoreboard objectives add mailbox0231 dummy "mailbox 0231"
scoreboard objectives add mailbox0232 dummy "mailbox 0232"
scoreboard objectives add mailbox0233 dummy "mailbox 0233"
scoreboard objectives add mailbox0234 dummy "mailbox 0234"
scoreboard objectives add mailbox0235 dummy "mailbox 0235"
scoreboard objectives add mailbox0236 dummy "mailbox 0236"
scoreboard objectives add mailbox0237 dummy "mailbox 0237"
scoreboard objectives add mailbox0238 dummy "mailbox 0238"
scoreboard objectives add mailbox0239 dummy "mailbox 0239"
scoreboard objectives add mailbox0240 dummy "mailbox 0240"
scoreboard objectives add mailbox0241 dummy "mailbox 0241"
scoreboard objectives add mailbox0242 dummy "mailbox 0242"
scoreboard objectives add mailbox0243 dummy "mailbox 0243"
scoreboard objectives add mailbox0244 dummy "mailbox 0244"
scoreboard objectives add mailbox0245 dummy "mailbox 0245"
scoreboard objectives add mailbox0246 dummy "mailbox 0246"
scoreboard objectives add mailbox0247 dummy "mailbox 0247"
scoreboard objectives add mailbox0248 dummy "mailbox 0248"
scoreboard objectives add mailbox0249 dummy "mailbox 0249"
scoreboard objectives add mailbox0250 dummy "mailbox 0250"
scoreboard objectives add mailbox0251 dummy "mailbox 0251"
scoreboard objectives add mailbox0252 dummy "mailbox 0252"
scoreboard objectives add mailbox0253 dummy "mailbox 0253"
scoreboard objectives add mailbox0254 dummy "mailbox 0254"
scoreboard objectives add mailbox0255 dummy "mailbox 0255"
scoreboard objectives add mailbox0256 dummy "mailbox 0256"
scoreboard objectives add mailbox0257 dummy "mailbox 0257"
scoreboard objectives add mailbox0258 dummy "mailbox 0258"
scoreboard objectives add mailbox0259 dummy "mailbox 0259"
scoreboard objectives add mailbox0260 dummy "mailbox 0260"
scoreboard objectives add mailbox0271 dummy "mailbox 0271"
scoreboard objectives add mailbox0272 dummy "mailbox 0272"
scoreboard objectives add mailbox0273 dummy "mailbox 0273"
scoreboard objectives add mailbox0274 dummy "mailbox 0274"
scoreboard objectives add mailbox0275 dummy "mailbox 0275"
scoreboard objectives add mailbox0276 dummy "mailbox 0276"
scoreboard objectives add mailbox0277 dummy "mailbox 0277"
scoreboard objectives add mailbox0278 dummy "mailbox 0278"
scoreboard objectives add mailbox0279 dummy "mailbox 0279"
scoreboard objectives add mailbox0280 dummy "mailbox 0280"
scoreboard objectives add mailbox0281 dummy "mailbox 0281"
scoreboard objectives add mailbox0282 dummy "mailbox 0282"
scoreboard objectives add mailbox0283 dummy "mailbox 0283"
scoreboard objectives add mailbox0284 dummy "mailbox 0284"
scoreboard objectives add mailbox0285 dummy "mailbox 0285"
scoreboard objectives add mailbox0286 dummy "mailbox 0286"
scoreboard objectives add mailbox0287 dummy "mailbox 0287"
scoreboard objectives add mailbox0288 dummy "mailbox 0288"
scoreboard objectives add mailbox0289 dummy "mailbox 0289"
scoreboard objectives add mailbox0290 dummy "mailbox 0290"
scoreboard objectives add mailbox0291 dummy "mailbox 0291"
scoreboard objectives add mailbox0292 dummy "mailbox 0292"
scoreboard objectives add mailbox0293 dummy "mailbox 0293"
scoreboard objectives add mailbox0294 dummy "mailbox 0294"
scoreboard objectives add mailbox0295 dummy "mailbox 0295"
scoreboard objectives add mailbox0296 dummy "mailbox 0296"
scoreboard objectives add mailbox0297 dummy "mailbox 0297"
scoreboard objectives add mailbox0298 dummy "mailbox 0298"
scoreboard objectives add mailbox0299 dummy "mailbox 0299"
scoreboard objectives add mailbox0300 dummy "mailbox 0300"

# Initialize the mailbox counter
scoreboard players set #system nextmailbox 1

# Initialize all mailbox balances to 0

scoreboard players add #mailbox mailbox0001 0
scoreboard players add #mailbox mailbox0002 0
scoreboard players add #mailbox mailbox0003 0
scoreboard players add #mailbox mailbox0004 0
scoreboard players add #mailbox mailbox0005 0
scoreboard players add #mailbox mailbox0006 0
scoreboard players add #mailbox mailbox0007 0
scoreboard players add #mailbox mailbox0008 0
scoreboard players add #mailbox mailbox0009 0
scoreboard players add #mailbox mailbox0010 0
scoreboard players add #mailbox mailbox0011 0
scoreboard players add #mailbox mailbox0012 0
scoreboard players add #mailbox mailbox0013 0
scoreboard players add #mailbox mailbox0014 0
scoreboard players add #mailbox mailbox0015 0
scoreboard players add #mailbox mailbox0016 0
scoreboard players add #mailbox mailbox0017 0
scoreboard players add #mailbox mailbox0018 0
scoreboard players add #mailbox mailbox0019 0
scoreboard players add #mailbox mailbox0020 0
scoreboard players add #mailbox mailbox0021 0
scoreboard players add #mailbox mailbox0022 0
scoreboard players add #mailbox mailbox0023 0
scoreboard players add #mailbox mailbox0024 0
scoreboard players add #mailbox mailbox0025 0
scoreboard players add #mailbox mailbox0026 0
scoreboard players add #mailbox mailbox0027 0
scoreboard players add #mailbox mailbox0028 0
scoreboard players add #mailbox mailbox0029 0
scoreboard players add #mailbox mailbox0030 0
scoreboard players add #mailbox mailbox0031 0
scoreboard players add #mailbox mailbox0032 0
scoreboard players add #mailbox mailbox0033 0
scoreboard players add #mailbox mailbox0034 0
scoreboard players add #mailbox mailbox0035 0
scoreboard players add #mailbox mailbox0036 0
scoreboard players add #mailbox mailbox0037 0
scoreboard players add #mailbox mailbox0038 0
scoreboard players add #mailbox mailbox0039 0
scoreboard players add #mailbox mailbox0040 0
scoreboard players add #mailbox mailbox0041 0
scoreboard players add #mailbox mailbox0042 0
scoreboard players add #mailbox mailbox0043 0
scoreboard players add #mailbox mailbox0044 0
scoreboard players add #mailbox mailbox0045 0
scoreboard players add #mailbox mailbox0046 0
scoreboard players add #mailbox mailbox0047 0
scoreboard players add #mailbox mailbox0048 0
scoreboard players add #mailbox mailbox0049 0
scoreboard players add #mailbox mailbox0050 0
scoreboard players add #mailbox mailbox0051 0
scoreboard players add #mailbox mailbox0052 0
scoreboard players add #mailbox mailbox0053 0
scoreboard players add #mailbox mailbox0054 0
scoreboard players add #mailbox mailbox0055 0
scoreboard players add #mailbox mailbox0056 0
scoreboard players add #mailbox mailbox0057 0
scoreboard players add #mailbox mailbox0058 0
scoreboard players add #mailbox mailbox0059 0
scoreboard players add #mailbox mailbox0060 0
scoreboard players add #mailbox mailbox0071 0
scoreboard players add #mailbox mailbox0072 0
scoreboard players add #mailbox mailbox0073 0
scoreboard players add #mailbox mailbox0074 0
scoreboard players add #mailbox mailbox0075 0
scoreboard players add #mailbox mailbox0076 0
scoreboard players add #mailbox mailbox0077 0
scoreboard players add #mailbox mailbox0078 0
scoreboard players add #mailbox mailbox0079 0
scoreboard players add #mailbox mailbox0080 0
scoreboard players add #mailbox mailbox0081 0
scoreboard players add #mailbox mailbox0082 0
scoreboard players add #mailbox mailbox0083 0
scoreboard players add #mailbox mailbox0084 0
scoreboard players add #mailbox mailbox0085 0
scoreboard players add #mailbox mailbox0086 0
scoreboard players add #mailbox mailbox0087 0
scoreboard players add #mailbox mailbox0088 0
scoreboard players add #mailbox mailbox0089 0
scoreboard players add #mailbox mailbox0090 0
scoreboard players add #mailbox mailbox0091 0
scoreboard players add #mailbox mailbox0092 0
scoreboard players add #mailbox mailbox0093 0
scoreboard players add #mailbox mailbox0094 0
scoreboard players add #mailbox mailbox0095 0
scoreboard players add #mailbox mailbox0096 0
scoreboard players add #mailbox mailbox0097 0
scoreboard players add #mailbox mailbox0098 0
scoreboard players add #mailbox mailbox0099 0
scoreboard players add #mailbox mailbox0100 0
scoreboard players add #mailbox mailbox0101 0
scoreboard players add #mailbox mailbox0102 0
scoreboard players add #mailbox mailbox0103 0
scoreboard players add #mailbox mailbox0104 0
scoreboard players add #mailbox mailbox0105 0
scoreboard players add #mailbox mailbox0106 0
scoreboard players add #mailbox mailbox0107 0
scoreboard players add #mailbox mailbox0108 0
scoreboard players add #mailbox mailbox0109 0
scoreboard players add #mailbox mailbox0110 0
scoreboard players add #mailbox mailbox0111 0
scoreboard players add #mailbox mailbox0112 0
scoreboard players add #mailbox mailbox0113 0
scoreboard players add #mailbox mailbox0114 0
scoreboard players add #mailbox mailbox0115 0
scoreboard players add #mailbox mailbox0116 0
scoreboard players add #mailbox mailbox0117 0
scoreboard players add #mailbox mailbox0118 0
scoreboard players add #mailbox mailbox0119 0
scoreboard players add #mailbox mailbox0120 0
scoreboard players add #mailbox mailbox0121 0
scoreboard players add #mailbox mailbox0122 0
scoreboard players add #mailbox mailbox0123 0
scoreboard players add #mailbox mailbox0124 0
scoreboard players add #mailbox mailbox0125 0
scoreboard players add #mailbox mailbox0126 0
scoreboard players add #mailbox mailbox0127 0
scoreboard players add #mailbox mailbox0128 0
scoreboard players add #mailbox mailbox0129 0
scoreboard players add #mailbox mailbox0130 0
scoreboard players add #mailbox mailbox0131 0
scoreboard players add #mailbox mailbox0132 0
scoreboard players add #mailbox mailbox0133 0
scoreboard players add #mailbox mailbox0134 0
scoreboard players add #mailbox mailbox0135 0
scoreboard players add #mailbox mailbox0136 0
scoreboard players add #mailbox mailbox0137 0
scoreboard players add #mailbox mailbox0138 0
scoreboard players add #mailbox mailbox0139 0
scoreboard players add #mailbox mailbox0140 0
scoreboard players add #mailbox mailbox0141 0
scoreboard players add #mailbox mailbox0142 0
scoreboard players add #mailbox mailbox0143 0
scoreboard players add #mailbox mailbox0144 0
scoreboard players add #mailbox mailbox0145 0
scoreboard players add #mailbox mailbox0146 0
scoreboard players add #mailbox mailbox0147 0
scoreboard players add #mailbox mailbox0148 0
scoreboard players add #mailbox mailbox0149 0
scoreboard players add #mailbox mailbox0150 0
scoreboard players add #mailbox mailbox0151 0
scoreboard players add #mailbox mailbox0152 0
scoreboard players add #mailbox mailbox0153 0
scoreboard players add #mailbox mailbox0154 0
scoreboard players add #mailbox mailbox0155 0
scoreboard players add #mailbox mailbox0156 0
scoreboard players add #mailbox mailbox0157 0
scoreboard players add #mailbox mailbox0158 0
scoreboard players add #mailbox mailbox0159 0
scoreboard players add #mailbox mailbox0160 0
scoreboard players add #mailbox mailbox0171 0
scoreboard players add #mailbox mailbox0172 0
scoreboard players add #mailbox mailbox0173 0
scoreboard players add #mailbox mailbox0174 0
scoreboard players add #mailbox mailbox0175 0
scoreboard players add #mailbox mailbox0176 0
scoreboard players add #mailbox mailbox0177 0
scoreboard players add #mailbox mailbox0178 0
scoreboard players add #mailbox mailbox0179 0
scoreboard players add #mailbox mailbox0180 0
scoreboard players add #mailbox mailbox0181 0
scoreboard players add #mailbox mailbox0182 0
scoreboard players add #mailbox mailbox0183 0
scoreboard players add #mailbox mailbox0184 0
scoreboard players add #mailbox mailbox0185 0
scoreboard players add #mailbox mailbox0186 0
scoreboard players add #mailbox mailbox0187 0
scoreboard players add #mailbox mailbox0188 0
scoreboard players add #mailbox mailbox0189 0
scoreboard players add #mailbox mailbox0190 0
scoreboard players add #mailbox mailbox0191 0
scoreboard players add #mailbox mailbox0192 0
scoreboard players add #mailbox mailbox0193 0
scoreboard players add #mailbox mailbox0194 0
scoreboard players add #mailbox mailbox0195 0
scoreboard players add #mailbox mailbox0196 0
scoreboard players add #mailbox mailbox0197 0
scoreboard players add #mailbox mailbox0198 0
scoreboard players add #mailbox mailbox0199 0
scoreboard players add #mailbox mailbox0200 0
scoreboard players add #mailbox mailbox0201 0
scoreboard players add #mailbox mailbox0202 0
scoreboard players add #mailbox mailbox0203 0
scoreboard players add #mailbox mailbox0204 0
scoreboard players add #mailbox mailbox0205 0
scoreboard players add #mailbox mailbox0206 0
scoreboard players add #mailbox mailbox0207 0
scoreboard players add #mailbox mailbox0208 0
scoreboard players add #mailbox mailbox0209 0
scoreboard players add #mailbox mailbox0210 0
scoreboard players add #mailbox mailbox0211 0
scoreboard players add #mailbox mailbox0212 0
scoreboard players add #mailbox mailbox0213 0
scoreboard players add #mailbox mailbox0214 0
scoreboard players add #mailbox mailbox0215 0
scoreboard players add #mailbox mailbox0216 0
scoreboard players add #mailbox mailbox0217 0
scoreboard players add #mailbox mailbox0218 0
scoreboard players add #mailbox mailbox0219 0
scoreboard players add #mailbox mailbox0220 0
scoreboard players add #mailbox mailbox0221 0
scoreboard players add #mailbox mailbox0222 0
scoreboard players add #mailbox mailbox0223 0
scoreboard players add #mailbox mailbox0224 0
scoreboard players add #mailbox mailbox0225 0
scoreboard players add #mailbox mailbox0226 0
scoreboard players add #mailbox mailbox0227 0
scoreboard players add #mailbox mailbox0228 0
scoreboard players add #mailbox mailbox0229 0
scoreboard players add #mailbox mailbox0230 0
scoreboard players add #mailbox mailbox0231 0
scoreboard players add #mailbox mailbox0232 0
scoreboard players add #mailbox mailbox0233 0
scoreboard players add #mailbox mailbox0234 0
scoreboard players add #mailbox mailbox0235 0
scoreboard players add #mailbox mailbox0236 0
scoreboard players add #mailbox mailbox0237 0
scoreboard players add #mailbox mailbox0238 0
scoreboard players add #mailbox mailbox0239 0
scoreboard players add #mailbox mailbox0240 0
scoreboard players add #mailbox mailbox0241 0
scoreboard players add #mailbox mailbox0242 0
scoreboard players add #mailbox mailbox0243 0
scoreboard players add #mailbox mailbox0244 0
scoreboard players add #mailbox mailbox0245 0
scoreboard players add #mailbox mailbox0246 0
scoreboard players add #mailbox mailbox0247 0
scoreboard players add #mailbox mailbox0248 0
scoreboard players add #mailbox mailbox0249 0
scoreboard players add #mailbox mailbox0250 0
scoreboard players add #mailbox mailbox0251 0
scoreboard players add #mailbox mailbox0252 0
scoreboard players add #mailbox mailbox0253 0
scoreboard players add #mailbox mailbox0254 0
scoreboard players add #mailbox mailbox0255 0
scoreboard players add #mailbox mailbox0256 0
scoreboard players add #mailbox mailbox0257 0
scoreboard players add #mailbox mailbox0258 0
scoreboard players add #mailbox mailbox0259 0
scoreboard players add #mailbox mailbox0260 0
scoreboard players add #mailbox mailbox0271 0
scoreboard players add #mailbox mailbox0272 0
scoreboard players add #mailbox mailbox0273 0
scoreboard players add #mailbox mailbox0274 0
scoreboard players add #mailbox mailbox0275 0
scoreboard players add #mailbox mailbox0276 0
scoreboard players add #mailbox mailbox0277 0
scoreboard players add #mailbox mailbox0278 0
scoreboard players add #mailbox mailbox0279 0
scoreboard players add #mailbox mailbox0280 0
scoreboard players add #mailbox mailbox0281 0
scoreboard players add #mailbox mailbox0282 0
scoreboard players add #mailbox mailbox0283 0
scoreboard players add #mailbox mailbox0284 0
scoreboard players add #mailbox mailbox0285 0
scoreboard players add #mailbox mailbox0286 0
scoreboard players add #mailbox mailbox0287 0
scoreboard players add #mailbox mailbox0288 0
scoreboard players add #mailbox mailbox0289 0
scoreboard players add #mailbox mailbox0290 0
scoreboard players add #mailbox mailbox0291 0
scoreboard players add #mailbox mailbox0292 0
scoreboard players add #mailbox mailbox0293 0
scoreboard players add #mailbox mailbox0294 0
scoreboard players add #mailbox mailbox0295 0
scoreboard players add #mailbox mailbox0296 0
scoreboard players add #mailbox mailbox0297 0
scoreboard players add #mailbox mailbox0298 0
scoreboard players add #mailbox mailbox0299 0
scoreboard players add #mailbox mailbox0300 0