# Player wants to buy farmer stock
# Format: /trigger buyFarmerStock set <shares>
say buy
# Store requested amount
scoreboard players operation @s tradeAmount = @s buyFarmerStock

# Calculate total cost (price * shares * 1.05 for commission)
scoreboard players operation @s tradeCost = #farmerStock farmerStockPrice
scoreboard players operation @s tradeCost *= @s tradeAmount
scoreboard players operation @s commission = @s tradeCost
scoreboard players set @s stockTemp 20
scoreboard players operation @s commission /= @s stockTemp
scoreboard players operation @s tradeCost += @s commission

# Check if player has enough money
execute if score @s money >= @s tradeCost run scoreboard players operation @s money -= @s tradeCost
execute if score @s money >= @s tradeCost run scoreboard players operation @s farmerShares += @s tradeAmount
execute if score @s money >= @s tradeCost run scoreboard players operation #cityBank cityBank += @s commission
execute if score @s money >= @s tradeCost run scoreboard players operation #farmerStock farmerBuyPressure += @s tradeAmount
execute if score @s money >= @s tradeCost run tellraw @s [{"text":"✓ Bought ","color":"green"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" Farmer shares for $","color":"green"},{"score":{"name":"@s","objective":"tradeCost"},"color":"white"},{"text":" (includes $","color":"gray"},{"score":{"name":"@s","objective":"commission"},"color":"white"},{"text":" commission)","color":"gray"}]

# Enhanced insufficient funds message with details
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"✗ Insufficient funds!","color":"red"}]
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"Stock Price: $","color":"yellow"},{"score":{"name":"#farmerStock","objective":"farmerStockPrice"},"color":"white"},{"text":" per share","color":"yellow"}]
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"Cost for ","color":"yellow"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" shares: $","color":"yellow"},{"score":{"name":"@s","objective":"tradeCost"},"color":"white"}]
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"Your balance: $","color":"yellow"},{"score":{"name":"@s","objective":"money"},"color":"white"}]
execute unless score @s money >= @s tradeCost run scoreboard players operation @s shareValue = @s tradeCost
execute unless score @s money >= @s tradeCost run scoreboard players operation @s shareValue -= @s money
execute unless score @s money >= @s tradeCost run tellraw @s [{"text":"You need $","color":"red"},{"score":{"name":"@s","objective":"shareValue"},"color":"white"},{"text":" more!","color":"red"}]

# Reset trigger
scoreboard players set @s buyFarmerStock 0
scoreboard players enable @s buyFarmerStock