# Check if lottery price is set, if not use a default
execute unless score #global lottery.price matches 1.. run scoreboard players set #global lottery.price 100

# Always use the global price, ignore what player set
scoreboard players operation @s lottery.bet_amount = #global lottery.price

# Check if player has enough money
execute if score @s money < @s lottery.bet_amount run tellraw @s [{"text":"Insufficient funds! Lottery tickets cost "},{"score":{"name":"#global","objective":"lottery.price"},"color":"green"},{"text":" money."}]
execute if score @s money < @s lottery.bet_amount run scoreboard players set @s lotteryBet 0
execute if score @s money < @s lottery.bet_amount run return 1

# Deduct money
scoreboard players operation @s money -= @s lottery.bet_amount

# Show current jackpot
tellraw @s {"text":"=== LOTTERY TICKET ===","color":"gold","bold":true}
tellraw @s [{"text":"You bought a ticket for "},{"score":{"name":"@s","objective":"lottery.bet_amount"},"color":"green"},{"text":" money!"}]
tellraw @s [{"text":"Current Jackpot: "},{"score":{"name":"#global","objective":"jackpot"},"color":"yellow","bold":true}]
tellraw @s {"text":"Scratching ticket...","color":"aqua"}

# Generate random outcome (1-100)
execute store result score @s lottery.outcome run random value 1..100

# Process result after a short delay
scoreboard players set @s lottery.reveal_timer 40
scoreboard players set @s lottery.active 1

# Reset trigger
scoreboard players set @s lotteryBet 0