# ===== NEW PLAYER SETUP =====
# Initialize new players with starting money and job
execute as @a unless score @s Job matches 1.. run function economy:jobs/general/assign_worker
execute as @a unless score @s money matches 0.. run function economy:preprocessing/startup_tasks
execute as @a unless score @s lastPaycheck matches 0.. run scoreboard players set @s lastPaycheck 0
execute as @a unless score @s chunksOwned matches 0.. run scoreboard players set @s chunksOwned 0
scoreboard players add @a temp 0
# Enable pay trigger for all players
scoreboard players enable @a pay
scoreboard players enable @a buyFarmerStock
scoreboard players enable @a sellFarmerStock
scoreboard players enable @a buyMinerStock
scoreboard players enable @a sellMinerStock
scoreboard players enable @a buyRancherStock
scoreboard players enable @a sellRancherStock
scoreboard players enable @a buyHunterStock
scoreboard players enable @a sellHunterStock
scoreboard players enable @a buyFisherStock
scoreboard players enable @a sellFisherStock
scoreboard players enable @a buyBlacksmithStock
scoreboard players enable @a sellBlacksmithStock
scoreboard players enable @a buyLumberStock
scoreboard players enable @a sellLumberStock
scoreboard players enable @a buyCookStock
scoreboard players enable @a sellCookStock
scoreboard players enable @a buyArcherStock
scoreboard players enable @a sellArcherStock
scoreboard players enable @a buyWarriorStock
scoreboard players enable @a sellWarriorStock
scoreboard players enable @a buyEnchanterStock
scoreboard players enable @a sellEnchanterStock
scoreboard players enable @a buyAlchemyStock
scoreboard players enable @a sellAlchemyStock
scoreboard players enable @a checkShares
scoreboard players enable @a checkMarketShares
scoreboard players enable @a levelCheck
# Enable share transfer triggers
scoreboard players enable @a giveFarmerShares
scoreboard players enable @a giveMinerShares
scoreboard players enable @a giveRancherShares
scoreboard players enable @a giveHunterShares
scoreboard players enable @a giveFisherShares
scoreboard players enable @a giveBlacksmithShares
scoreboard players enable @a giveLumberShares
scoreboard players enable @a giveCookShares
scoreboard players enable @a giveArcherShares
scoreboard players enable @a giveWarriorShares
scoreboard players enable @a giveAlchemyShares
scoreboard players enable @a giveEnchanterShares
# Enable mailbox triggers
scoreboard players enable @a mailboxCreate
scoreboard players enable @a mailCheck
scoreboard players enable @a mailSend
scoreboard players enable @a sendMoney
scoreboard players enable @a mailClaim
# Diamond and Emerald banking (only if enabled)
execute if score #global diamondBankEnabled matches 1 run scoreboard players enable @a withdrawDiamonds
execute if score #global diamondBankEnabled matches 1 run scoreboard players enable @a depositDiamonds
execute if score #global emeraldBankEnabled matches 1 run scoreboard players enable @a withdrawEmeralds
execute if score #global emeraldBankEnabled matches 1 run scoreboard players enable @a depositEmeralds
execute if score #global lotteryEnabled matches 1 run scoreboard players enable @s lotteryBet
execute if score #global lotteryEnabled matches 1 run scoreboard players enable @a lotteryBetx5
execute if score #global blackjackEnabled matches 1 run scoreboard players enable @a blackjackStart
execute if score #global blackjackEnabled matches 1 run scoreboard players enable @a blackjackChallenge
execute if score #global blackjackEnabled matches 1 run scoreboard players enable @a blackjackAccept
execute if score #global blackjackEnabled matches 1 run scoreboard players enable @a blackjackDecline
execute if score #global blackjackEnabled matches 1 run scoreboard players enable @a bestOf3
# Enable when system raffle is active
execute if score #global raffleActive matches 1 run scoreboard players enable @a buyRaffleTickets
execute if score #global raffleActive matches 1 run scoreboard players enable @a checkMyTickets
# Reset mailboxes for players whose mailboxReset doesn't match global
execute as @a[scores={mailboxNumber=1..}] unless score @s mailboxReset = #global mailboxReset run function economy:mailbox/reset_player
# Enable shares owned check trigger
execute as @a[scores={checkMyShares=1..}] run function economy:stock_market/check_shares
# Process active lottery tickets
execute as @a run function economy:core/tick_games/lottery_tick
# Handle lottery initialization
execute as @a[scores={lotteryBet=1..}] run function economy:games/lottery/initialize
execute as @a[scores={lotteryBetx5=1..}] run function economy:games/lottery/initialize_x5
# ===== BLACKJACK SYSTEM =====
execute as @a[scores={bestOf3=1..}] run function economy:games/blackjack/toggle_best_of_3
execute as @a[scores={blackjackChallenge=1..}] run function economy:games/blackjack/challenge_player
execute as @a[scores={blackjackAccept=1..}] run function economy:games/blackjack/accept_challenge
execute as @a[scores={blackjackDecline=1..}] run function economy:games/blackjack/decline_challenge
execute as @a[scores={blackjackStart=1..,blackjack.game_phase=0}] run function economy:games/blackjack/initialize
execute as @a[scores={blackjackStart=1..}] run function economy:core/tick_games/blackjack_tick
# Player Raffle Functions
execute as @a[scores={buyRaffleTickets=1..}] run function economy:events/raffle/buy_tickets
execute as @a[scores={checkMyTickets=1..}] run function economy:events/raffle/check_my_tickets
# Process mailbox triggers
execute as @a[scores={mailboxCreate=1..}] run function economy:mailbox/create_mailbox
execute as @a[scores={mailCheck=1..}] run function economy:mailbox/check_mail
execute as @a[scores={mailSend=1..}] run function economy:mailbox/send_to_mailbox
execute as @a[scores={sendMoney=1..}] run function economy:mailbox/send_money
execute as @a[scores={mailClaim=1..}] run function economy:mailbox/claim_mail
# Process buy/sell triggers
execute as @a[scores={buyFarmerStock=1..}] run function economy:stock_market/buy/farmer_stock
execute as @a[scores={sellFarmerStock=1..}] run function economy:stock_market/sell/farmer_stock
execute as @a[scores={buyMinerStock=1..}] run function economy:stock_market/buy/miner_stock
execute as @a[scores={sellMinerStock=1..}] run function economy:stock_market/sell/miner_stock
execute as @a[scores={buyRancherStock=1..}] run function economy:stock_market/buy/rancher_stock
execute as @a[scores={sellRancherStock=1..}] run function economy:stock_market/sell/rancher_stock
execute as @a[scores={buyHunterStock=1..}] run function economy:stock_market/buy/hunter_stock
execute as @a[scores={sellHunterStock=1..}] run function economy:stock_market/sell/hunter_stock
execute as @a[scores={buyFisherStock=1..}] run function economy:stock_market/buy/fisher_stock
execute as @a[scores={sellFisherStock=1..}] run function economy:stock_market/sell/fisher_stock
execute as @a[scores={buyBlacksmithStock=1..}] run function economy:stock_market/buy/blacksmith_stock
execute as @a[scores={sellBlacksmithStock=1..}] run function economy:stock_market/sell/blacksmith_stock
execute as @a[scores={buyLumberStock=1..}] run function economy:stock_market/buy/lumber_stock
execute as @a[scores={sellLumberStock=1..}] run function economy:stock_market/sell/lumber_stock
execute as @a[scores={buyCookStock=1..}] run function economy:stock_market/buy/cook_stock
execute as @a[scores={sellCookStock=1..}] run function economy:stock_market/sell/cook_stock
execute as @a[scores={buyArcherStock=1..}] run function economy:stock_market/buy/archer_stock
execute as @a[scores={sellArcherStock=1..}] run function economy:stock_market/sell/archer_stock
execute as @a[scores={buyWarriorStock=1..}] run function economy:stock_market/buy/warrior_stock
execute as @a[scores={sellWarriorStock=1..}] run function economy:stock_market/sell/warrior_stock
execute as @a[scores={checkShares=1..}] run function economy:stock_market/check_shares
execute as @a[scores={checkMarketShares=1..}] run function economy:stock_market/check_market_shares
execute as @a[scores={buyEnchanterStock=1..}] run function economy:stock_market/buy/enchanter_stock
execute as @a[scores={sellEnchanterStock=1..}] run function economy:stock_market/sell/enchanter_stock
execute as @a[scores={buyAlchemyStock=1..}] run function economy:stock_market/buy/alchemy_stock
execute as @a[scores={sellAlchemyStock=1..}] run function economy:stock_market/sell/alchemy_stock
execute as @a[scores={giveFarmerShares=1..}] run function economy:stock_market/give/farmer_shares
execute as @a[scores={giveMinerShares=1..}] run function economy:stock_market/give/miner_shares
execute as @a[scores={giveRancherShares=1..}] run function economy:stock_market/give/rancher_shares
execute as @a[scores={giveHunterShares=1..}] run function economy:stock_market/give/hunter_shares
execute as @a[scores={giveFisherShares=1..}] run function economy:stock_market/give/fisher_shares
execute as @a[scores={giveBlacksmithShares=1..}] run function economy:stock_market/give/blacksmith_shares
execute as @a[scores={giveLumberShares=1..}] run function economy:stock_market/give/lumber_shares
execute as @a[scores={giveCookShares=1..}] run function economy:stock_market/give/cook_shares
execute as @a[scores={giveArcherShares=1..}] run function economy:stock_market/give/archer_shares
execute as @a[scores={giveWarriorShares=1..}] run function economy:stock_market/give/warrior_shares
execute as @a[scores={giveEnchanterShares=1..}] run function economy:stock_market/give/enchanter_shares
execute as @a[scores={giveAlchemyShares=1..}] run function economy:stock_market/give/alchemy_shares
# Handle /trigger pay set (transfers to closest player within 5 blocks, with balance check)
execute as @a[scores={pay=1..}] run function economy:utilities/pay/pay
scoreboard players set @a[scores={pay=1..}] pay 0
# Prevent negative balance
execute as @a[scores={money=..-1}] run scoreboard players set @s money 0
# Process triggers immediately when they're set
execute as @a[scores={withdrawEmeralds=1..}] run function economy:banking/withdraw_emeralds
execute as @a[scores={withdrawDiamonds=1..}] at @s run function economy:banking/withdraw_diamonds
# Process emerald deposits
execute as @a[scores={depositEmeralds=1..}] run function economy:banking/deposit_emeralds
execute as @a[scores={depositDiamonds=1..}] run function economy:banking/deposit_diamonds
# Enable triggers
execute as @a[scores={Job=1}] run function economy:core/tick_jobs/worker_tick
execute as @a[scores={Job=2}] run function economy:core/tick_jobs/realtor_tick
execute as @a[scores={TreasurerJob=1}] run function economy:core/tick_jobs/treasurer_tick
# 1 Second Timer
scoreboard players add @a kheco_timer 1
execute as @a[scores={kheco_timer=20..}] run scoreboard players set @s kheco_timer 0
# Process level check trigger
execute as @a[scores={levelCheck=1..}] run function economy:utilities/display/show_levels
# Startup Tasks
execute if score #startup startupFlag matches 0..99 run function economy:preprocessing/startup_tasks
execute store result score #currentTick dummy run time query gametime
execute store result score #tickMod dummy run scoreboard players get #currentTick dummy
scoreboard players operation #tickMod dummy %= #20 dummy
execute as @a[scores={Job=1,ranchCooldown=1..}] if score #tickMod dummy matches 0 run scoreboard players remove @s ranchCooldown 10
# Track animal breeding for XP (separate from harvest)
execute as @a[scores={Job=1,animalsBred=1..}] run function economy:preprocessing/animals_bred
# Optimized meat pickup system
execute as @a[scores={Job=1,pickupBeef=1..,cowsKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_beef
execute as @a[scores={Job=1,pickupMutton=1..,sheepKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_mutton
execute as @a[scores={Job=1,pickupPork=1..,pigsKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_pork
execute as @a[scores={Job=1,pickupChicken=1..,chickensKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_chicken
execute as @a[scores={Job=1,pickupRawRabbit=1..,rabbitsKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_rabbit_meat
execute as @a[scores={Job=1,pickupRabbitHide=1..,rabbitsKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_rabbit_hide
execute as @a[scores={Job=1,pickupRabbitFoot=1..,rabbitsKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_rabbit_foot
execute as @a[scores={Job=1,pickupRabbitFoot=1..,rabbitsKilled=1..,ranchCooldown=0}] run function economy:jobs/rancher/process_goat_horn
# Sheep shearing detection (adds to sheepShear counter)
function economy:jobs/rancher/sheep_shearing_detector
# Process wool groups of 3 for payment (after daily processing)
execute as @a[scores={Job=1,woolCount=3..,ranchCooldown=0}] run function economy:preprocessing/wool_process
# Reduce ranch cooldown by 1 every tick (200 ticks = 10 seconds total)
execute as @a[scores={ranchCooldown=1..}] run scoreboard players remove @s ranchCooldown 1
# ===== FISHING SYSTEM =====
execute as @a[scores={Job=1,fishingRodUsed=1..,codCaught=1..}] run function economy:jobs/fisherman/caught_fish
execute as @a[scores={Job=1,fishingRodUsed=1..,salmonCaught=1..}] run function economy:jobs/fisherman/caught_fish
execute as @a[scores={Job=1,fishingRodUsed=1..,pufferfishCaught=1..}] run function economy:jobs/fisherman/caught_fish
execute as @a[scores={Job=1,fishingRodUsed=1..,tropicalFishCaught=1..}] run function economy:jobs/fisherman/caught_fish
# ===== LUMBER SYSTEM =====
execute as @a[scores={Job=1,kheco_timer=0,pickupoakLog=1..,logs_broken_oak=1..}] run function economy:jobs/lumber/process_oak_logs
execute as @a[scores={Job=1,kheco_timer=0,pickupbirchLog=1..,logs_broken_birch=1..}] run function economy:jobs/lumber/process_birch_logs
execute as @a[scores={Job=1,kheco_timer=0,pickupacaciaLog=1..,logs_broken_acacia=1..}] run function economy:jobs/lumber/process_acacia_logs
execute as @a[scores={Job=1,kheco_timer=0,pickupcherryLog=1..,logs_broken_cherry=1..}] run function economy:jobs/lumber/process_cherry_logs
execute as @a[scores={Job=1,kheco_timer=0,pickupdark_oakLog=1..,logs_broken_dark_oak=1..}] run function economy:jobs/lumber/process_dark_oak_logs
execute as @a[scores={Job=1,kheco_timer=0,pickuppale_oakLog=1..,logs_broken_pale_oak=1..}] run function economy:jobs/lumber/process_pale_oak_logs
execute as @a[scores={Job=1,kheco_timer=0,pickupmangroveLog=1..,logs_broken_mangrove=1..}] run function economy:jobs/lumber/process_mangrove_logs
execute as @a[scores={Job=1,kheco_timer=0,pickupjungleLog=1..,logs_broken_jungle=1..}] run function economy:jobs/lumber/process_jungle_logs
execute as @a[scores={Job=1,kheco_timer=0,pickupspruceLog=1..,logs_broken_spruce=1..}] run function economy:jobs/lumber/process_spruce_logs
# ===== FARMER SYSTEM =====
execute as @a[scores={Job=1,pickupWheat=1..,brokenWheat=1..}] run function economy:jobs/farmer/process_wheat
execute as @a[scores={Job=1,pickupPotato=1..,brokenPotatoes=1..}] run function economy:jobs/farmer/process_potato
execute as @a[scores={Job=1,pickupCarrot=1..,brokenCarrots=1..}] run function economy:jobs/farmer/process_carrot
execute as @a[scores={Job=1,pickupBeetroot=1..,brokenBeetroots=1..}] run function economy:jobs/farmer/process_beetroot
execute as @a[scores={Job=1,kheco_timer=0,pickupPumpkin=1..,brokenPumpkins=1..}] run function economy:jobs/farmer/process_pumpkin
execute as @a[scores={Job=1,pickupMelonSlice=1..,brokenMelons=1..}] run function economy:jobs/farmer/process_melon
# ===== MINER SYSTEM =====
execute as @a[scores={Job=1,kheco_timer=5,pickupCoal=1..,brokenCoal=1..}] run function economy:jobs/miner/process_coal
execute as @a[scores={Job=1,kheco_timer=5,pickupIron=1..,brokenIron=1..}] run function economy:jobs/miner/process_iron_ore
execute as @a[scores={Job=1,kheco_timer=5,pickupGold=1..,brokenGold=1..}] run function economy:jobs/miner/process_gold_ore
execute as @a[scores={Job=1,kheco_timer=5,pickupDiamond=1..,brokenDiamond=1..}] run function economy:jobs/miner/process_diamond
execute as @a[scores={Job=1,kheco_timer=5,brokenEmerald=1..}] run function economy:jobs/miner/process_emerald
execute as @a[scores={Job=1,kheco_timer=5,brokenLapis=1..}] run function economy:jobs/miner/process_lapis
execute as @a[scores={Job=1,kheco_timer=5,brokenRedstone=1..}] run function economy:jobs/miner/process_redstone
execute as @a[scores={Job=1,kheco_timer=5,brokenCopper=1..}] run function economy:jobs/miner/process_copper_ore
# Nether ores (with timer check)
execute as @a[scores={Job=1,kheco_timer=5,pickupGoldNugget=1..,brokenNetherGold=1..}] run function economy:jobs/miner/process_nether_gold
execute as @a[scores={Job=1,kheco_timer=5,pickupQuartz=1..,brokenNetherQuartz=1..}] run function economy:jobs/miner/process_nether_quartz
# Ancient debris (with timer check)
execute as @a[scores={Job=1,kheco_timer=5,pickupAncientDebris=1..,brokenAncientDebris=1..}] run function economy:jobs/miner/process_ancient_debris
# Deepslate ores (with timer check)
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepCoal=1..}] run function economy:jobs/miner/process_deep_coal
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepIron=1..}] run function economy:jobs/miner/process_deep_iron
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepGold=1..}] run function economy:jobs/miner/process_deep_gold
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepDiamond=1..}] run function economy:jobs/miner/process_deep_diamond
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepEmerald=1..}] run function economy:jobs/miner/process_deep_emerald
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepLapis=1..}] run function economy:jobs/miner/process_deep_lapis
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepRedstone=1..}] run function economy:jobs/miner/process_deep_redstone
execute as @a[scores={Job=1,kheco_timer=5,brokenDeepCopper=1..}] run function economy:jobs/miner/process_deep_copper
# Egg pickup (when timer is 10)
execute as @a[scores={Job=1,pickupEgg=1..,kheco_timer=10}] run function economy:jobs/rancher/process_egg
execute as @a[scores={Job=1,pickupBrownEgg=1..,kheco_timer=10}] run function economy:jobs/rancher/process_egg
execute as @a[scores={Job=1,pickupBlueEgg=1..,kheco_timer=10}] run function economy:jobs/rancher/process_egg
# Daily preprocessing calculations
execute store result score #currentTick dummy run time query daytime
execute if score #currentTick dummy matches 11800..11900 unless score #preprocessFlag preprocessFlag matches 1 run function economy:preprocessing/daily_calculations
execute if score #currentTick dummy matches 11901.. run scoreboard players set #preprocessFlag preprocessFlag 0
# Handle price setting trigger
execute as @a[scores={setPrice=1..}] run function economy:jobs/realtor/set_chunk_price
# Stock market trading updates every 200 ticks
scoreboard players add #stockTimer stockUpdateTimer 1
# Get current time to avoid sunset period
execute store result score #currentTime dummy run time query daytime
execute if score #stockTimer stockUpdateTimer matches 1200.. unless score #currentTime dummy matches 11500..13000 run function economy:preprocessing/minute_flag
execute if score #stockTimer stockUpdateTimer matches 1200.. run scoreboard players set #stockTimer stockUpdateTimer 0
# Accumulate daily XP for stocks (just before sunset at 11999)
execute if score #currentTime dummy matches 11999 run function economy:stock_market/accumulate_daily_xp
# Update stock prices after payments (at 12100)
execute if score #currentTime dummy matches 12100 run function economy:stock_market/update_prices
execute store result score #currentTime dummy run time query daytime
execute if score #currentTime dummy matches 0..100 unless score #trendApplied dummy matches 1 run function economy:stock_market/trends/daily_trend_update
execute if score #currentTime dummy matches 101.. run scoreboard players set #trendApplied dummy 0
# Update individual sidebar display every 60 ticks (3 seconds)
execute if score #currentTime dummy matches 0..23999 run function economy:utilities/display/individual_sidebar
# Pay workers at sunset (only once per day)
execute if score #currentTime dummy matches 12000..13000 if score workerPayFlag workerPayFlag matches 0 run function economy:preprocessing/sunset_flag
# Update stock prices after payments (at 12100)
execute if score #currentTime dummy matches 12100 run function economy:stock_market/update_prices
execute if score #currentTime dummy matches 12200 if score #global eventActive matches 1 run function economy:preprocessing/sunset_flag_two
# Reset flags at dawn
execute if score #currentTime dummy matches 0..11999 run function economy:preprocessing/new_day