# Send money to mailbox based on stored mailTemp value
# First, check if the mailbox is owned by anyone

# Set a flag to track if mailbox is owned
scoreboard players set @s mailboxOwned 0

# Check each player to see if they own the target mailbox number
execute as @a if score @s mailboxNumber = @p[scores={sendMoney=1..}] mailTemp run scoreboard players set @p[scores={sendMoney=1..}] mailboxOwned 1

# If mailbox is not owned, send error message
execute if score @s mailboxOwned matches 0 run tellraw @s [{"text":"✗ Mailbox #","color":"red"},{"score":{"name":"@s","objective":"mailTemp"},"color":"white"},{"text":" is not owned by anyone!","color":"red"}]
execute if score @s mailboxOwned matches 0 run scoreboard players set @s sendMoney 0
execute if score @s mailboxOwned matches 0 run scoreboard players set @s mailTemp 0
execute if score @s mailboxOwned matches 0 run scoreboard players enable @s sendMoney
execute if score @s mailboxOwned matches 0 run return 0

# If we get here, mailbox is owned - proceed with transfer
execute if score @s mailTemp matches 1 if score @s money >= @s sendMoney run scoreboard players operation #mailbox mailbox0001 += @s sendMoney
execute if score @s mailTemp matches 1 if score @s money >= @s sendMoney run scoreboard players operation @s money -= @s sendMoney
execute if score @s mailTemp matches 1 if score @s money >= @s sendMoney run tellraw @s [{"text":"Sent $","color":"green"},{"score":{"name":"@s","objective":"sendMoney"},"color":"white"},{"text":" to mailbox 1","color":"green"}]

# Continue for mailbox 2-300...
# (You'll repeat the pattern above for each mailbox)

# Error message if insufficient funds
execute if score @s money < @s sendMoney run tellraw @s {"text":"Insufficient funds!","color":"red"}

# Error message if invalid mailbox number
execute if score @s mailTemp matches 301.. run tellraw @s {"text":"Invalid mailbox number!","color":"red"}
execute if score @s mailTemp matches ..0 run tellraw @s {"text":"Invalid mailbox number!","color":"red"}

# Reset trigger
scoreboard players set @s sendMoney 0
scoreboard players set @s mailTemp 0
scoreboard players enable @s sendMoney