# Apply minor event change to Blacksmith stock based on price brackets

# Store old price for comparison
scoreboard players operation #oldPrice dummy = #blacksmithStock blacksmithStockPrice

# Generate random number 1-10 for positive/negative determination
execute store result score #direction dummy run random value 1..10

# Price bracket: 0-99 (80% positive 5%, 20% negative 1%)
execute if score #blacksmithStock blacksmithStockPrice matches ..99 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/positive_5
execute if score #blacksmithStock blacksmithStockPrice matches ..99 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/negative_1

# Price bracket: 100-199 (60% negative 5%, 40% positive 1%)
execute if score #blacksmithStock blacksmithStockPrice matches 100..199 if score #direction dummy matches 1..6 run function economy:stock_market/events/changes/negative_5
execute if score #blacksmithStock blacksmithStockPrice matches 100..199 if score #direction dummy matches 7..10 run function economy:stock_market/events/changes/positive_5

# Price bracket: 200-299 (70% negative 10%, 30% positive 1%)
execute if score #blacksmithStock blacksmithStockPrice matches 200..299 if score #direction dummy matches 1..7 run function economy:stock_market/events/changes/negative_10
execute if score #blacksmithStock blacksmithStockPrice matches 200..299 if score #direction dummy matches 8..10 run function economy:stock_market/events/changes/positive_1

# Price bracket: 300-399 (80% negative 15%, 20% positive 1%)
execute if score #blacksmithStock blacksmithStockPrice matches 300..399 if score #direction dummy matches 1..8 run function economy:stock_market/events/changes/negative_15
execute if score #blacksmithStock blacksmithStockPrice matches 300..399 if score #direction dummy matches 9..10 run function economy:stock_market/events/changes/positive_1

# Price bracket: 400-499 (90% negative 20%, 10% positive 1%)
execute if score #blacksmithStock blacksmithStockPrice matches 400..499 if score #direction dummy matches 1..9 run function economy:stock_market/events/changes/negative_20
execute if score #blacksmithStock blacksmithStockPrice matches 400..499 if score #direction dummy matches 10 run function economy:stock_market/events/changes/positive_1

# Price bracket: 500 (100% negative 25%)
execute if score #blacksmithStock blacksmithStockPrice matches 500.. run function economy:stock_market/events/changes/negative_25

# Apply the calculated change to the actual price
scoreboard players operation #blacksmithStock blacksmithStockPrice += #priceChange dummy

# Enforce min/max limits
execute if score #blacksmithStock blacksmithStockPrice < #global stockMinPrice run scoreboard players operation #blacksmithStock blacksmithStockPrice = #global stockMinPrice
execute if score #blacksmithStock blacksmithStockPrice > #global stockMaxPrice run scoreboard players operation #blacksmithStock blacksmithStockPrice = #global stockMaxPrice

# Announce the change
execute if score #blacksmithStock blacksmithStockPrice > #oldPrice dummy run tellraw @a [{"text":"  Blacksmith: $","color":"gray"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#blacksmithStock","objective":"blacksmithStockPrice"},"color":"green"},{"text":" ▲","color":"green","bold":true}]
execute if score #blacksmithStock blacksmithStockPrice < #oldPrice dummy run tellraw @a [{"text":"  Blacksmith: $","color":"gray"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#blacksmithStock","objective":"blacksmithStockPrice"},"color":"red"},{"text":" ▼","color":"red","bold":true}]