# Rancher stock news event
# #newsEvent: 1 = +5%, 2 = +10%, 3 = -5%, 4 = -10%

# Store old price
scoreboard players operation #oldPrice dummy = #rancherStock rancherStockPrice

# Event 1: +5%
execute if score #newsEvent dummy matches 1 run tellraw @a [{"text":"📰 NEWS: ","color":"aqua","bold":true},{"text":"Healthy livestock birth rates this season","color":"white"}]
execute if score #newsEvent dummy matches 1 run scoreboard players operation #priceChange dummy = #rancherStock rancherStockPrice
execute if score #newsEvent dummy matches 1 run scoreboard players set #percent dummy 20
execute if score #newsEvent dummy matches 1 run scoreboard players operation #priceChange dummy /= #percent dummy
execute if score #newsEvent dummy matches 1 run scoreboard players operation #rancherStock rancherStockPrice += #priceChange dummy

# Event 2: +10%
execute if score #newsEvent dummy matches 2 run tellraw @a [{"text":"📰 NEWS: ","color":"aqua","bold":true},{"text":"Exotic animal breeding program succeeds","color":"white"}]
execute if score #newsEvent dummy matches 2 run scoreboard players operation #priceChange dummy = #rancherStock rancherStockPrice
execute if score #newsEvent dummy matches 2 run scoreboard players set #percent dummy 10
execute if score #newsEvent dummy matches 2 run scoreboard players operation #priceChange dummy /= #percent dummy
execute if score #newsEvent dummy matches 2 run scoreboard players operation #rancherStock rancherStockPrice += #priceChange dummy

# Event 3: -5%
execute if score #newsEvent dummy matches 3 run tellraw @a [{"text":"📰 NEWS: ","color":"aqua","bold":true},{"text":"Minor livestock illness spreading","color":"white"}]
execute if score #newsEvent dummy matches 3 run scoreboard players operation #priceChange dummy = #rancherStock rancherStockPrice
execute if score #newsEvent dummy matches 3 run scoreboard players set #percent dummy -20
execute if score #newsEvent dummy matches 3 run scoreboard players operation #priceChange dummy /= #percent dummy
execute if score #newsEvent dummy matches 3 run scoreboard players operation #rancherStock rancherStockPrice += #priceChange dummy

# Event 4: -10%
execute if score #newsEvent dummy matches 4 run tellraw @a [{"text":"📰 NEWS: ","color":"aqua","bold":true},{"text":"Disease outbreak threatens animal populations","color":"white"}]
execute if score #newsEvent dummy matches 4 run scoreboard players operation #priceChange dummy = #rancherStock rancherStockPrice
execute if score #newsEvent dummy matches 4 run scoreboard players set #percent dummy -10
execute if score #newsEvent dummy matches 4 run scoreboard players operation #priceChange dummy /= #percent dummy
execute if score #newsEvent dummy matches 4 run scoreboard players operation #rancherStock rancherStockPrice += #priceChange dummy

# Enforce min/max limits
execute if score #rancherStock rancherStockPrice < #global stockMinPrice run scoreboard players operation #rancherStock rancherStockPrice = #global stockMinPrice
execute if score #rancherStock rancherStockPrice > #global stockMaxPrice run scoreboard players operation #rancherStock rancherStockPrice = #global stockMaxPrice

# Announce the change
execute if score #rancherStock rancherStockPrice > #oldPrice dummy run tellraw @a [{"text":"  Rancher Stock: $","color":"gold"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#rancherStock","objective":"rancherStockPrice"},"color":"green"},{"text":" ▲","color":"green","bold":true}]
execute if score #rancherStock rancherStockPrice < #oldPrice dummy run tellraw @a [{"text":"  Rancher Stock: $","color":"gold"},{"score":{"name":"#oldPrice","objective":"dummy"},"color":"gray"},{"text":" → $","color":"white"},{"score":{"name":"#rancherStock","objective":"rancherStockPrice"},"color":"red"},{"text":" ▼","color":"red","bold":true}]