# Player wants to sell farmer stock
# Format: /trigger sellFarmerStock set <shares>

# Store requested amount
scoreboard players operation @s tradeAmount = @s sellFarmerStock

# Calculate value (price * shares * 0.95 after commission)
scoreboard players operation @s tradeCost = #farmerStock farmerStockPrice
scoreboard players operation @s tradeCost *= @s tradeAmount
scoreboard players operation @s commission = @s tradeCost
scoreboard players set @s stockTemp 20
scoreboard players operation @s commission /= @s stockTemp
scoreboard players operation @s tradeCost -= @s commission

# Enhanced insufficient shares message
execute unless score @s farmerShares >= @s tradeAmount run tellraw @s [{"text":"✗ Insufficient shares!","color":"red"}]
execute unless score @s farmerShares >= @s tradeAmount run tellraw @s [{"text":"You own: ","color":"yellow"},{"score":{"name":"@s","objective":"farmerShares"},"color":"white"},{"text":" Farmer shares","color":"yellow"}]
execute unless score @s farmerShares >= @s tradeAmount run tellraw @s [{"text":"You tried to sell: ","color":"yellow"},{"score":{"name":"@s","objective":"tradeAmount"},"color":"white"},{"text":" shares","color":"yellow"}]
execute unless score @s farmerShares >= @s tradeAmount run scoreboard players operation @s shareValue = @s tradeAmount
execute unless score @s farmerShares >= @s tradeAmount run scoreboard players operation @s shareValue -= @s farmerShares
execute unless score @s farmerShares >= @s tradeAmount run tellraw @s [{"text":"You need ","color":"red"},{"score":{"name":"@s","objective":"shareValue"},"color":"white"},{"text":" more shares!","color":"red"}]

# If player has enough shares, complete the transaction
execute if score @s farmerShares >= @s tradeAmount run function economy:stock_market/transaction/sell_farmer_transaction

# Reset trigger
scoreboard players set @s sellFarmerStock 0
scoreboard players enable @s sellFarmerStock